/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.models.domain.CalculoComprasModel;
import ec.tws2.back.contfiables.models.entities.facturacion.TDetalleComprobanteAjuste;
import ec.tws2.back.contfiables.models.entities.facturacion.TDetalleComprobanteCompra;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TDetalleTransferenciaInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.services.InventariosCalculosService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventariosCalculosServiceImpl
implements InventariosCalculosService {
    @Autowired
    private TInventarioDAO inventarioDAO;

    public CalculoComprasModel obtenerNuevosPrecios(TDetalleComprobanteCompra det) {
        CalculoComprasModel calculo = new CalculoComprasModel();
        TInventario productoIve = det.getProductoInventario();
        TInventario productoIveDB = this.inventarioDAO.findById((Object)productoIve.getIdInventario()).orElse(null);
        BigDecimal porcentualIva = BigDecimal.valueOf(det.getImpuestoCompra()).divide(new BigDecimal("100"));
        BigDecimal stockEntrada = det.getCantidad().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoUnitarioEntrada = det.getCostoUnitario().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoTotalEntrada = stockEntrada.multiply(costoUnitarioEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoTotalEntradaSinImpuesto = costoTotalEntrada.setScale(4, RoundingMode.HALF_UP);
        BigDecimal descuento = det.getDescuento().setScale(4, RoundingMode.HALF_UP);
        costoTotalEntrada = costoTotalEntrada.subtract(descuento).setScale(4, RoundingMode.HALF_UP);
        costoTotalEntradaSinImpuesto = costoTotalEntradaSinImpuesto.subtract(descuento).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoTotal = productoIveDB.getCostoTotal().add(costoTotalEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoStockTotal = productoIveDB.getStock().add(stockEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoUnitario = nuevoCostoTotal.divide(nuevoStockTotal, 4, RoundingMode.HALF_UP);
        BigDecimal impuestosCompra = costoTotalEntrada.multiply(porcentualIva).setScale(4, RoundingMode.HALF_UP);
        nuevoCostoTotal = nuevoCostoTotal.setScale(4, RoundingMode.HALF_UP);
        calculo.setStockEntrada(stockEntrada);
        calculo.setCostoTotalEntrada(costoTotalEntrada);
        calculo.setCostoUnitarioEntrada(costoUnitarioEntrada);
        calculo.setNuevoCostoTotal(nuevoCostoTotal);
        calculo.setNuevoCostoUnitario(nuevoCostoUnitario);
        calculo.setNuevoStockTotal(nuevoStockTotal);
        calculo.setImpuestos(impuestosCompra);
        calculo.setDescuento(descuento);
        calculo.setSubTotal(costoTotalEntradaSinImpuesto);
        return calculo;
    }

    public CalculoComprasModel obtenerNuevosPreciosAjustes(TDetalleComprobanteAjuste det, String tipoAjuste) {
        CalculoComprasModel calculo = new CalculoComprasModel();
        BigDecimal costoUnitarioActual = BigDecimal.ZERO;
        BigDecimal stockMovimiento = det.getCantidad().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoUnitMovimiento = det.getCostoUnitario().setScale(4, RoundingMode.HALF_UP);
        BigDecimal totalMovimiento = stockMovimiento.multiply(costoUnitMovimiento).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoUnitario = BigDecimal.ZERO;
        BigDecimal nuevoCostoTotal = BigDecimal.ZERO;
        BigDecimal nuevoStock = BigDecimal.ZERO;
        TInventario productoIveDB = this.inventarioDAO.findById((Object)det.getProductoInventario().getIdInventario()).orElse(null);
        BigDecimal ultCostoUnitario = productoIveDB.getCostoUnitario();
        if (stockMovimiento.compareTo(BigDecimal.ZERO) <= 0) {
            throw new CustomException("No es posible procesar la trasacci\u00f3n con una cantidad de '0' o menor");
        }
        if (costoUnitMovimiento.compareTo(BigDecimal.ZERO) <= 0) {
            throw new CustomException("No es posible procesar la trasacci\u00f3n con un costo de '0' o menor");
        }
        if (totalMovimiento.compareTo(productoIveDB.getCostoTotal()) > 0) {
            throw new CustomException("El valor a realizar el ajuste es mayor a las existencias");
        }
        switch (tipoAjuste.trim()) {
            case "AJC": {
                if (!det.getDebitoCredito().equals("debito")) {
                    throw new CustomException("Error al realizar el tipo de ajuste, solo se permite d\u00e9bito");
                }
                nuevoStock = productoIveDB.getStock().add(stockMovimiento);
                nuevoCostoTotal = productoIveDB.getCostoTotal().add(totalMovimiento);
                nuevoCostoUnitario = nuevoCostoTotal.divide(nuevoStock, 4, RoundingMode.HALF_UP);
                nuevoCostoTotal = nuevoCostoTotal.setScale(4, RoundingMode.HALF_UP);
                break;
            }
            case "AJU": {
                if (det.getDebitoCredito().equals("debito")) {
                    stockMovimiento = det.getCantidad();
                    totalMovimiento = BigDecimal.ZERO;
                    costoUnitarioActual = productoIveDB.getCostoUnitario();
                    nuevoStock = productoIveDB.getStock().add(stockMovimiento);
                    nuevoCostoTotal = costoUnitarioActual.multiply(nuevoStock).setScale(4, RoundingMode.HALF_UP);
                    nuevoCostoUnitario = costoUnitarioActual;
                    break;
                }
                stockMovimiento = det.getCantidad();
                totalMovimiento = BigDecimal.ZERO;
                costoUnitarioActual = productoIveDB.getCostoUnitario();
                nuevoStock = productoIveDB.getStock().subtract(stockMovimiento);
                if (nuevoStock.compareTo(BigDecimal.ZERO) < 0) {
                    throw new CustomException("El ajuste es mayor a las existencias");
                }
                nuevoCostoTotal = costoUnitarioActual.multiply(nuevoStock).setScale(4, RoundingMode.HALF_UP);
                nuevoCostoUnitario = costoUnitarioActual;
                break;
            }
            case "AJP": {
                if (!det.getDebitoCredito().equals("credito")) {
                    throw new CustomException("Para el tipo de transacci\u00f3n: " + tipoAjuste + ", solo se permite en cr\u00e9dito.");
                }
                stockMovimiento = det.getCantidad();
                costoUnitMovimiento = productoIveDB.getCostoUnitario();
                totalMovimiento = stockMovimiento.multiply(costoUnitMovimiento).setScale(4, RoundingMode.HALF_UP);
                nuevoStock = productoIveDB.getStock().subtract(stockMovimiento);
                nuevoCostoTotal = productoIveDB.getCostoTotal().subtract(totalMovimiento);
                nuevoCostoUnitario = nuevoCostoTotal.divide(nuevoStock, 4, RoundingMode.HALF_UP);
                break;
            }
            default: {
                throw new CustomException("El tipo de transacci\u00f3n no es correcta.");
            }
        }
        if (nuevoCostoUnitario.compareTo(BigDecimal.ZERO) == 0) {
            nuevoCostoUnitario = ultCostoUnitario;
        }
        calculo.setStockEntrada(stockMovimiento);
        calculo.setCostoTotalEntrada(totalMovimiento);
        calculo.setCostoUnitarioEntrada(costoUnitMovimiento);
        calculo.setNuevoCostoTotal(nuevoCostoTotal);
        calculo.setNuevoCostoUnitario(nuevoCostoUnitario);
        calculo.setNuevoStockTotal(nuevoStock);
        return calculo;
    }

    public CalculoComprasModel eliminarYObtenerNuevosPrecios(TDetalleComprobanteCompra det) {
        CalculoComprasModel calculo = new CalculoComprasModel();
        TInventario productoIve = det.getProductoInventario();
        TInventario productoIveDB = this.inventarioDAO.findById((Object)productoIve.getIdInventario()).orElse(null);
        if (productoIveDB == null) {
            throw new CustomException("No existe el producto a realizar la transacci\u00f3n");
        }
        BigDecimal stockEntrada = det.getCantidad().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoUnitarioEntrada = det.getCostoUnitario().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoTotalEntrada = stockEntrada.multiply(costoUnitarioEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal descuento = det.getDescuento().setScale(4, RoundingMode.HALF_UP);
        costoTotalEntrada = costoTotalEntrada.add(descuento).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoTotal = productoIveDB.getCostoTotal().subtract(costoTotalEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoTotalEntradaSinImpuesto = costoTotalEntrada.setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoStockTotal = productoIveDB.getStock().subtract(stockEntrada).setScale(4, RoundingMode.HALF_UP);
        if (costoTotalEntradaSinImpuesto.compareTo(BigDecimal.ZERO) < 0 || nuevoStockTotal.compareTo(BigDecimal.ZERO) < 0) {
            throw new CustomException("Ya no es posible eliminar esta compra, no existen los valores necesarios.");
        }
        BigDecimal nuevoCostoUnitario = new BigDecimal(0.0);
        if (nuevoStockTotal.compareTo(BigDecimal.ZERO) == 0) {
            nuevoCostoUnitario = productoIveDB.getCostoUnitario();
        } else {
            nuevoCostoTotal.divide(nuevoStockTotal, 4, RoundingMode.HALF_UP);
        }
        BigDecimal impuestosCompra = new BigDecimal(0.0);
        calculo.setStockEntrada(stockEntrada);
        calculo.setCostoTotalEntrada(costoTotalEntrada);
        calculo.setCostoUnitarioEntrada(costoUnitarioEntrada);
        calculo.setNuevoCostoTotal(nuevoCostoTotal);
        calculo.setNuevoCostoUnitario(nuevoCostoUnitario);
        calculo.setNuevoStockTotal(nuevoStockTotal);
        calculo.setImpuestos(impuestosCompra);
        calculo.setDescuento(descuento);
        calculo.setSubTotal(costoTotalEntradaSinImpuesto);
        return calculo;
    }

    public CalculoComprasModel obtenerNuevosPreciosIngreso(TDetalleTransferenciaInventario det, TBodega bodegaEntrante) {
        CalculoComprasModel calculo = new CalculoComprasModel();
        TInventario productoInvBodegaEntrada = this.inventarioDAO.findByBodegaAndProducto(bodegaEntrante, det.getProductoInventario().getProducto());
        BigDecimal stockEntrada = det.getCantidad().setScale(2, RoundingMode.HALF_UP);
        BigDecimal costoUnitarioEntrada = det.getCostoUnitario().setScale(4, RoundingMode.HALF_UP);
        BigDecimal costoTotalEntrada = stockEntrada.multiply(costoUnitarioEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoTotal = productoInvBodegaEntrada.getCostoTotal().add(costoTotalEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoStockTotal = productoInvBodegaEntrada.getStock().add(stockEntrada).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoUnitario = nuevoCostoTotal.divide(nuevoStockTotal, 4, RoundingMode.HALF_UP);
        calculo.setStockEntrada(stockEntrada);
        calculo.setCostoTotalEntrada(costoTotalEntrada);
        calculo.setCostoUnitarioEntrada(costoUnitarioEntrada);
        calculo.setNuevoCostoTotal(nuevoCostoTotal);
        calculo.setNuevoCostoUnitario(nuevoCostoUnitario);
        calculo.setNuevoStockTotal(nuevoStockTotal);
        calculo.setImpuestos(BigDecimal.ZERO);
        calculo.setDescuento(BigDecimal.ZERO);
        calculo.setSubTotal(costoTotalEntrada);
        return calculo;
    }
}

