/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.services.InventarioService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InventarioServiceImpl
implements InventarioService {
    @Autowired
    private TInventarioDAO inventarioDAO;

    public ResponseEntity<RespSimple> actualizarCostoStockProducto() {
        return null;
    }

    public BigDecimal validarStock(TBodega bodega, TProducto producto, BigDecimal cantidad, BigDecimal precioVenta) {
        TInventario productoInventario = this.inventarioDAO.findByBodegaAndProducto(bodega, producto);
        if (productoInventario == null) {
            throw new CustomExceptionNoCleanData("No existe inventario para el producto: " + producto.getCodigo());
        }
        BigDecimal stockExistente = productoInventario.getStock();
        BigDecimal costoUnitario = productoInventario.getCostoUnitario();
        if (precioVenta.compareTo(costoUnitario) == -1) {
            throw new CustomExceptionNoCleanData("El precio de venta del producto: " + producto.getCodigo() + " - " + producto.getNombreProducto() + " es menor al costo del producto");
        }
        if (stockExistente.compareTo(cantidad) == -1) {
            throw new CustomExceptionNoCleanData("La cantidad del producto: " + producto.getCodigo() + " - " + producto.getNombreProducto() + " supera las existencias");
        }
        return costoUnitario.multiply(cantidad).setScale(4, RoundingMode.HALF_UP);
    }

    public void egresoPorVenta(TBodega bodega, TProducto producto, BigDecimal cantidad) throws CustomExceptionNoCleanData {
        TInventario productoInventario = this.inventarioDAO.findByBodegaAndProducto(bodega, producto);
        if (productoInventario == null) {
            throw new CustomExceptionNoCleanData("No existe inventario para el producto: " + producto.getCodigo());
        }
        BigDecimal stockExistente = productoInventario.getStock().setScale(2, RoundingMode.HALF_UP);
        BigDecimal costoUnitActual = productoInventario.getCostoUnitario();
        BigDecimal costoTotalExistante = productoInventario.getCostoTotal();
        BigDecimal costoSaliente = costoUnitActual.multiply(cantidad).setScale(4, RoundingMode.HALF_UP);
        BigDecimal nuevoStock = stockExistente.subtract(cantidad).setScale(2, RoundingMode.HALF_UP);
        BigDecimal nuevoCostoTotal = costoTotalExistante.subtract(costoSaliente).setScale(4, RoundingMode.HALF_UP);
        productoInventario.setStock(nuevoStock);
        productoInventario.setCostoTotal(nuevoCostoTotal);
        this.inventarioDAO.save((Object)productoInventario);
    }
}

