/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.ComponentModelDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.inventario.TComponente;
import ec.tws2.back.contfiables.models.entities.inventario.TSecuenciaComponente;
import ec.tws2.back.contfiables.models.entities.inventario.TUnidadMedida;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TComponenteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TSecuenciaComponenteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TUnidadMedidaDAO;
import ec.tws2.back.contfiables.services.ComponenteService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ComponenteServiceImpl
implements ComponenteService {
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TUnidadMedidaDAO unidadMedidaDAO;
    @Autowired
    private TSecuenciaComponenteDAO secuenciaComponenteDAO;
    @Autowired
    private TComponenteDAO componenteDAO;
    private Logger log = Logger.getLogger(ComponenteServiceImpl.class.getName());

    @Transactional
    public ResponseEntity<RespSimple> guardarComponenteClienteNEW(ComponentModelDTO componenteDTO) {
        this.log.info("GUARDANDO COMPONENTE");
        try {
            TCliente cliente = this.clienteDAO.findById((Object)componenteDTO.getIdCliente()).orElse(null);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"Cliente no identificado");
            }
            TComponente componente = new TComponente();
            componenteDTO.setCodigoComponente(componenteDTO.getCodigoComponente().replace(" ", ""));
            if (componenteDTO.getIdUnidadMedida() == null || componenteDTO.getIdUnidadMedida() == 0L) {
                List idsUnidadMedida = this.unidadMedidaDAO.getIdsunidadMedida(cliente.getIdCliente());
                if (idsUnidadMedida.isEmpty()) {
                    throw new CustomException("La unidad de medida es requerida");
                }
                componente.setUnidadMedida(new TUnidadMedida((Long)idsUnidadMedida.get(0)));
            } else {
                componente.setUnidadMedida(new TUnidadMedida(componenteDTO.getIdUnidadMedida()));
            }
            if (componenteDTO.getIdComponente() == null || componenteDTO.getIdComponente() == BigDecimal.ZERO) {
                TSecuenciaComponente tsecuenciaComponente = this.secuenciaComponenteDAO.findByCliente(cliente);
                tsecuenciaComponente.setSecuencia(Integer.valueOf(tsecuenciaComponente.getSecuencia() + 1));
                this.secuenciaComponenteDAO.save((Object)tsecuenciaComponente);
                if (this.componenteDAO.existsByCodigoComponenteAndCliente(componenteDTO.getCodigoComponente(), cliente)) {
                    throw new CustomException("Componente no registrado, ya existe un producto con el c\u00f3digo: " + componenteDTO.getCodigoComponente());
                }
                componente.setNombreComponente(componenteDTO.getNombreComponente());
                componente.setCodigoComponente(componenteDTO.getCodigoComponente());
                componente.setCreatedAt(new Date());
                componente.setActivo(componenteDTO.getActivo());
                componente.setCliente(cliente);
                this.componenteDAO.save((Object)componente);
                return Transaccion.CREATED((String)"Componente guardado correctamente");
            }
            TComponente existeComponenteBD = this.componenteDAO.findByCodigoComponenteAndCliente(componenteDTO.getCodigoComponente(), cliente);
            if (existeComponenteBD != null && existeComponenteBD.getIdComponente().compareTo(componenteDTO.getIdComponente()) != 0) {
                throw new CustomException("Componente no registrado, ya existe un componente con el c\u00f3digo: " + componenteDTO.getCodigoComponente());
            }
            TComponente tComponente = this.componenteDAO.findById((Object)componenteDTO.getIdComponente()).orElse(null);
            tComponente.setNombreComponente(componenteDTO.getNombreComponente());
            tComponente.setCodigoComponente(componenteDTO.getCodigoComponente());
            tComponente.setUpdatedAt(new Date());
            tComponente.setActivo(componenteDTO.getActivo());
            tComponente.setCliente(cliente);
            this.componenteDAO.save((Object)tComponente);
            return Transaccion.CREATED((String)"Componente actualizado correctamente");
        }
        catch (CustomException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al actualizar componente".concat(e.getMessage()));
            return Transaccion.CUSTOM_EXCEPTION((String)e.getMessage());
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.warning("Error al guardar componente".concat(e.getMessage()));
            return Transaccion.ERROR((String)"Error al guardar el componente.");
        }
    }

    public ResponseEntity<RespSimple> obtenerComponentesDTOFront(Long idCliente) {
        return Transaccion.OK((String)"Lista obtenida", (Object)this.componenteDAO.obtenerComponentesFrontCustom(idCliente));
    }

    public ResponseEntity<RespSimple> getComponenteDTO(Long idComponente) {
        try {
            return Transaccion.OK((String)"Componente obtenido", (Object)this.componenteDAO.getComponenteDTO(idComponente));
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener el componente");
        }
    }
}

