/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.inventario;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TBodegaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.services.BodegaService;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class BodegaServiceImpl
implements BodegaService {
    @Autowired
    private TBodegaDAO bodegaDAO;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TProductoDAO productoDAO;
    @Autowired
    private TInventarioDAO inventarioDAO;

    @Transactional
    public ResponseEntity<RespSimple> guardarBodega(TBodega bodega) {
        try {
            boolean existeCliente = this.clienteDAO.existsById((Object)bodega.getCliente().getIdCliente());
            if (!existeCliente) {
                RespSimple response = new RespSimple("Info", "Error al validar la identidad del Cliente.", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            boolean existe = this.bodegaDAO.existsByClienteAndCodigo(bodega.getCliente(), bodega.getCodigo());
            if (existe) {
                RespSimple response = new RespSimple("Info", "Ya existe una bodega con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            TBodega bodegaDB = (TBodega)this.bodegaDAO.save((Object)bodega);
            List listProductoInventariable = this.productoDAO.findByClienteAndInventariable(bodega.getCliente(), true);
            for (TProducto p : listProductoInventariable) {
                TInventario inventario = new TInventario();
                inventario.setProducto(p);
                inventario.setCostoUnitario(new BigDecimal("0.00"));
                inventario.setCostoTotal(new BigDecimal("0.00"));
                inventario.setImpuestoCompra(Long.valueOf(0L));
                inventario.setCreatedAt(new Date());
                inventario.setStock(new BigDecimal("0.0"));
                inventario.setBodega(bodegaDB);
                this.inventarioDAO.save((Object)inventario);
            }
            RespSimple response = new RespSimple("Info", "Bodega registrada", ContfiablesEnum.TRANSACCION_OK.getId(), "", null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            RespSimple response = new RespSimple("Info", "Error al registrar", ContfiablesEnum.TRANSACCION_ERROR.getId(), e.getMessage(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> actualizarBodega(TBodega bodega) {
        try {
            TBodega bodegaDB = this.bodegaDAO.findById((Object)bodega.getIdBodega()).orElse(null);
            if (bodegaDB == null) {
                RespSimple response = new RespSimple("Info", "No existe un registro con ese id", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TBodega bodegaExiste = this.bodegaDAO.findByClienteAndCodigo(bodega.getCliente(), bodega.getCodigo());
            if (bodegaExiste != null && bodega.getIdBodega() != bodegaExiste.getIdBodega()) {
                RespSimple response = new RespSimple("Info", "Ya existe una bodega con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            bodegaDB.setNombre(bodega.getNombre());
            bodegaDB.setVolumenBruto(bodega.getVolumenBruto());
            bodegaDB.setVolumenNeto(bodega.getVolumenNeto());
            bodegaDB.setMostrarSaldo(bodega.getMostrarSaldo());
            bodegaDB.setPrincipal(bodega.getPrincipal());
            bodegaDB.setActivo(bodega.getActivo());
            bodegaDB.setCallePrincipal(bodega.getCallePrincipal());
            bodegaDB.setCalleSecundaria(bodega.getCalleSecundaria());
            bodegaDB.setCalleNumeracion(bodega.getCalleNumeracion());
            bodegaDB.setCodigo(bodega.getCodigo());
            this.bodegaDAO.save((Object)bodegaDB);
            RespSimple response = new RespSimple("Info", "Datos actualizados", ContfiablesEnum.TRANSACCION_OK.getId(), null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al actualizar los datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> listarBodegasCliente(Long idCliente, String activo) {
        try {
            if (activo.equals("activo")) {
                return Transaccion.OK((String)"Lista obtenida", (Object)this.bodegaDAO.findByClienteAndActivoOrderByIdBodegaDesc(new TCliente(idCliente), true));
            }
            if (activo.equals("")) {
                return Transaccion.OK((String)"Lista obtenida", (Object)this.bodegaDAO.findByClienteOrderByIdBodegaDesc(new TCliente(idCliente)));
            }
            return Transaccion.CUSTOM_EXCEPTION((String)"Parametro de busqueda no identificado");
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener la lista de bodegas");
        }
    }

    public ResponseEntity<RespSimple> obtenerBodegaById(Long idBodega, Long idCliente) {
        try {
            TCliente cliente = new TCliente();
            cliente.setIdCliente(idCliente);
            TBodega bodega = this.bodegaDAO.findByIdBodegaAndCliente(idBodega, cliente);
            if (bodega == null) {
                RespSimple response = new RespSimple("Info", "No existe un registro con esos datos", ContfiablesEnum.TRANSACCION_ERROR.getId(), null);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            RespSimple response = new RespSimple("Info", "Dato obtenido", ContfiablesEnum.TRANSACCION_OK.getId(), (Object)bodega);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            RespSimple response = new RespSimple("Info", "Error al obtener el registro", ContfiablesEnum.TRANSACCION_ERROR.getId(), "", null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

