/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.integracion;

import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.models.domain.ReporteModel;
import ec.tws2.back.contfiables.models.domain.RequestReportModel;
import ec.tws2.back.contfiables.models.dtos.Factura.FacturaDTO80mm;
import ec.tws2.back.contfiables.models.dtos.Factura.PreFacturaDTO80mm;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDetalleDAO;
import ec.tws2.back.contfiables.services.ReportService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportServiceImpl
implements ReportService {
    Logger log = Logger.getLogger(ReportServiceImpl.class.getName());
    @Value(value="${path.pc}")
    private String basePath;
    private static final String REPORT_FOLDER = "reports";
    private static final String JASPER = ".jasper";
    private static final String JRXML = ".jrxml";
    private static final int AMBIENTE_INDEX = 23;
    private static final int TIPO_EMISION_INDEX = 47;
    @Autowired
    private TFacturaDAO facturaDAO;
    @Autowired
    private TFacturaDetalleDAO detalleFacturaDAO;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ObjectMapper objectMapper;

    public ResponseEntity<Resource> getReportParams(RequestReportModel body) {
        String fileName = body.getReportName();
        Object extension = body.getExtension();
        Integer clientId = body.getClientId();
        extension = "." + (String)extension;
        try {
            ClassPathResource file = new ClassPathResource("reports" + File.separator + fileName + ".jrxml");
            if (!file.exists()) {
                this.log.info("El archivo de reporte no fue encontrado: " + file.getPath());
            }
            this.log.info("El archivo  fue encontrado: " + file.getPath());
            Map parameters = body.getParams();
            parameters.put("idcliente", clientId);
            JasperReport report = JasperCompileManager.compileReport((InputStream)file.getInputStream());
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (Connection)this.dataSource.getConnection());
            byte[] reporte = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
            StringBuilder stringBuilder = new StringBuilder().append("InvoicePDF:");
            ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(stringBuilder.append("pruebaaaaaaaaa").append((String)extension).toString()).build();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentDisposition(contentDisposition);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength((long)reporte.length).contentType(MediaType.APPLICATION_PDF).headers(headers)).body((Object)new ByteArrayResource(reporte));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error", e);
            return null;
        }
    }

    public ResponseEntity<Resource> getReport(ReporteModel reporteModel) {
        HashMap parameters = new HashMap();
        try {
            BigDecimal idFactura = reporteModel.getId();
            String nombre = reporteModel.getNombre();
            String fileName = "reportprinter";
            if (nombre.equals("factura80mm")) {
                parameters = this.getFacturaReport(idFactura);
                ClassPathResource file = new ClassPathResource("reports" + File.separator + fileName + ".jasper");
                this.log.info(file.getPath());
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)file.getInputStream());
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)new JREmptyDataSource());
                byte[] reporte = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                String name = LocalDateTime.now().toString().concat(String.valueOf(idFactura));
                StringBuilder stringBuilder = new StringBuilder().append("InvoicePDF:");
                ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(stringBuilder.append(name).append(".pdf").toString()).build();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentDisposition(contentDisposition);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength((long)reporte.length).contentType(MediaType.APPLICATION_PDF).headers(headers)).body((Object)new ByteArrayResource(reporte));
            }
            return ResponseEntity.noContent().build();
        }
        catch (CustomException e) {
            this.log.severe("ERROR AL CONSUMIR REPORTE: ".concat(e.getMessage()));
            return null;
        }
        catch (Exception e) {
            this.log.severe("ERROR AL CONSUMIR REPORTE: ".concat(e.getMessage()));
            return null;
        }
    }

    public ResponseEntity<Resource> getPreFacturaReport(PreFacturaDTO80mm reporteModel, String reportName) {
        HashMap parameters = new HashMap();
        try {
            String nombre = reportName;
            String fileName = "prefactura";
            if (nombre.equals("prefactura")) {
                parameters = this.getPreFacturaData(reporteModel);
                ClassPathResource file = new ClassPathResource("reports" + File.separator + fileName + ".jasper");
                this.log.info(file.getPath());
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)file.getInputStream());
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)new JREmptyDataSource());
                byte[] reporte = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                StringBuilder stringBuilder = new StringBuilder().append("InvoicePDF:");
                ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(stringBuilder.append("prefactura").append(".pdf").toString()).build();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentDisposition(contentDisposition);
                this.log.info("devuelve reporte con datos " + reporte.length);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength((long)reporte.length).contentType(MediaType.APPLICATION_PDF).headers(headers)).body((Object)new ByteArrayResource(reporte));
            }
            this.log.info("devuelve vacio");
            return ResponseEntity.noContent().build();
        }
        catch (CustomException e) {
            this.log.severe("ERROR AL CONSUMIR REPORTE: ".concat(e.getMessage()));
            return null;
        }
        catch (Exception e) {
            this.log.severe("ERROR AL CONSUMIR REPORTE: ".concat(e.getMessage()));
            return null;
        }
    }

    private final HashMap<String, Object> getFacturaReport(BigDecimal idFactura) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        FacturaDTO80mm facturaDTO = this.facturaDAO.obtenerDatosFacturaReporte80mm(idFactura);
        if (facturaDTO == null) {
            throw new CustomException("No existe la factura con el n\u00famero de autorizaci\u00f3n solicitado.");
        }
        String claveAcceso = facturaDTO.getAutorizacion();
        String ambiente = ReportServiceImpl.ambienteDesdeClave((String)claveAcceso);
        String tipoEmision = ReportServiceImpl.tipoEmisionDesdeClave((String)claveAcceso);
        String formaPago = ReportServiceImpl.aliasDesdeId((int)facturaDTO.getFormaPago());
        String establecimiento = facturaDTO.getEstablecimiento();
        String puntoEmision = facturaDTO.getPuntoEmision();
        String numComprobante = establecimiento.concat("-").concat(puntoEmision).concat("-").concat(facturaDTO.getNumeroComprobante());
        String nombreFantasia = facturaDTO.getNombreComercial();
        String nomEmpresa = facturaDTO.getNombresEmpresa().concat(" ").concat(facturaDTO.getApellidosEmpresa());
        this.log.info("DEBUG formaPago(id=" + facturaDTO.getFormaPago() + ") = " + formaPago);
        parameters.put("logo", this.getClientLogo(facturaDTO.getRuc()));
        parameters.put("telefonoEmpresa", facturaDTO.getTelefonoEmpresa());
        parameters.put("numComprobante", numComprobante);
        parameters.put("autorizacion", claveAcceso);
        parameters.put("ambiente", ambiente);
        parameters.put("tipoEmision", tipoEmision);
        parameters.put("fechaEmision", facturaDTO.getFechaEmision());
        parameters.put("obligadoContabilidad", facturaDTO.getObligadoContabilidad() != false ? "Si" : "NO");
        parameters.put("ruc", facturaDTO.getRuc());
        parameters.put("nomEmpresa", nombreFantasia != null && !nombreFantasia.isBlank() ? nombreFantasia : nomEmpresa);
        parameters.put("empresaDir", facturaDTO.getDireccionPuntoEmision() == null ? facturaDTO.getDireccionEmpresa() : facturaDTO.getDireccionPuntoEmision());
        parameters.put("correoEmpresa", facturaDTO.getCorreoEmpresa());
        parameters.put("razonSocialAdquiriente", facturaDTO.getRazonSocialAdquiriente());
        parameters.put("identificacionAdquiriente", facturaDTO.getIdentificacionAdquiriente());
        parameters.put("direccionAdquiriente", facturaDTO.getDireccionAdquiriente());
        parameters.put("telefonoAdquiriente", facturaDTO.getTelefonoAdquiriente());
        parameters.put("observaciones", facturaDTO.getObservaciones());
        parameters.put("formaPago", formaPago);
        parameters.put("impuestos", facturaDTO.getIva().setScale(2, RoundingMode.HALF_UP));
        parameters.put("subtotal", facturaDTO.getSubtotal().setScale(2, RoundingMode.HALF_UP));
        parameters.put("descuento", facturaDTO.getDescuento().setScale(2, RoundingMode.HALF_UP));
        parameters.put("total", facturaDTO.getTotal().setScale(2, RoundingMode.HALF_UP));
        parameters.put("detalle", new JRBeanCollectionDataSource((Collection)this.detalleFacturaDAO.findDetailFactura(idFactura)));
        return parameters;
    }

    public HashMap<String, Object> getPreFacturaData(PreFacturaDTO80mm facturaDTO) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.setFechaEmisionIfNull(facturaDTO);
            Date fechaEmisionDate = this.convertToDate(facturaDTO.getFechaEmision());
            Map tempMap = (Map)this.objectMapper.convertValue((Object)facturaDTO, Map.class);
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource((Collection)facturaDTO.getLstDetalle());
            parameters.put("detalle", dataSource);
            parameters.putAll(new HashMap(tempMap));
            parameters.put("fechaEmision", fechaEmisionDate);
            return parameters;
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    private void setFechaEmisionIfNull(PreFacturaDTO80mm facturaDTO) {
        if (facturaDTO.getFechaEmision() == null) {
            facturaDTO.setFechaEmision(LocalDate.now());
        }
    }

    private Date convertToDate(LocalDate localDate) {
        ZoneId zoneId = ZoneId.of("America/Guayaquil");
        LocalDateTime localDateTime = localDate.atTime(LocalTime.now());
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    private InputStream getClientLogo(String identification) {
        try {
            String logoPath = this.basePath + identification + "/" + identification + ".png";
            File file = new File(logoPath);
            return new FileInputStream(file);
        }
        catch (Exception e) {
            this.log.severe("ERROR AL OBTENER LOGO: ".concat(e.getMessage()));
            return null;
        }
    }

    private static boolean isClaveAccesoValida(String clave) {
        return clave != null && clave.length() == 49 && clave.chars().allMatch(Character::isDigit);
    }

    private static String ambienteDesdeClave(String clave) {
        if (!ReportServiceImpl.isClaveAccesoValida((String)clave)) {
            return "DESCONOCIDO";
        }
        char c = clave.charAt(23);
        switch (c) {
            case '1': {
                return "PRUEBAS";
            }
            case '2': {
                return "PRODUCCI\u00d3N";
            }
        }
        return "DESCONOCIDO";
    }

    private static String tipoEmisionDesdeClave(String clave) {
        if (!ReportServiceImpl.isClaveAccesoValida((String)clave)) {
            return "DESCONOCIDO";
        }
        char c = clave.charAt(47);
        if (c == '1') {
            return "NORMAL";
        }
        if (c == '2') {
            return "CONTINGENCIA";
        }
        return "DESCONOCIDO";
    }

    private static String aliasDesdeId(int id) {
        switch (id) {
            case 1: {
                return "Efectivo";
            }
            case 2: {
                return "Compensaci\u00f3n de Deudas";
            }
            case 3: {
                return "Tarjeta de D\u00e9bito";
            }
            case 4: {
                return "Dinero Electr\u00f3nico";
            }
            case 5: {
                return "Tarjeta Prepago";
            }
            case 6: {
                return "Tarjeta de Cr\u00e9dito";
            }
            case 7: {
                return "Otros con Sistema Financiero";
            }
            case 8: {
                return "Endoso de T\u00edtulos";
            }
        }
        return "Desconocido";
    }
}

