/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.integracion;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.security.Seguridad;
import ec.tws2.back.contfiables.models.domain.FileSignature;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.CertVencimiento;
import ec.tws2.back.contfiables.models.dtos.FirmaCaducidadContfiablesDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.services.FirmaElectronicaService;
import jakarta.transaction.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FirmaElectronicaServiceImpl
implements FirmaElectronicaService {
    private Logger log = Logger.getLogger(FirmaElectronicaServiceImpl.class.getName());
    @Value(value="${path.pc}")
    private String path;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private Seguridad seguridad;
    private final SimpleDateFormat SDF = new SimpleDateFormat("dd-MM-yyyy");

    public FirmaElectronicaServiceImpl() {
        this.SDF.setTimeZone(TimeZone.getTimeZone("America/Guayaquil"));
    }

    public RespSimple almacenarArchivo(FileSignature fileSignature) {
        RespSimple respuestaSimple = new RespSimple();
        try {
            File directorio = new File(this.path.concat(fileSignature.getCliente().getIdentification()));
            if (!directorio.exists()) {
                if (directorio.mkdirs()) {
                    this.log.info("DIRECTORIO CREADO CORRECTAMENTE");
                    this.createSubDirectory(fileSignature);
                    boolean ok = this.crearArchivo(fileSignature);
                    if (!ok) {
                        respuestaSimple.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
                        throw new CustomException("Error al verificar la firma o la clave de la misma.");
                    }
                    respuestaSimple.setError(ContfiablesEnum.TRANSACCION_OK.getId());
                    return respuestaSimple;
                }
                this.log.info("NO SE CREO EL DIRECTORIO");
                respuestaSimple.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
                throw new CustomException("Error al crear el DIRECTORIO.");
            }
            boolean ok = this.crearArchivo(fileSignature);
            if (!ok) {
                respuestaSimple.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
                throw new CustomException("Error al verificar la firma o la clave de la misma.");
            }
            respuestaSimple.setError(ContfiablesEnum.TRANSACCION_OK.getId());
            respuestaSimple.setParametroRespuesta(directorio.getAbsolutePath());
            return respuestaSimple;
        }
        catch (CustomException e) {
            this.log.log(Level.SEVERE, "ERROR AL ALMACENAR EL ARCHIVO", e);
            respuestaSimple.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuestaSimple.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuestaSimple.setMensaje(e.getMessage());
            return respuestaSimple;
        }
    }

    public void createSubDirectory(FileSignature fileSignature) {
        try {
            this.log.info("CREAR SUBDIRECTORIOS");
            File dirAut = new File(this.path.concat("").concat(fileSignature.getCliente().getIdentification()).concat("/").concat(ContfiablesEnum.NAME_DIR_AUTORIZADOS.getId()));
            File dirFirm = new File(this.path.concat("").concat(fileSignature.getCliente().getIdentification()).concat("/").concat(ContfiablesEnum.NAME_DIR_FIRMADOS.getId()));
            dirAut.mkdirs();
            dirFirm.mkdirs();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL CREAR EL SUBDIRECTORY ", e);
            throw new CustomException("Error al crear el subDIRECTORIO");
        }
    }

    public boolean crearArchivo(FileSignature fileSignature) {
        try {
            byte[] fileBytes = Base64.getDecoder().decode(fileSignature.getFile64());
            Path file = Files.write(Path.of(this.path.concat("/").concat(fileSignature.getCliente().getIdentification()).concat("/").concat(fileSignature.getCliente().getIdentification().concat(".p12")), new String[0]), fileBytes, new OpenOption[0]);
            this.log.info(() -> "[UPLOAD] Archivo=" + file + " | cliente=" + fileSignature.getCliente().getIdentification());
            boolean validacion = this.validarFirma(file.toString(), fileSignature);
            if (!validacion) {
                Files.deleteIfExists(file);
                return false;
            }
            return true;
        }
        catch (CustomException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new CustomException("El contenido Base64 del certificado (.p12) es inv\u00e1lido.");
        }
        catch (IOException e) {
            throw new CustomException("No se pudo crear o acceder al archivo de la firma en disco.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL CREAR EL ARCHIVO DE LA FIRMA ", e);
            throw new CustomException("Error al crear el archivo de la firma: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validarFirma(String file, FileSignature fileSignature) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try {
                keyStore.load(fileInputStream, fileSignature.getPassword().toCharArray());
            }
            catch (IOException e) {
                String m = e.getMessage() == null ? "" : e.getMessage().toLowerCase();
                Throwable cause = e.getCause();
                if (m.contains("password")) throw new CustomException("La contrase\u00f1a del archivo .p12 es incorrecta.");
                if (m.contains("tampered")) throw new CustomException("La contrase\u00f1a del archivo .p12 es incorrecta.");
                if (cause == null) throw new CustomException("No se pudo abrir el archivo de la firma (.p12).");
                if (!cause.getClass().getSimpleName().equals("UnrecoverableKeyException")) throw new CustomException("No se pudo abrir el archivo de la firma (.p12).");
                throw new CustomException("La contrase\u00f1a del archivo .p12 es incorrecta.");
            }
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases == null) throw new CustomException("El archivo .p12 no contiene certificados.");
            if (!aliases.hasMoreElements()) {
                throw new CustomException("El archivo .p12 no contiene certificados.");
            }
            String alias = aliases.nextElement();
            keyStore.getKey(alias, fileSignature.getPassword().toCharArray());
            Certificate certificate = keyStore.getCertificate(alias);
            if (certificate instanceof X509Certificate) {
                X509Certificate x = (X509Certificate)certificate;
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                sdf.setTimeZone(TimeZone.getTimeZone("America/Guayaquil"));
                try {
                    x.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    throw new CustomException("El certificado est\u00e1 caducado desde " + sdf.format(x.getNotAfter()) + ".");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (UnrecoverableKeyException e) {
            throw new CustomException("La clave privada del certificado es incorrecta.");
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CustomException("Error general al validar la firma.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Date obtenerFechaCaducidadP12(String identification, String password) {
        try {
            Path p12 = Paths.get(this.path, identification, identification + ".p12");
            if (!Files.isRegularFile(p12, new LinkOption[0])) {
                return null;
            }
            try (FileInputStream fis = new FileInputStream(p12.toFile());){
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(fis, password == null ? null : password.toCharArray());
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = ks.getCertificate(alias);
                    if (cert instanceof X509Certificate) {
                        Date date = ((X509Certificate)cert).getNotAfter();
                        return date;
                    }
                    Certificate[] chain = ks.getCertificateChain(alias);
                    if (chain == null) continue;
                    for (Certificate c : chain) {
                        if (!(c instanceof X509Certificate)) continue;
                        Date date = ((X509Certificate)c).getNotAfter();
                        return date;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public int persistirTodasLasFechasCaducidad() {
        List lista = this.listarFechasTodas();
        int actualizados = 0;
        for (CertVencimiento it : lista) {
            Date fecha;
            if (it == null || it.identification == null || it.identification.isBlank() || it.validoHasta == null || it.validoHasta.isBlank()) continue;
            try {
                SimpleDateFormat simpleDateFormat = this.SDF;
                synchronized (simpleDateFormat) {
                    fecha = this.SDF.parse(it.validoHasta);
                }
            }
            catch (Exception ex) {
                this.log.warning(() -> "[PERSIST][SKIP] " + it.identification + " -> fecha inv\u00e1lida: " + it.validoHasta);
                continue;
            }
            actualizados += this.clienteDAO.updateFechaCaducidadFirma(it.identification, fecha);
        }
        return actualizados;
    }

    private List<Path> listarCandidatosFirma(Path dir) throws IOException {
        ArrayList<Path> out = new ArrayList<Path>();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir, p -> Files.isRegularFile(p, new LinkOption[0]));){
            for (Path p2 : files) {
                String n = p2.getFileName().toString().toLowerCase(Locale.ROOT);
                if (!n.endsWith(".p12")) continue;
                out.add(p2);
            }
        }
        return out;
    }

    private KeyStore tryLoadPkcs12(Path p12, char[] password, String label) {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(p12.toFile());
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(fis, password);
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        fis.close();
        return keyStore;
    }

    private X509Certificate extractX509(KeyStore ks, char[] keyPassword) throws Exception {
        ArrayList<String> aliases = new ArrayList<String>();
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            aliases.add(e.nextElement());
        }
        for (String a : aliases) {
            Certificate c = ks.getCertificate(a);
            if (c instanceof X509Certificate) {
                X509Certificate x = (X509Certificate)c;
                return x;
            }
            Certificate[] chain = ks.getCertificateChain(a);
            if (chain == null) continue;
            for (Certificate cc : chain) {
                if (!(cc instanceof X509Certificate)) continue;
                X509Certificate x = (X509Certificate)cc;
                return x;
            }
        }
        if (keyPassword != null) {
            KeyStore.PasswordProtection prot = new KeyStore.PasswordProtection(keyPassword);
            for (String a : aliases) {
                try {
                    X509Certificate x;
                    KeyStore.Entry entry = ks.getEntry(a, prot);
                    if (!(entry instanceof KeyStore.PrivateKeyEntry) || (x = (X509Certificate)((KeyStore.PrivateKeyEntry)entry).getCertificate()) == null) continue;
                    return x;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private String getPasswordFromDB(String identification) {
        try {
            TCliente c = this.clienteDAO.getCliente4identificacion(identification);
            if (c == null || c.getClaveFirma() == null || c.getClaveFirma().isBlank()) {
                return null;
            }
            String pass = this.seguridad.decrypt(c.getClaveFirma());
            return pass;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<CertVencimiento> listarFechasTodas() {
        ArrayList<CertVencimiento> out = new ArrayList<CertVencimiento>();
        Path base = Paths.get(this.path == null ? "" : this.path, new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(base, new LinkOption[0])) {
            return out;
        }
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(base, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path dir : dirs) {
                String identification = dir.getFileName().toString();
                List p12s = this.listarCandidatosFirma(dir);
                if (p12s.isEmpty()) continue;
                for (Path p12 : p12s) {
                    CertVencimiento dto = new CertVencimiento();
                    dto.identification = identification;
                    dto.fileName = p12.getFileName().toString();
                    try {
                        String passDb;
                        char[] keyPwd;
                        KeyStore ks = this.tryLoadPkcs12(p12, "".toCharArray(), "EMPTY");
                        if (ks == null) {
                            ks = this.tryLoadPkcs12(p12, null, "NULL");
                        }
                        char[] cArray = keyPwd = (passDb = this.getPasswordFromDB(identification)) == null || passDb.isBlank() ? null : passDb.toCharArray();
                        if (ks == null && keyPwd != null) {
                            ks = this.tryLoadPkcs12(p12, keyPwd, "DB");
                        }
                        if (ks == null) {
                            dto.estado = "REQUIERE_PASSWORD";
                            out.add(dto);
                            continue;
                        }
                        X509Certificate x = this.extractX509(ks, keyPwd);
                        if (x == null && keyPwd != null && (ks = this.tryLoadPkcs12(p12, keyPwd, "DB(reload)")) != null) {
                            x = this.extractX509(ks, keyPwd);
                        }
                        if (x == null) {
                            dto.estado = keyPwd == null ? "REQUIERE_PASSWORD" : "ERROR";
                            out.add(dto);
                            continue;
                        }
                        dto.validoHasta = this.SDF.format(x.getNotAfter());
                        boolean vigente = new Date().before(x.getNotAfter()) && new Date().after(x.getNotBefore());
                        dto.estado = vigente ? "OK" : "CADUCADO";
                        out.add(dto);
                    }
                    catch (Exception e) {
                        dto.estado = "ERROR";
                        out.add(dto);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public FirmaCaducidadContfiablesDTO obtenerCaducidadPorIdCliente(Long idCliente) {
        this.log.info("obtenerCaducidadPorIdCliente: " + idCliente);
        Date fecha = this.clienteDAO.findFechaCaducidadFirma(idCliente);
        if (fecha == null) {
            return new FirmaCaducidadContfiablesDTO(null, 0L, "SIN_FECHA");
        }
        ZoneId zone = ZoneId.of("America/Guayaquil");
        LocalDate hoy = LocalDate.now(zone);
        LocalDate fin = fecha.toInstant().atZone(zone).toLocalDate();
        long dias = ChronoUnit.DAYS.between(hoy, fin);
        long diasRestantes = Math.max(0L, dias);
        String estado = hoy.isAfter(fin) ? "CADUCADO" : (dias <= 15L ? "POR_VENCER" : "OK");
        return new FirmaCaducidadContfiablesDTO(this.SDF.format(fecha), diasRestantes, estado);
    }

    public ResponseEntity<RespSimple> getAlertaCaducidadFirma(Long idCliente) {
        try {
            FirmaCaducidadContfiablesDTO dto = this.obtenerCaducidadPorIdCliente(idCliente);
            if (dto.getFechaCaducidad() == null) {
                return Transaccion.OK((String)"A\u00fan no has cargado una firma electr\u00f3nica.", (Object)dto);
            }
            if ("CADUCADO".equals(dto.getEstado())) {
                return Transaccion.OK((String)("Tu firma electr\u00f3nica ha caducado (venci\u00f3 el " + dto.getFechaCaducidad() + "). No podr\u00e1s emitir comprobantes electr\u00f3nicos hasta renovarla. Puedes obtener una nueva firma electr\u00f3nica en el siguiente enlace."), (Object)dto);
            }
            if ("POR_VENCER".equals(dto.getEstado())) {
                long dr = dto.getDiasRestantes();
                String unidad = dr == 1L ? "d\u00eda" : "d\u00edas";
                return Transaccion.OK((String)("Tu firma electr\u00f3nica caduca el " + dto.getFechaCaducidad() + ". Te quedan " + dto.getDiasRestantes() + " " + unidad + "."), (Object)dto);
            }
            return Transaccion.OK((String)"", (Object)dto);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL VALIDAR LA CADUCIDAD DE LA FIRMA", e);
            return Transaccion.ERROR((String)"ERROR AL VALIDAR LA CADUCIDAD DE LA FIRMA");
        }
    }
}

