/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.integracion;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.integracion.TConfiguracionUsuario;
import ec.tws2.back.contfiables.repositories.integracion.TConfiguracionUsuarioDAO;
import ec.tws2.back.contfiables.services.ConfiguracionUsuarioService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ConfiguracionServiceImpl
implements ConfiguracionUsuarioService {
    private static final Logger log = Logger.getLogger(ConfiguracionServiceImpl.class.getName());
    @Autowired
    private TConfiguracionUsuarioDAO configuracionUsuarioDAO;

    public ResponseEntity<RespSimple> saveConfiguracion(TConfiguracionUsuario configuracionUsuario) {
        try {
            if (configuracionUsuario.getUsername() == null) {
                return Transaccion.NOTFOUNT((String)"Error al identificar el usuario");
            }
            TConfiguracionUsuario config = this.configuracionUsuarioDAO.findByUsername(configuracionUsuario.getUsername());
            if (config == null) {
                this.configuracionUsuarioDAO.save((Object)configuracionUsuario);
                return Transaccion.CREATED((String)"Configuraciones de usuario creadas correctamente");
            }
            this.configuracionUsuarioDAO.save((Object)configuracionUsuario);
            return Transaccion.CREATED((String)"Configuraciones de usuario actualizadas correctamente");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error: ", e);
            return Transaccion.ERROR((String)"Error al registrar las configuraciones del usuario");
        }
    }

    public ResponseEntity<RespSimple> findByUsername(String username) {
        try {
            TConfiguracionUsuario config = this.configuracionUsuarioDAO.findByUsername(username);
            if (config == null) {
                return Transaccion.NOTFOUNT((String)"No existe configuraciones para el usuario solicitado, puedes agregar una");
            }
            return Transaccion.OK((String)"Configuraciones obtenidas", (Object)config);
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener las configuraciones del usuario solicitado");
        }
    }
}

