/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TSustentoTributarioDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoComprobanteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoDocumentoTributarioDAO;
import ec.tws2.back.contfiables.services.TipoComprobanteService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class TipoComprobanteServiceImpl
implements TipoComprobanteService {
    @Autowired
    private TTipoComprobanteDAO comprobanteDAO;
    @Autowired
    private TTipoDocumentoTributarioDAO documentoTributarioDAO;
    @Autowired
    private TSustentoTributarioDAO sustentoTributario;

    public ResponseEntity<RespSimple> obtenerTipoComprobante(String prefijo) {
        RespSimple response = new RespSimple();
        try {
            List comprobante = this.comprobanteDAO.obtenerTipoComprobante(prefijo);
            if (comprobante == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Comprobante no encontrado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Comprobante obtenido");
            response.setData((Object)comprobante);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener el comprobante");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerTipoComprobanteAjustes() {
        RespSimple response = new RespSimple();
        try {
            List comprobante = this.comprobanteDAO.findByPrefijoStartsWith("AJ");
            if (comprobante == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Comprobantes no encontrado");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Comprobantes obtenidos");
            response.setData((Object)comprobante);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener el comprobante");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerTipoDocumentosTributarios() {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.documentoTributarioDAO.findAll());
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("lista de tipo de comprobante");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de tipo de comprobantes");
            response.setData(new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaSustentoTributarios() {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.sustentoTributario.findAll());
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("lista de sustentos tributarios");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de sustentos tributarios");
            response.setData(new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerListaTipoComprobantes(Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.comprobanteDAO.findAll());
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("lista de tipos de comprobantes obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de tipos de comprobantes");
            response.setData(new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> registrarTipoComprobantes(TTipoComprobante tipoComprobante) {
        RespSimple response = new RespSimple();
        try {
            Boolean existe = this.comprobanteDAO.existsByPrefijoAndCliente(tipoComprobante.getPrefijo(), tipoComprobante.getCliente());
            if (existe.booleanValue()) {
                throw new CustomException("Ya existe un resgistro con es eprefijo");
            }
            response.setData(this.comprobanteDAO.save((Object)tipoComprobante));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Tipo comprobante registrado");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar el tipo de comprobante");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> actualizarTipoComprobantes(TTipoComprobante tipoComprobante) {
        RespSimple response = new RespSimple();
        try {
            TTipoComprobante tipoComprobanteDB = this.comprobanteDAO.findByPrefijoAndCliente(tipoComprobante.getPrefijo(), tipoComprobante.getCliente());
            if (tipoComprobanteDB == null) {
                throw new CustomException("No existe un tipo de comprobante con esa identificaci\u00f3n");
            }
            if (tipoComprobanteDB.getIdTipoComprobante() != tipoComprobante.getIdTipoComprobante()) {
                throw new CustomException("Ya existe un tipo de comprobante con ese prefijo");
            }
            tipoComprobanteDB.setActivo(tipoComprobante.getActivo());
            tipoComprobanteDB.setPrefijo(tipoComprobante.getPrefijo());
            tipoComprobanteDB.setNombre(tipoComprobante.getNombre());
            response.setData(this.comprobanteDAO.save((Object)tipoComprobanteDB));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Tipo de comprobante actualizado correctamente.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de tipos de comprobantes");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getComprobantesObligaciones() {
        RespSimple response = new RespSimple();
        try {
            ArrayList comprobante = new ArrayList();
            comprobante.addAll(this.comprobanteDAO.findByPrefijoStartsWith("OBL"));
            comprobante.addAll(this.comprobanteDAO.findByPrefijoStartsWith("OIP"));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Comprobantes obtenido");
            response.setData(comprobante);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener el comprobante");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

