/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.exceptions.ValidarAutorizacion;
import ec.tws2.back.contfiables.core.util.AsignarHoraDATE;
import ec.tws2.back.contfiables.models.domain.CalculoComprasModel;
import ec.tws2.back.contfiables.models.domain.ComprobanteAjusteDetalle;
import ec.tws2.back.contfiables.models.domain.ComprobanteCompraDetalle;
import ec.tws2.back.contfiables.models.domain.ComprobanteDetalleObligacionesMODEL;
import ec.tws2.back.contfiables.models.domain.ComprobanteTransferenciaDetalle;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TComprobanteAjuste;
import ec.tws2.back.contfiables.models.entities.facturacion.TComprobanteCompra;
import ec.tws2.back.contfiables.models.entities.facturacion.TComprobanteObligacion;
import ec.tws2.back.contfiables.models.entities.facturacion.TDetalleCompraObligacion;
import ec.tws2.back.contfiables.models.entities.facturacion.TDetalleComprobanteAjuste;
import ec.tws2.back.contfiables.models.entities.facturacion.TDetalleComprobanteCompra;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPagoComprobantes;
import ec.tws2.back.contfiables.models.entities.facturacion.TSustentoTributario;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoDocumentoTributario;
import ec.tws2.back.contfiables.models.entities.integracion.TCuentaContable;
import ec.tws2.back.contfiables.models.entities.integracion.TPuntoVenta;
import ec.tws2.back.contfiables.models.entities.integracion.TSecuenciaComprobante;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TComprobanteTransferenciaProductoInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TDetalleTransferenciaInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TKardex;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.entities.proveedor.TProveedor;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.models.enums.TipoPagoComprobantesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TComprobanteAjusteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TComprobanteCompraDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TComprobanteObligacionDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TComprobanteTransferenciaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TDetalleComprobanteAjusteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TDetalleComprobanteCompraDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TDetalleComprobanteObligacionDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoComprobantesDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TSustentoTributarioDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTSecuenciaComprobanteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoComprobanteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoDocumentoTributarioDAO;
import ec.tws2.back.contfiables.repositories.integracion.TCuentaContableDAO;
import ec.tws2.back.contfiables.repositories.integracion.TPuntoVentaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TDetalleTransferenciaInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TKardexDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.repositories.proveedor.TProveedorDAO;
import ec.tws2.back.contfiables.services.ComprobantesService;
import ec.tws2.back.contfiables.services.InventariosCalculosService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class TComprobantesServiceImpl
implements ComprobantesService {
    private static final Logger log = Logger.getLogger(TComprobantesServiceImpl.class.getName());
    @Autowired
    private TComprobanteCompraDAO comprobanteCompraDAO;
    @Autowired
    private TInventarioDAO inventarioDAO;
    @Autowired
    private TKardexDAO kardexDAO;
    @Autowired
    private TProductoDAO productoDAO;
    @Autowired
    private TTSecuenciaComprobanteDAO secuenciaComprobanteDAO;
    @Autowired
    private TDetalleComprobanteCompraDAO detalleComprobanteCompraDAO;
    @Autowired
    private InventariosCalculosService inventarioCalculosService;
    @Autowired
    private TProveedorDAO proveedorDAO;
    @Autowired
    private TTipoDocumentoTributarioDAO tipoDocumentoTributarioDAO;
    @Autowired
    private TComprobanteAjusteDAO comprobanteAjusteDAO;
    @Autowired
    private TDetalleComprobanteAjusteDAO detalleComprobanteAjusteDAO;
    @Autowired
    private TTipoComprobanteDAO tipoComprobanteDAO;
    @Autowired
    private TComprobanteTransferenciaDAO comprobanteTransferenciaDAO;
    @Autowired
    private TDetalleTransferenciaInventarioDAO detalleTransferenciaDAO;
    @Autowired
    private TPuntoVentaDAO puntoEmisionDAO;
    @Autowired
    private TFormaPagoComprobantesDAO formaPagoComprobateDAO;
    @Autowired
    private TComprobanteObligacionDAO comprobanteOblDAO;
    @Autowired
    private TComprobanteObligacionDAO comprobanteObligacionDAO;
    @Autowired
    private TDetalleComprobanteObligacionDAO detalleObligacionDAO;
    @Autowired
    private TSustentoTributarioDAO sustentoTributarioDAO;
    @Autowired
    private TCuentaContableDAO cuentaContableDAO;

    @Transactional
    public ResponseEntity<RespSimple> registrarComprobanteObligacion(ComprobanteDetalleObligacionesMODEL comprobanteObligacion) {
        RespSimple response = new RespSimple();
        try {
            List listFormaPagoComprobante = comprobanteObligacion.getFormaPagoComprobante();
            List listDetalleCompra = comprobanteObligacion.getDetalleComprobante();
            if (listDetalleCompra == null || listDetalleCompra.isEmpty()) {
                throw new CustomException("La compra no tiene un detalle para guardar.");
            }
            if (listFormaPagoComprobante == null || listFormaPagoComprobante.isEmpty()) {
                throw new CustomException("La forma de pago de la compra es requerida.");
            }
            ArrayList<String> listTipoPagoEnum = new ArrayList<String>();
            for (TipoPagoComprobantesEnum fpe : TipoPagoComprobantesEnum.values()) {
                listTipoPagoEnum.add(fpe.toString());
            }
            TComprobanteObligacion comprobanteObl = comprobanteObligacion.getComprobanteObligacion();
            comprobanteObl.setId(null);
            TComprobanteObligacion comprobanteOblDB = (TComprobanteObligacion)this.comprobanteOblDAO.save((Object)comprobanteObl);
            TProveedor proveedorDB = this.proveedorDAO.findById((Object)comprobanteObl.getProveedor().getIdProveedor()).orElse(null);
            if (proveedorDB == null) {
                throw new CustomException("El proveedor es requrido");
            }
            TSecuenciaComprobante secuenciaComprobante = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(comprobanteObl.getPuntoVenta().getIdPuntoVenta(), comprobanteObl.getTipoComprobante().getIdTipoComprobante());
            TTipoDocumentoTributario tipoDocTributario = this.tipoDocumentoTributarioDAO.findById((Object)comprobanteObl.getTipoDocumentoTributario().getIdDocumentoTributario()).orElse(null);
            if (tipoDocTributario == null) {
                throw new CustomException("El tipo de documento tributario es requrido");
            }
            TSustentoTributario sustentoTributario = this.sustentoTributarioDAO.findById((Object)comprobanteObl.getSustentoTributario().getIdSustentoTributario()).orElse(null);
            if (sustentoTributario == null) {
                throw new CustomException("EL sustento tributario es requerido");
            }
            comprobanteOblDB.setProveedor(proveedorDB);
            comprobanteOblDB.setTipoDocumentoTributario(tipoDocTributario);
            comprobanteOblDB.setSustentoTributario(sustentoTributario);
            for (TFormaPagoComprobantes fp : listFormaPagoComprobante) {
                fp.setId(null);
                fp.setComprobanteObligacion(comprobanteObl);
                fp.setTipoComprobante(comprobanteObl.getTipoComprobante());
                fp.setNumDocumento(comprobanteObl.getAnioComprobante() + "-" + secuenciaComprobante.getTipoComprobante().getPrefijo() + "-" + comprobanteObl.getEstablecimientoComprobante() + "-" + comprobanteObl.getPuntoEmisionComprobante() + "-" + comprobanteObl.getNumeroComprobante());
                if (!listTipoPagoEnum.contains(fp.getTipoPago().toUpperCase())) {
                    throw new CustomExceptionNoCleanData("El tipo de pago no coinside con el registro interno");
                }
                fp.setTipoPago(fp.getTipoPago().toUpperCase());
                this.formaPagoComprobateDAO.save((Object)fp);
            }
            BigDecimal impuestos = BigDecimal.ZERO;
            BigDecimal subtotal = BigDecimal.ZERO;
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal descuento = BigDecimal.ZERO;
            for (TDetalleCompraObligacion det : listDetalleCompra) {
                BigDecimal porcentual = new BigDecimal(det.getTarifaIva().getPorcentaje()).multiply(new BigDecimal(100));
                impuestos = impuestos.add(det.getValor().multiply(porcentual)).setScale(4, RoundingMode.HALF_UP);
                descuento = descuento.add(det.getDescuento()).setScale(4, RoundingMode.HALF_UP);
                subtotal = subtotal.add(det.getValor().subtract(det.getDescuento())).setScale(4, RoundingMode.HALF_UP);
                det.setComprobanteObligacion(comprobanteOblDB);
                det.setCantidad(new BigDecimal(1));
                this.detalleObligacionDAO.save((Object)det);
            }
            total = subtotal.add(impuestos);
            comprobanteOblDB.setCreatedAt(new Date());
            comprobanteOblDB.setImpuestos(impuestos);
            comprobanteOblDB.setSubtotal(subtotal);
            comprobanteOblDB.setTotal(total);
            comprobanteOblDB.setDescuento(descuento);
            secuenciaComprobante.setSecuencia(secuenciaComprobante.getSecuencia() + 1L);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobante);
            comprobanteOblDB.setEliminado(Boolean.valueOf(false));
            this.comprobanteOblDAO.save((Object)comprobanteOblDB);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Transacci\u00f3n realizada correctamente");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar la transacci\u00f3n");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> registrarComprobanteCompra(ComprobanteCompraDetalle comprobanteCompraDetalle) {
        RespSimple response = new RespSimple();
        List listFormaPagoComprobante = comprobanteCompraDetalle.getFormaPagoComprobante();
        try {
            if (listFormaPagoComprobante == null || listFormaPagoComprobante.isEmpty()) {
                throw new CustomException("La forma de pago de la compra es requerida.");
            }
            ArrayList<String> listTipoPagoEnum = new ArrayList<String>();
            for (TipoPagoComprobantesEnum fpe : TipoPagoComprobantesEnum.values()) {
                listTipoPagoEnum.add(fpe.toString());
            }
            TComprobanteCompra comprobanteCompra = comprobanteCompraDetalle.getComprobanteCompra();
            TComprobanteCompra existeComprobante = this.comprobanteCompraDAO.findByProveedorAndNumeroComprobanteCompraAndEliminado(comprobanteCompra.getProveedor(), comprobanteCompra.getNumeroComprobanteCompra(), Boolean.valueOf(false));
            if (existeComprobante != null) {
                throw new CustomException("Ya existe un registro con esos datos, referencia comprobante num: " + existeComprobante.getEstablecimientoComprobanteCompra() + existeComprobante.getPuntoEmisionComprobanteCompra() + existeComprobante.getNumeroComprobanteCompra());
            }
            comprobanteCompra.setIdComprobanteCompra(null);
            comprobanteCompra.setEliminado(Boolean.valueOf(false));
            comprobanteCompra.setCreatedAt(new Date());
            TComprobanteCompra comprobanteCompraDB = (TComprobanteCompra)this.comprobanteCompraDAO.save((Object)comprobanteCompra);
            TProveedor proveedorDB = this.proveedorDAO.findById((Object)comprobanteCompraDB.getProveedor().getIdProveedor()).orElse(null);
            TSecuenciaComprobante secuenciaComprobante = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(comprobanteCompra.getPuntoVenta().getIdPuntoVenta(), comprobanteCompra.getTipoComprobante().getIdTipoComprobante());
            TTipoDocumentoTributario tipoDocTributario = this.tipoDocumentoTributarioDAO.findById((Object)comprobanteCompra.getTipoDocumentoTributario().getIdDocumentoTributario()).orElse(null);
            for (TFormaPagoComprobantes fp : listFormaPagoComprobante) {
                fp.setId(null);
                fp.setComprobanteCompra(comprobanteCompraDB);
                fp.setTipoComprobante(comprobanteCompra.getTipoComprobante());
                fp.setNumDocumento(comprobanteCompraDB.getAnioComprobante() + "-" + secuenciaComprobante.getTipoComprobante().getPrefijo() + "-" + comprobanteCompraDB.getEstablecimientoComprobante() + "-" + comprobanteCompraDB.getPuntoEmisionComprobante() + "-" + comprobanteCompraDB.getNumeroComprobante());
                if (!listTipoPagoEnum.contains(fp.getTipoPago().toUpperCase())) {
                    throw new CustomExceptionNoCleanData("El tipo de pago no coinside con el registro interno");
                }
                fp.setTipoPago(fp.getTipoPago().toUpperCase());
                this.formaPagoComprobateDAO.save((Object)fp);
            }
            BigDecimal valorCompra = new BigDecimal(0);
            BigDecimal valorDescuento = new BigDecimal(0);
            BigDecimal valorImpuestos = new BigDecimal(0);
            String numAut = comprobanteCompra.getAutorizacionDocumento();
            boolean autorizacionValida = false;
            if (numAut.length() == 10) {
                autorizacionValida = true;
            } else if (numAut.length() == 49) {
                String establecimiento;
                String rucProveedor;
                autorizacionValida = true;
                String codTipoDocTributario = tipoDocTributario.getCodigo();
                Date fechaEmision = comprobanteCompra.getFechaEmisionComprobanteCompra();
                String validarNumAutorizacion = new ValidarAutorizacion().validarNumAutorizacion(numAut, fechaEmision, rucProveedor = proveedorDB.getIdentificacion(), establecimiento = comprobanteCompra.getEstablecimientoComprobanteCompra() + comprobanteCompra.getPuntoEmisionComprobanteCompra() + comprobanteCompra.getNumeroComprobanteCompra(), codTipoDocTributario);
                if (!validarNumAutorizacion.equals("0")) {
                    throw new CustomException(validarNumAutorizacion);
                }
            }
            if (!autorizacionValida) {
                throw new CustomException("Los caracteres del n\u00famero de autorizaci\u00f3n no es del largo correcto");
            }
            for (TDetalleComprobanteCompra det : comprobanteCompraDetalle.getListDetalle()) {
                CalculoComprasModel calculo = this.inventarioCalculosService.obtenerNuevosPrecios(det);
                TKardex kardex = new TKardex();
                TInventario productoIve = det.getProductoInventario();
                TProducto producto = productoIve.getProducto();
                TBodega bodega = comprobanteCompraDB.getBodega();
                TProducto productoDB = this.productoDAO.findById((Object)producto.getId()).orElse(null);
                TInventario productoIveDB = this.inventarioDAO.findById((Object)productoIve.getIdInventario()).orElse(null);
                BigDecimal costoUnitarioEntrada = calculo.getCostoUnitarioEntrada();
                BigDecimal stockEntrada = calculo.getStockEntrada();
                BigDecimal costoTotalEntrada = calculo.getCostoTotalEntrada();
                BigDecimal impuestosCompra = calculo.getImpuestos();
                BigDecimal descuentoCompraDetalle = calculo.getDescuento();
                BigDecimal nuevoCostoTotal = calculo.getNuevoCostoTotal();
                BigDecimal nuevoStockTotal = calculo.getNuevoStockTotal();
                BigDecimal nuevoCostoUnitario = calculo.getNuevoCostoUnitario();
                if (bodega.getIdBodega() != productoIveDB.getBodega().getIdBodega()) {
                    throw new CustomException("La bodega no coinside con el registro del producto.");
                }
                if (costoTotalEntrada.compareTo(BigDecimal.ZERO) == -1 || stockEntrada.compareTo(BigDecimal.ZERO) <= 0 || costoUnitarioEntrada.compareTo(BigDecimal.ZERO) == -1 || descuentoCompraDetalle.compareTo(BigDecimal.ZERO) == -1 || impuestosCompra.compareTo(BigDecimal.ZERO) == -1) {
                    throw new CustomException("Error en los datos ingresados para el producto: " + productoDB.getCodigo());
                }
                det.setUnidadMedida(productoIveDB.getProducto().getUnidadMedida());
                det.setComprobanteCompra(comprobanteCompraDB);
                det.setDescuento(descuentoCompraDetalle);
                det.setImpuestos(impuestosCompra);
                det.setSubtotal(calculo.getSubTotal());
                det.setTotal(costoTotalEntrada);
                valorCompra = valorCompra.add(calculo.getSubTotal());
                valorDescuento = valorDescuento.add(descuentoCompraDetalle);
                valorImpuestos = valorImpuestos.add(impuestosCompra).setScale(4, RoundingMode.HALF_UP);
                productoDB.setPrecioUnitario(producto.getPrecioUnitario().setScale(4, RoundingMode.HALF_UP));
                productoDB.setCostoCompra(nuevoCostoUnitario);
                productoDB.setStock(nuevoStockTotal);
                productoDB.setUpdatedAt(new Date());
                if (productoDB.getPrecioUnitario().compareTo(nuevoCostoUnitario) == -1) {
                    throw new CustomException("El precio de venta del producto: " + producto.getCodigo() + ", es menor al costo de compra");
                }
                productoIveDB.setCostoTotal(nuevoCostoTotal);
                productoIveDB.setCostoUnitario(nuevoCostoUnitario);
                productoIveDB.setStock(nuevoStockTotal);
                productoIveDB.setUpdatedAt(new Date());
                productoIveDB.setImpuestoCompra(det.getImpuestoCompra());
                kardex.setTipoComprobante(comprobanteCompra.getTipoComprobante());
                kardex.setTipoMovimiento("ING");
                kardex.setProducto(productoIveDB.getProducto());
                kardex.setBodega(comprobanteCompraDB.getBodega());
                kardex.setCliente(productoDB.getCliente());
                kardex.setTipoDocumentoTributario(comprobanteCompraDB.getTipoDocumentoTributario());
                kardex.setClienteProveedor(proveedorDB.getIdentificacion() + "-" + proveedorDB.getRazonSocial());
                kardex.setComprobante(comprobanteCompraDB.getEstablecimientoComprobanteCompra() + "-" + comprobanteCompraDB.getPuntoEmisionComprobanteCompra() + "-" + comprobanteCompraDB.getNumeroComprobanteCompra());
                kardex.setDetalle(comprobanteCompraDB.getConcepto());
                kardex.setEntradaCantidad(stockEntrada);
                kardex.setEntradaCostoTotal(costoTotalEntrada);
                kardex.setEntradaCostoUnitario(costoUnitarioEntrada);
                kardex.setNumComprobante(comprobanteCompraDB.getAnioComprobante() + "-" + secuenciaComprobante.getTipoComprobante().getPrefijo() + "-" + comprobanteCompraDB.getEstablecimientoComprobante() + "-" + comprobanteCompraDB.getPuntoEmisionComprobante() + "-" + comprobanteCompraDB.getNumeroComprobante());
                kardex.setFechaMovimiento(new Date());
                kardex.setExistenciaCantidad(nuevoStockTotal);
                kardex.setExistenciaCostoTotal(nuevoCostoTotal);
                kardex.setExistenciaCostoUnitario(nuevoCostoUnitario);
                kardex.setImpuestos(impuestosCompra);
                kardex.setValorIva(productoIveDB.getImpuestoCompra());
                kardex.setSalidaCantidad(new BigDecimal(0.0));
                kardex.setSalidaPvpUnitario(new BigDecimal(0.0));
                kardex.setSalidaTotal(new BigDecimal(0.0));
                this.productoDAO.save((Object)productoDB);
                this.inventarioDAO.save((Object)productoIveDB);
                this.kardexDAO.save((Object)kardex);
                this.detalleComprobanteCompraDAO.save((Object)det);
            }
            secuenciaComprobante.setSecuencia(secuenciaComprobante.getSecuencia() + 1L);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobante);
            comprobanteCompraDB.setValorCompra(valorCompra);
            comprobanteCompraDB.setImpuestos(valorImpuestos);
            comprobanteCompraDB.setDescuento(valorDescuento);
            this.comprobanteCompraDAO.save((Object)comprobanteCompraDB);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Transacci\u00f3n realizada");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.severe("error: " + e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar la transacci\u00f3n");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ResponseEntity<RespSimple> registrarComprobanteTransferencia(ComprobanteTransferenciaDetalle comprobanteTransferencia) {
        RespSimple response = new RespSimple();
        TComprobanteTransferenciaProductoInventario transferencia = comprobanteTransferencia.getComprobanteTransferenciaInventario();
        TPuntoVenta puntoEmision = this.puntoEmisionDAO.findById((Object)transferencia.getPuntoEmision().getIdPuntoVenta()).orElse(null);
        if (puntoEmision == null) {
            throw new CustomException("No se a podido identificar el punto de emisi\u00f3n");
        }
        transferencia.setPuntoEmision(puntoEmision);
        List detalle = comprobanteTransferencia.getListDetalle();
        TCliente cliente = transferencia.getPuntoEmision().getEstablecimiento().getCliente();
        LocalDateTime fechaHoy = LocalDateTime.now();
        TTipoComprobante tipoComprobanteEGT = this.tipoComprobanteDAO.findByPrefijo("EGT");
        TSecuenciaComprobante secuenciaComprobanteEGT = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(puntoEmision.getIdPuntoVenta(), tipoComprobanteEGT.getIdTipoComprobante());
        TTipoComprobante tipoComprobanteINT = this.tipoComprobanteDAO.findByPrefijo("INT");
        TSecuenciaComprobante secuenciaComprobanteINT = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(puntoEmision.getIdPuntoVenta(), tipoComprobanteINT.getIdTipoComprobante());
        try {
            transferencia.setCreatedAt(new Date());
            transferencia = (TComprobanteTransferenciaProductoInventario)this.comprobanteTransferenciaDAO.save((Object)transferencia);
            for (TDetalleTransferenciaInventario det : detalle) {
                TInventario productoInvBodegaSalida = this.inventarioDAO.findByBodegaAndProducto(transferencia.getBodegaOrigen(), det.getProductoInventario().getProducto());
                BigDecimal cantidadSaliente = det.getCantidad();
                BigDecimal costoUnitarioSaliente = productoInvBodegaSalida.getCostoUnitario();
                BigDecimal totalSaliente = cantidadSaliente.multiply(costoUnitarioSaliente).setScale(4, RoundingMode.HALF_UP);
                BigDecimal cantidadActualStock = productoInvBodegaSalida.getStock();
                BigDecimal costoTotalActual = productoInvBodegaSalida.getCostoTotal();
                BigDecimal nuevoStock = cantidadActualStock.subtract(cantidadSaliente);
                BigDecimal nuevoCostoTotal = costoTotalActual.subtract(totalSaliente);
                if (nuevoStock.compareTo(BigDecimal.ZERO) == 0 && nuevoCostoTotal.compareTo(BigDecimal.ZERO) != 0 || nuevoCostoTotal.compareTo(BigDecimal.ZERO) == 0 && nuevoStock.compareTo(BigDecimal.ZERO) != 0) {
                    throw new CustomException("Por favor cuadrar el inventario, no es posible realizar la transacci\u00f3n");
                }
                if (cantidadSaliente.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new CustomException("La cantidad no puede ser menor o igual a cero");
                }
                if (totalSaliente.compareTo(costoTotalActual) == 1) {
                    throw new CustomException("Error: el valor saliente es mayor al costo existente en el inventario");
                }
                if (cantidadSaliente.compareTo(cantidadActualStock) == 1) {
                    throw new CustomException("Error: la cantidad saliente supera el stock existente");
                }
                TKardex kardexSalida = new TKardex();
                kardexSalida.setBodega(transferencia.getBodegaOrigen());
                kardexSalida.setCliente(cliente);
                kardexSalida.setClienteProveedor(cliente.getNombres() + " " + cliente.getApellidos());
                kardexSalida.setComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteEGT.getSecuencia());
                kardexSalida.setNumComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteEGT.getSecuencia());
                kardexSalida.setDetalle(transferencia.getConcepto());
                kardexSalida.setTipoMovimiento("EGR");
                BigDecimal nuevoCostoUnitario = BigDecimal.ZERO;
                nuevoCostoUnitario = nuevoStock.compareTo(BigDecimal.ZERO) == 0 && nuevoCostoTotal.compareTo(BigDecimal.ZERO) == 0 ? productoInvBodegaSalida.getCostoUnitario() : nuevoCostoTotal.divide(nuevoStock, 4, RoundingMode.HALF_UP);
                kardexSalida.setEntradaCantidad(new BigDecimal(0.0));
                kardexSalida.setEntradaCostoUnitario(new BigDecimal(0.0));
                kardexSalida.setEntradaCostoTotal(new BigDecimal(0.0));
                kardexSalida.setSalidaCantidad(cantidadSaliente);
                kardexSalida.setSalidaPvpUnitario(costoUnitarioSaliente);
                kardexSalida.setSalidaTotal(totalSaliente);
                kardexSalida.setExistenciaCantidad(nuevoStock);
                kardexSalida.setExistenciaCostoUnitario(nuevoCostoUnitario);
                kardexSalida.setExistenciaCostoTotal(nuevoCostoTotal);
                productoInvBodegaSalida.setStock(nuevoStock);
                productoInvBodegaSalida.setCostoUnitario(nuevoCostoUnitario);
                productoInvBodegaSalida.setCostoTotal(nuevoCostoTotal);
                kardexSalida.setFechaMovimiento(new Date());
                kardexSalida.setIdKardex(null);
                kardexSalida.setImpuestos(new BigDecimal(0.0));
                kardexSalida.setTipoComprobante(tipoComprobanteEGT);
                kardexSalida.setTipoDocumentoTributario(null);
                kardexSalida.setValorIva(Long.valueOf(0L));
                kardexSalida.setProducto(productoInvBodegaSalida.getProducto());
                det.setComprobanteTrasferencia(transferencia);
                this.kardexDAO.save((Object)kardexSalida);
                this.inventarioDAO.save((Object)productoInvBodegaSalida);
                CalculoComprasModel calculo = this.inventarioCalculosService.obtenerNuevosPreciosIngreso(det, transferencia.getBodegaDestino());
                TInventario productoInvBodegaEntrada = this.inventarioDAO.findByBodegaAndProducto(transferencia.getBodegaDestino(), det.getProductoInventario().getProducto());
                TKardex kardexIngreso = new TKardex();
                kardexIngreso.setBodega(transferencia.getBodegaDestino());
                kardexIngreso.setCliente(cliente);
                kardexIngreso.setClienteProveedor(cliente.getNombres() + " " + cliente.getApellidos());
                kardexIngreso.setComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteEGT.getSecuencia());
                kardexIngreso.setNumComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteINT.getSecuencia());
                kardexIngreso.setDetalle("INGRESO DE MERCADERIA POR TRANSFERENCIA");
                kardexIngreso.setTipoMovimiento("ING");
                kardexIngreso.setEntradaCantidad(calculo.getStockEntrada());
                kardexIngreso.setEntradaCostoUnitario(calculo.getCostoUnitarioEntrada());
                kardexIngreso.setEntradaCostoTotal(calculo.getCostoTotalEntrada());
                kardexIngreso.setSalidaCantidad(BigDecimal.ZERO);
                kardexIngreso.setSalidaPvpUnitario(BigDecimal.ZERO);
                kardexIngreso.setSalidaTotal(BigDecimal.ZERO);
                kardexIngreso.setExistenciaCantidad(calculo.getNuevoStockTotal());
                kardexIngreso.setExistenciaCostoUnitario(calculo.getNuevoCostoUnitario());
                kardexIngreso.setExistenciaCostoTotal(calculo.getNuevoCostoTotal());
                productoInvBodegaEntrada.setStock(calculo.getNuevoStockTotal());
                productoInvBodegaEntrada.setCostoUnitario(calculo.getNuevoCostoUnitario());
                productoInvBodegaEntrada.setCostoTotal(calculo.getNuevoCostoTotal());
                kardexIngreso.setFechaMovimiento(new Date());
                kardexIngreso.setIdKardex(null);
                kardexIngreso.setImpuestos(new BigDecimal(0.0));
                kardexIngreso.setTipoComprobante(tipoComprobanteINT);
                kardexIngreso.setTipoDocumentoTributario(null);
                kardexIngreso.setValorIva(Long.valueOf(0L));
                kardexIngreso.setProducto(productoInvBodegaEntrada.getProducto());
                this.inventarioDAO.save((Object)productoInvBodegaEntrada);
                this.detalleTransferenciaDAO.save((Object)det);
                this.kardexDAO.save((Object)kardexIngreso);
            }
            secuenciaComprobanteEGT.setSecuencia(secuenciaComprobanteEGT.getSecuencia() + 1L);
            secuenciaComprobanteINT.setSecuencia(secuenciaComprobanteINT.getSecuencia() + 1L);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobanteEGT);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobanteINT);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Transacci\u00f3n exitosa.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar la transferencia: " + e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ResponseEntity<RespSimple> registrarComprobanteReversoFactura(ComprobanteTransferenciaDetalle comprobanteTransferencia) {
        TComprobanteTransferenciaProductoInventario transferencia = comprobanteTransferencia.getComprobanteTransferenciaInventario();
        TTipoComprobante comprobanteReingreso = this.tipoComprobanteDAO.findByPrefijo("ING");
        TPuntoVenta puntoEmision = this.puntoEmisionDAO.findById((Object)transferencia.getPuntoEmision().getIdPuntoVenta()).orElse(null);
        if (puntoEmision == null) {
            throw new CustomException("No se a podido identificar el punto de emisi\u00f3n");
        }
        transferencia.setPuntoEmision(puntoEmision);
        List detalle = comprobanteTransferencia.getListDetalle();
        TCliente cliente = transferencia.getPuntoEmision().getEstablecimiento().getCliente();
        LocalDateTime fechaHoy = LocalDateTime.now();
        TSecuenciaComprobante secuenciaComprobanteINT = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(puntoEmision.getIdPuntoVenta(), comprobanteReingreso.getIdTipoComprobante());
        try {
            transferencia.setCreatedAt(new Date());
            transferencia = (TComprobanteTransferenciaProductoInventario)this.comprobanteTransferenciaDAO.save((Object)transferencia);
            for (TDetalleTransferenciaInventario det : detalle) {
                TInventario productoInvBodegaSalida = this.inventarioDAO.findByBodegaAndProducto(transferencia.getBodegaOrigen(), det.getProductoInventario().getProducto());
                BigDecimal cantidadSaliente = det.getCantidad();
                BigDecimal costoUnitarioSaliente = productoInvBodegaSalida.getCostoUnitario();
                BigDecimal totalSaliente = cantidadSaliente.multiply(costoUnitarioSaliente).setScale(4, RoundingMode.HALF_UP);
                BigDecimal cantidadActualStock = productoInvBodegaSalida.getStock();
                BigDecimal costoTotalActual = productoInvBodegaSalida.getCostoTotal();
                BigDecimal nuevoStock = cantidadActualStock.subtract(cantidadSaliente);
                BigDecimal nuevoCostoTotal = costoTotalActual.subtract(totalSaliente);
                if (nuevoStock.compareTo(BigDecimal.ZERO) == 0 && nuevoCostoTotal.compareTo(BigDecimal.ZERO) != 0 || nuevoCostoTotal.compareTo(BigDecimal.ZERO) == 0 && nuevoStock.compareTo(BigDecimal.ZERO) != 0) {
                    throw new CustomException("Por favor cuadrar el inventario, no es posible realizar la transacci\u00f3n");
                }
                if (cantidadSaliente.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new CustomException("La cantidad no puede ser menor o igual a cero");
                }
                if (totalSaliente.compareTo(costoTotalActual) == 1) {
                    throw new CustomException("Error: el valor saliente es mayor al costo existente en el inventario");
                }
                if (cantidadSaliente.compareTo(cantidadActualStock) == 1) {
                    throw new CustomException("Error: la cantidad saliente supera el stock existente");
                }
                CalculoComprasModel calculo = this.inventarioCalculosService.obtenerNuevosPreciosIngreso(det, transferencia.getBodegaDestino());
                TInventario productoInvBodegaEntrada = this.inventarioDAO.findByBodegaAndProducto(transferencia.getBodegaDestino(), det.getProductoInventario().getProducto());
                TKardex kardexIngreso = new TKardex();
                kardexIngreso.setBodega(transferencia.getBodegaDestino());
                kardexIngreso.setCliente(cliente);
                kardexIngreso.setClienteProveedor(cliente.getNombres() + " " + cliente.getApellidos());
                kardexIngreso.setComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteINT.getSecuencia());
                kardexIngreso.setNumComprobante(fechaHoy.getYear() + "-" + transferencia.getPuntoEmision().getEstablecimiento().getEstablecimiento() + "-" + transferencia.getPuntoEmision().getPuntoEmision() + "-" + secuenciaComprobanteINT.getSecuencia());
                kardexIngreso.setDetalle("INGRESO DE MERCADERIA POR ANULACION DE FACTURA");
                kardexIngreso.setTipoMovimiento("ING");
                kardexIngreso.setEntradaCantidad(calculo.getStockEntrada());
                kardexIngreso.setEntradaCostoUnitario(calculo.getCostoUnitarioEntrada());
                kardexIngreso.setEntradaCostoTotal(calculo.getCostoTotalEntrada());
                kardexIngreso.setSalidaCantidad(BigDecimal.ZERO);
                kardexIngreso.setSalidaPvpUnitario(BigDecimal.ZERO);
                kardexIngreso.setSalidaTotal(BigDecimal.ZERO);
                kardexIngreso.setExistenciaCantidad(calculo.getNuevoStockTotal());
                kardexIngreso.setExistenciaCostoUnitario(calculo.getNuevoCostoUnitario());
                kardexIngreso.setExistenciaCostoTotal(calculo.getNuevoCostoTotal());
                productoInvBodegaEntrada.setStock(calculo.getNuevoStockTotal());
                productoInvBodegaEntrada.setCostoUnitario(calculo.getNuevoCostoUnitario());
                productoInvBodegaEntrada.setCostoTotal(calculo.getNuevoCostoTotal());
                kardexIngreso.setFechaMovimiento(new Date());
                kardexIngreso.setIdKardex(null);
                kardexIngreso.setImpuestos(new BigDecimal(0.0));
                kardexIngreso.setTipoComprobante(comprobanteReingreso);
                kardexIngreso.setTipoDocumentoTributario(null);
                kardexIngreso.setValorIva(Long.valueOf(0L));
                kardexIngreso.setProducto(productoInvBodegaEntrada.getProducto());
                this.inventarioDAO.save((Object)productoInvBodegaEntrada);
                this.detalleTransferenciaDAO.save((Object)det);
                this.kardexDAO.save((Object)kardexIngreso);
            }
            secuenciaComprobanteINT.setSecuencia(secuenciaComprobanteINT.getSecuencia() + 1L);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobanteINT);
            return Transaccion.OK(null, (Object)"Transacci\u00f3n exitosa.");
        }
        catch (CustomException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.CUSTOM_EXCEPTION((String)e.getMessage());
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.ERROR((String)("Error al registrar la transferencia: " + e.getMessage()));
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> registrarComprobanteAjuste(ComprobanteAjusteDetalle comprobanteAjusteDetalle) {
        RespSimple response = new RespSimple();
        try {
            LocalDateTime fechaAhora = LocalDateTime.now();
            TComprobanteAjuste comAjuste = comprobanteAjusteDetalle.getComprobanteAjuste();
            List listDetalle = comprobanteAjusteDetalle.getListDetalle();
            comAjuste.setCreatedAt(new Date());
            if (comAjuste.getSecuenciaComprobante() == null) {
                throw new CustomException("La secuencia del comprobante no est\u00e1 presenta");
            }
            TComprobanteAjuste conAjusteDB = (TComprobanteAjuste)this.comprobanteAjusteDAO.save((Object)comAjuste);
            TTipoComprobante tipoComprobante = this.tipoComprobanteDAO.findById((Object)conAjusteDB.getTipoComprobante().getIdTipoComprobante()).orElse(null);
            if (tipoComprobante == null) {
                throw new CustomException("Error al validar el tipo de comprobante de ajuste");
            }
            TSecuenciaComprobante secuenciaComprobante = this.secuenciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(conAjusteDB.getPuntoVenta().getIdPuntoVenta(), conAjusteDB.getTipoComprobante().getIdTipoComprobante());
            secuenciaComprobante.setSecuencia(secuenciaComprobante.getSecuencia() + 1L);
            BigDecimal totalDebito = new BigDecimal(0);
            BigDecimal totalCredito = new BigDecimal(0);
            BigDecimal granTotal = new BigDecimal(0);
            for (TDetalleComprobanteAjuste det : listDetalle) {
                String tipoAjuste = tipoComprobante.getPrefijo();
                TInventario productoIV = this.inventarioDAO.findById((Object)det.getProductoInventario().getIdInventario()).orElse(null);
                if (productoIV == null) {
                    throw new CustomExceptionNoCleanData("El producto para realizar la transacci\u00f3n no existe");
                }
                if (!det.getDebitoCredito().equals("debito") && !det.getDebitoCredito().equals("credito")) {
                    throw new CustomExceptionNoCleanData("El tipo de transaccion 'd\u00e9bito' o 'cr\u00e9dito' no especificada");
                }
                TProducto producto = productoIV.getProducto();
                TKardex kardex = new TKardex();
                kardex.setIdKardex(null);
                CalculoComprasModel calculo = this.inventarioCalculosService.obtenerNuevosPreciosAjustes(det, tipoAjuste);
                BigDecimal costoUnitarioMovimiento = calculo.getCostoUnitarioEntrada();
                BigDecimal stockMovimiento = calculo.getStockEntrada();
                BigDecimal costoTotalMovimiento = calculo.getCostoTotalEntrada();
                BigDecimal nuevoCostoTotal = calculo.getNuevoCostoTotal();
                BigDecimal nuevoStockTotal = calculo.getNuevoStockTotal();
                BigDecimal nuevoCostoUnitario = calculo.getNuevoCostoUnitario();
                if (costoTotalMovimiento.compareTo(BigDecimal.ZERO) < 0 || stockMovimiento.compareTo(BigDecimal.ZERO) < 0 || costoTotalMovimiento.compareTo(BigDecimal.ZERO) < 0 || nuevoCostoTotal.compareTo(BigDecimal.ZERO) < 0 || nuevoStockTotal.compareTo(BigDecimal.ZERO) < 0 || nuevoCostoUnitario.compareTo(BigDecimal.ZERO) < 0) {
                    throw new CustomExceptionNoCleanData("Los nuevos costos son menores a cero o son inv\u00e1lidos");
                }
                if (det.getDebitoCredito().equals("debito")) {
                    kardex.setTipoMovimiento("ING");
                    kardex.setEntradaCantidad(stockMovimiento);
                    kardex.setEntradaCostoTotal(costoTotalMovimiento);
                    kardex.setEntradaCostoUnitario(costoUnitarioMovimiento);
                    kardex.setExistenciaCantidad(nuevoStockTotal);
                    kardex.setExistenciaCostoTotal(nuevoCostoTotal);
                    kardex.setExistenciaCostoUnitario(nuevoCostoUnitario);
                    kardex.setImpuestos(new BigDecimal(0.0));
                    kardex.setValorIva(Long.valueOf(0L));
                    kardex.setSalidaCantidad(new BigDecimal(0.0));
                    kardex.setSalidaPvpUnitario(new BigDecimal(0.0));
                    kardex.setSalidaTotal(new BigDecimal(0.0));
                    totalDebito = totalDebito.add(costoTotalMovimiento);
                } else {
                    kardex.setTipoMovimiento("EGR");
                    kardex.setEntradaCantidad(new BigDecimal(0.0));
                    kardex.setEntradaCostoTotal(new BigDecimal(0.0));
                    kardex.setEntradaCostoUnitario(new BigDecimal(0.0));
                    kardex.setExistenciaCantidad(nuevoStockTotal);
                    kardex.setExistenciaCostoTotal(nuevoCostoTotal);
                    kardex.setExistenciaCostoUnitario(nuevoCostoUnitario);
                    kardex.setImpuestos(new BigDecimal(0.0));
                    kardex.setValorIva(Long.valueOf(0L));
                    kardex.setSalidaCantidad(stockMovimiento);
                    kardex.setSalidaPvpUnitario(costoUnitarioMovimiento);
                    kardex.setSalidaTotal(costoTotalMovimiento);
                    totalCredito = totalCredito.add(costoTotalMovimiento);
                }
                granTotal = totalCredito.add(totalDebito);
                LocalDateTime fecha = LocalDateTime.now();
                producto.setStock(nuevoStockTotal);
                producto.setCostoCompra(nuevoCostoUnitario);
                det.setComprobanteAjuste(conAjusteDB);
                kardex.setTipoComprobante(tipoComprobante);
                kardex.setProducto(producto);
                kardex.setFechaMovimiento(new Date());
                kardex.setBodega(conAjusteDB.getBodega());
                kardex.setCliente(conAjusteDB.getCliente());
                kardex.setClienteProveedor("Usuario");
                kardex.setComprobante(fecha.getYear() + "-" + tipoAjuste + "-" + secuenciaComprobante.getPuntoVenta().getEstablecimiento().getEstablecimiento() + "-" + secuenciaComprobante.getPuntoVenta().getPuntoEmision() + "-" + secuenciaComprobante.getSecuencia());
                kardex.setDetalle(conAjusteDB.getConcepto());
                kardex.setNumComprobante(fecha.getYear() + "-" + conAjusteDB.getTipoComprobante().getPrefijo() + "-" + secuenciaComprobante.getPuntoVenta().getEstablecimiento().getEstablecimiento() + "-" + secuenciaComprobante.getPuntoVenta().getPuntoEmision() + "-" + secuenciaComprobante.getSecuencia());
                kardex.setDetalle(conAjusteDB.getConcepto());
                kardex.setFechaMovimiento(new Date());
                productoIV.setCostoTotal(nuevoCostoTotal);
                productoIV.setCostoUnitario(nuevoCostoUnitario);
                productoIV.setStock(nuevoStockTotal);
                productoIV.setUpdatedAt(new Date());
                this.kardexDAO.save((Object)kardex);
                this.inventarioDAO.save((Object)productoIV);
                this.detalleComprobanteAjusteDAO.save((Object)det);
            }
            conAjusteDB.setTotalCosto(granTotal);
            conAjusteDB.setTotalCreditol(totalCredito);
            conAjusteDB.setTotalDebito(totalDebito);
            conAjusteDB.setFechaMovimiento(new Date());
            conAjusteDB.setNumComprobante(fechaAhora.getYear() + "-" + secuenciaComprobante.getPuntoVenta().getEstablecimiento().getEstablecimiento() + "-" + secuenciaComprobante.getPuntoVenta().getPuntoEmision() + secuenciaComprobante.getSecuencia());
            this.comprobanteAjusteDAO.save((Object)conAjusteDB);
            this.secuenciaComprobanteDAO.save((Object)secuenciaComprobante);
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Transacci\u00f3n realizada");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomExceptionNoCleanData e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR_BUT_NOTCLEAN_FRONT.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR_BUT_NOTCLEAN_FRONT.getId());
            response.setMensaje("Error al registrar la transacci\u00f3n");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> obtenerComprobantesCompra(Long idBodega, Long idPuntoVenta, Date fechaInicial, Date fechaFinal, String tipo) {
        RespSimple response = new RespSimple();
        try {
            fechaInicial = new AsignarHoraDATE().asiganarHora(fechaInicial, "inicio");
            fechaFinal = new AsignarHoraDATE().asiganarHora(fechaFinal, "fin");
            switch (tipo) {
                case "com": {
                    response.setData((Object)this.comprobanteCompraDAO.findByEliminadoAndBodegaAndPuntoVentaAndCreatedAtBetweenOrderByIdComprobanteCompraDesc(false, new TBodega(idBodega), new TPuntoVenta(idPuntoVenta), fechaInicial, fechaFinal));
                    break;
                }
                case "obl": {
                    response.setData((Object)this.comprobanteObligacionDAO.findByEliminadoAndPuntoVentaAndCreatedAtBetweenOrderByIdDesc(false, new TPuntoVenta(idPuntoVenta), fechaInicial, fechaFinal));
                    break;
                }
                default: {
                    throw new CustomException("Tipo de documento no identificado");
                }
            }
            response.setMensaje("lista obtenida");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            response.setData(new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al procesar la transacci\u00f3n");
            response.setData(new ArrayList());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> eliminarComprobanteCompra(Long idComprobanteCompra, String tipoCom) {
        RespSimple response = new RespSimple();
        try {
            switch (tipoCom) {
                case "com": {
                    TComprobanteCompra comprobanteCompraDB = this.comprobanteCompraDAO.findById((Object)idComprobanteCompra).orElse(null);
                    if (comprobanteCompraDB == null) {
                        response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                        response.setMensaje("Comprobante no encontrado");
                        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
                    }
                    List listDetalle = this.detalleComprobanteCompraDAO.findByComprobanteCompraOrderByIdDetalleCompraDesc(comprobanteCompraDB);
                    for (TDetalleComprobanteCompra det : listDetalle) {
                        CalculoComprasModel calculo = this.inventarioCalculosService.eliminarYObtenerNuevosPrecios(det);
                        TKardex kardex = new TKardex();
                        TInventario productoIve = det.getProductoInventario();
                        TProducto producto = productoIve.getProducto();
                        TBodega bodega = comprobanteCompraDB.getBodega();
                        TProducto productoDB = this.productoDAO.findById((Object)producto.getId()).orElse(null);
                        TInventario productoIveDB = this.inventarioDAO.findById((Object)productoIve.getIdInventario()).orElse(null);
                        BigDecimal costoUnitarioEntrada = calculo.getCostoUnitarioEntrada();
                        BigDecimal stockEntrada = calculo.getStockEntrada();
                        BigDecimal costoTotalEntrada = calculo.getCostoTotalEntrada();
                        BigDecimal impuestosCompra = calculo.getImpuestos();
                        BigDecimal descuentoCompraDetalle = calculo.getDescuento();
                        BigDecimal nuevoCostoTotal = calculo.getNuevoCostoTotal();
                        BigDecimal nuevoStockTotal = calculo.getNuevoStockTotal();
                        BigDecimal nuevoCostoUnitario = calculo.getNuevoCostoUnitario();
                        if (bodega.getIdBodega() != productoIveDB.getBodega().getIdBodega()) {
                            throw new CustomException("La bodega no coinside con el registro del producto.");
                        }
                        if (costoTotalEntrada.compareTo(BigDecimal.ZERO) == -1 || stockEntrada.compareTo(BigDecimal.ZERO) <= 0 || costoUnitarioEntrada.compareTo(BigDecimal.ZERO) == -1 || descuentoCompraDetalle.compareTo(BigDecimal.ZERO) == -1 || impuestosCompra.compareTo(BigDecimal.ZERO) == -1) {
                            throw new CustomException("Error en los datos ingresados para el producto: " + productoDB.getCodigo());
                        }
                        productoDB.setPrecioUnitario(producto.getPrecioUnitario().setScale(4, RoundingMode.HALF_UP));
                        productoDB.setCostoCompra(nuevoCostoUnitario);
                        productoDB.setStock(nuevoStockTotal);
                        productoDB.setUpdatedAt(new Date());
                        if (productoDB.getPrecioUnitario().compareTo(nuevoCostoUnitario) == -1) {
                            throw new CustomException("El precio de venta del producto: " + producto.getCodigo() + ", es menor al costo de compra");
                        }
                        productoIveDB.setCostoTotal(nuevoCostoTotal);
                        productoIveDB.setCostoUnitario(nuevoCostoUnitario);
                        productoIveDB.setStock(nuevoStockTotal);
                        productoIveDB.setUpdatedAt(new Date());
                        productoIveDB.setImpuestoCompra(productoIve.getImpuestoCompra());
                        kardex.setTipoComprobante(null);
                        kardex.setTipoMovimiento("EGR");
                        kardex.setProducto(productoIveDB.getProducto());
                        kardex.setBodega(comprobanteCompraDB.getBodega());
                        kardex.setCliente(productoDB.getCliente());
                        kardex.setTipoDocumentoTributario(comprobanteCompraDB.getTipoDocumentoTributario());
                        kardex.setClienteProveedor(comprobanteCompraDB.getBodega().getCliente().getNombres() + " " + comprobanteCompraDB.getBodega().getCliente().getApellidos());
                        kardex.setComprobante("eliminado " + comprobanteCompraDB.getAnioComprobante() + "-" + comprobanteCompraDB.getEstablecimientoComprobanteCompra() + "-" + comprobanteCompraDB.getPuntoEmisionComprobanteCompra() + "-" + comprobanteCompraDB.getNumeroComprobanteCompra());
                        kardex.setDetalle("SALIDA POR ELIMINACION DE COMPROBANTE DE COMPRA");
                        kardex.setNumComprobante("eliminado " + comprobanteCompraDB.getTipoComprobante().getPrefijo() + "-" + comprobanteCompraDB.getAnioComprobante() + "-" + comprobanteCompraDB.getEstablecimientoComprobante() + "-" + comprobanteCompraDB.getPuntoEmisionComprobante() + "-" + comprobanteCompraDB.getNumeroComprobante());
                        kardex.setFechaMovimiento(new Date());
                        kardex.setExistenciaCantidad(nuevoStockTotal);
                        kardex.setExistenciaCostoTotal(nuevoCostoTotal);
                        kardex.setExistenciaCostoUnitario(nuevoCostoUnitario);
                        kardex.setImpuestos(impuestosCompra);
                        kardex.setValorIva(productoIveDB.getImpuestoCompra());
                        kardex.setEntradaCantidad(new BigDecimal(0.0));
                        kardex.setEntradaCostoUnitario(new BigDecimal(0.0));
                        kardex.setEntradaCostoTotal(new BigDecimal(0.0));
                        kardex.setSalidaCantidad(stockEntrada);
                        kardex.setSalidaTotal(costoTotalEntrada);
                        kardex.setSalidaPvpUnitario(costoUnitarioEntrada);
                        this.productoDAO.save((Object)productoDB);
                        this.inventarioDAO.save((Object)productoIveDB);
                        this.kardexDAO.save((Object)kardex);
                    }
                    comprobanteCompraDB.setEliminado(Boolean.valueOf(true));
                    comprobanteCompraDB.setEliminatedAt(new Date());
                    this.comprobanteCompraDAO.save((Object)comprobanteCompraDB);
                    response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                    response.setMensaje("Comprobante eliminado");
                    return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
                }
                case "obl": {
                    TComprobanteObligacion comprobanteObligacion = this.comprobanteObligacionDAO.findById((Object)idComprobanteCompra).orElse(null);
                    if (comprobanteObligacion == null) {
                        throw new CustomException("Comprobante no identificado");
                    }
                    comprobanteObligacion.setEliminado(Boolean.valueOf(true));
                    comprobanteObligacion.setEliminatedAt(new Date());
                    this.comprobanteObligacionDAO.save((Object)comprobanteObligacion);
                    response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                    response.setMensaje("Comprobante eliminado");
                    return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
                }
            }
            throw new CustomException("Tipo de comprobante no identificado");
        }
        catch (CustomException e) {
            log.severe("error: " + e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al eliminar el comprobante: " + e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> obtenerDetalleComprobanteCompra(Long idComprobanteCompra, String tipoCom) {
        RespSimple response = new RespSimple();
        try {
            switch (tipoCom) {
                case "com": {
                    response.setData((Object)this.detalleComprobanteCompraDAO.findByComprobanteCompraOrderByIdDetalleCompraDesc(new TComprobanteCompra(idComprobanteCompra)));
                    break;
                }
                case "obl": {
                    response.setData((Object)this.detalleObligacionDAO.findByComprobanteObligacionOrderByIdDesc(new TComprobanteObligacion(idComprobanteCompra)));
                    break;
                }
                default: {
                    throw new CustomException("No existe el tipo de comprobante seleccionado");
                }
            }
            if (response.getData().equals(new ArrayList())) {
                throw new CustomException("Detalle no encontrado");
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("detalle obtenido");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            response.setData(null);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.severe("error: " + e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al listar el detalle");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> actualizarComprobanteObligacion(ComprobanteDetalleObligacionesMODEL comprobanteObligacionModel) {
        RespSimple response = new RespSimple();
        try {
            TComprobanteObligacion comprobanteObligacion = comprobanteObligacionModel.getComprobanteObligacion();
            List listDetalle = comprobanteObligacionModel.getDetalleComprobante();
            TComprobanteObligacion comprobanteDB = this.comprobanteObligacionDAO.findById((Object)comprobanteObligacion.getId()).orElse(null);
            if (comprobanteDB == null) {
                throw new CustomException("No existe el comprobante a modificar");
            }
            comprobanteDB.setUpdatedAt(new Date());
            comprobanteDB.setSustentoTributario(comprobanteObligacion.getSustentoTributario());
            comprobanteDB.setConcepto(comprobanteObligacion.getConcepto());
            if (comprobanteObligacion.getAutorizacionDocumento().length() != 49) {
                comprobanteDB.setTipoDocumentoTributario(comprobanteObligacion.getTipoDocumentoTributario());
                comprobanteDB.setEstablecimientoComprobanteCompra(comprobanteObligacion.getEstablecimientoComprobanteCompra());
                comprobanteDB.setPuntoEmisionComprobanteCompra(comprobanteObligacion.getPuntoEmisionComprobanteCompra());
                comprobanteDB.setNumeroComprobanteCompra(comprobanteObligacion.getNumeroComprobanteCompra());
                comprobanteDB.setProveedor(comprobanteObligacion.getProveedor());
                comprobanteDB.setAutorizacionDocumento(comprobanteObligacion.getAutorizacionDocumento());
            }
            for (TDetalleCompraObligacion det : listDetalle) {
                TDetalleCompraObligacion detDB = this.detalleObligacionDAO.findById((Object)det.getId()).orElse(null);
                if (detDB == null) {
                    throw new CustomException("No existe un detalle con la informaci\u00f3n ingresada");
                }
                TCuentaContable cuentaNueva = this.cuentaContableDAO.findById((Object)det.getCuentaContable().getIdCuentaContable()).orElse(null);
                if (cuentaNueva == null) {
                    throw new CustomException("No existe una cuenta contable con la informaci\u00f3n ingresada");
                }
                detDB.setCuentaContable(cuentaNueva);
                this.detalleObligacionDAO.save((Object)detDB);
            }
            response.setData(this.comprobanteObligacionDAO.save((Object)comprobanteDB));
            response.setMensaje("Comprobante guardado correctamente");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al actualizar el comprobante");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

