/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.integracion.TSecuenciaComprobante;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TTSecuenciaComprobanteDAO;
import ec.tws2.back.contfiables.services.SecuenciaComprobanteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SecuenciasServiceImpl
implements SecuenciaComprobanteService {
    @Autowired
    private TTSecuenciaComprobanteDAO secueciaComprobanteDAO;

    public ResponseEntity<RespSimple> obtenerSecuenciaComprobanteX(Long idTipoComprobante, Long idPuntoVenta) {
        RespSimple response = new RespSimple();
        try {
            TSecuenciaComprobante secuencia = this.secueciaComprobanteDAO.findByPuntoVentaAndTipoComprobante(idPuntoVenta, idTipoComprobante);
            if (secuencia == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("No se encontr\u00f3 la secuencia solicitada");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Secuencia encontrada");
            response.setData((Object)secuencia);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al buscar la secuencia solicitada");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

