/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDAO;
import ec.tws2.back.contfiables.services.FacturaService;
import ec.tws2.back.contfiables.services.impl.facturacion.ReenvioFacturacionService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ReenvioProgramadoFacturasService {
    Logger log = Logger.getLogger(ReenvioProgramadoFacturasService.class.getName());
    @Autowired
    FacturaService facturacionService;
    @Autowired
    TFacturaDAO facturaDAO;
    @Autowired
    ReenvioFacturacionService facturacionServiceWEB;
    @Autowired
    RestTemplate template;
    @Value(value="${property.path.enviacorreo}")
    private String urlEnviarCorreo;

    @Scheduled(fixedRate=0x6DDD00L)
    public void doSomethingScheduled() {
        this.log.log(Level.INFO, "Tarea programada ejecutada");
        List listaFacturas = this.facturacionService.obtenerTodasFacturasNoAutorizadas();
        for (TFactura fac : listaFacturas) {
            this.log.info("PROCESANDO LA FACTURA: " + fac.getId());
            if (fac.getIntentosAutorizacion() > 2) continue;
            ResponseEntity response = this.facturacionServiceWEB.cargarDatosFactura(fac);
            RespSimple resp = (RespSimple)response.getBody();
            if (resp == null) {
                this.log.info("ERROR AL ENVIAR LA FACTURA POR LA TAREA AUTOMATICA: No se recibi\u00f3 respuesta.");
                continue;
            }
            if (resp.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
                this.log.info("ERROR AL ENVIAR LA FACTURA POR LA TAREA AUTOMATICA: ".concat(resp.getMensaje()));
                continue;
            }
            this.log.warning("FACTURA AUTORIZADA Y ENVIADA POR LA TAREA AUTOMATICA: ".concat(resp.getMensaje()));
        }
    }

    @Scheduled(fixedRate=1300000L)
    public void enviarCorreos() {
        this.log.info("EJECUCION DE ENVIO DE CORREOS DE FACTURAS AUTORIZADAS AUTOMATICO");
        try {
            List facturasNoEnviadas = this.facturacionService.obtenerFacturasNoEnviadas();
            for (TFactura f : facturasNoEnviadas) {
                try {
                    this.log.info("ENVIANDO POR CORREO LA FACTURA: " + f.getId());
                    this.facturacionServiceWEB.enviarCorreo(f);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "ERROR AL ENVIAR POR CORREO LA FACTURA: " + f.getId(), e);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR EN EL PROCESO AUTOMATICO DE REENVIO DE FACTURAS", e);
        }
    }
}

