/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.util.CrearFormatoCorreo;
import ec.tws2.back.contfiables.models.domain.CampoAdicional;
import ec.tws2.back.contfiables.models.domain.DatosFactura;
import ec.tws2.back.contfiables.models.domain.DatosFacturasDetalle;
import ec.tws2.back.contfiables.models.domain.Detalle;
import ec.tws2.back.contfiables.models.domain.Detalles;
import ec.tws2.back.contfiables.models.domain.Factura;
import ec.tws2.back.contfiables.models.domain.Impuesto;
import ec.tws2.back.contfiables.models.domain.Impuestos;
import ec.tws2.back.contfiables.models.domain.InfoAdicional;
import ec.tws2.back.contfiables.models.domain.InfoFactura;
import ec.tws2.back.contfiables.models.domain.InfoTributaria;
import ec.tws2.back.contfiables.models.domain.Pago;
import ec.tws2.back.contfiables.models.domain.Pagos;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.domain.TotalConImpuestos;
import ec.tws2.back.contfiables.models.domain.TotalImpuesto;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TFacturaDetalle;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPagoComprobantes;
import ec.tws2.back.contfiables.models.entities.facturacion.TSecuenciaFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TTarifaIva;
import ec.tws2.back.contfiables.models.entities.integracion.TPeticion;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoComprobantesDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TSecuenciaFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TarifaIvaDAO;
import ec.tws2.back.contfiables.services.FacturaService;
import ec.tws2.back.contfiables.services.PeticionService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

@Service
public class ReenvioFacturacionService {
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TarifaIvaDAO tarifaIvaDAO;
    @Autowired
    private TSecuenciaFacturaDAO secuenciaFacturaDAO;
    @Autowired
    private PeticionService peticionService;
    @Autowired
    private FacturaService facturaService;
    @Autowired
    private TFacturaDAO facturaDAO;
    @Autowired
    RestTemplate template;
    @Value(value="${property.ambiente.factura}")
    private String ambiente;
    @Value(value="${property.path.factura}")
    private String urlFacturar;
    @Value(value="${property.path.enviacorreo}")
    private String urlEnviarCorreo;
    @Autowired
    private TFormaPagoComprobantesDAO formaPagoComprobanteDAO;
    Logger log = Logger.getLogger(ReenvioFacturacionService.class.getName());

    public ResponseEntity<RespSimple> buscarFacturaAreeenviar(BigDecimal idFactura) {
        try {
            TFactura factura = this.facturaDAO.findById((Object)idFactura).orElse(null);
            if (factura == null) {
                return Transaccion.NOTFOUNT((String)"No existe la factura solicitada");
            }
            ResponseEntity resp = this.cargarDatosFactura(factura);
            RespSimple response = (RespSimple)resp.getBody();
            if (response == null) {
                return Transaccion.CUSTOM_EXCEPTION((String)"No se recibi\u00f3 respuesta al cargar datos de la factura.");
            }
            if (response.getCodigo().equals(ContfiablesEnum.TRANSACCION_OK.getId())) {
                return Transaccion.OK((String)response.getMensaje(), null);
            }
            return Transaccion.CUSTOM_EXCEPTION((String)response.getMensaje());
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)("Error al buscar la factura a enviar: " + e.getMessage()));
        }
    }

    public ResponseEntity<RespSimple> cargarDatosFactura(TFactura fac) {
        String direccionMatriz;
        DatosFactura datosFactura = new DatosFactura();
        String string = direccionMatriz = fac.getPuntoVenta().getDireccion() == null ? fac.getCliente().getCiudad() : fac.getPuntoVenta().getDireccion();
        if (direccionMatriz.length() >= 300) {
            direccionMatriz = direccionMatriz.substring(0, 299);
        }
        datosFactura.setDireccion(direccionMatriz);
        datosFactura.setFechaEmision(fac.getFechaEmision());
        datosFactura.setRuc(fac.getCliente().getIdentification());
        datosFactura.setRazonSocialComprador(fac.getIdAdquiriente().getRazonSocial());
        datosFactura.setIdentificacionComprador(fac.getIdAdquiriente().getIdentificacion());
        datosFactura.setDireccionComprador(fac.getIdAdquiriente().getDireccion());
        datosFactura.setTelefonoComprador(fac.getIdAdquiriente().getTelefono());
        datosFactura.setEmailComprador(fac.getIdAdquiriente().getEmailAdquiriente());
        datosFactura.setDescuentoComprador(fac.getDescuento());
        datosFactura.setCodigoIdentificacion(fac.getIdAdquiriente().getIdTipoIdentificacion().getCodigo());
        datosFactura.setObservacionesComprador(fac.getObservacionesComprador());
        datosFactura.setNumComprobante(fac.getNumComprobante());
        datosFactura.setLstDetalle(new ArrayList());
        List facturaDetalle = this.facturaService.getDetalleFactura(fac.getId());
        for (TFacturaDetalle fd : facturaDetalle) {
            DatosFacturasDetalle dtsDetalle = new DatosFacturasDetalle();
            dtsDetalle.setDescripcion(fd.getIdProducto().getNombreProducto());
            dtsDetalle.setCodigo(fd.getIdProducto().getCodigo());
            dtsDetalle.setValor(fd.getValorTotal());
            dtsDetalle.setCantidad(fd.getCantidad());
            dtsDetalle.setCodigoIva(fd.getIdProducto().getIdTarifaIva().getIdTarifaIva());
            datosFactura.getLstDetalle().add(dtsDetalle);
        }
        ResponseEntity response = this.reenviarFactura(datosFactura, fac.getId());
        RespSimple resp = (RespSimple)response.getBody();
        if (resp == null) {
            return Transaccion.CUSTOM_EXCEPTION((String)"No se recibi\u00f3 respuesta al reenviar la factura.");
        }
        this.log.log(Level.WARNING, resp.getMensaje());
        TFactura fact = this.facturaService.getFactura(fac.getId());
        fact.setIntentosAutorizacion(fact.getIntentosAutorizacion() + 1);
        fact.setEnviada(Boolean.valueOf(false));
        this.facturaDAO.save((Object)fact);
        if (!resp.getCodigo().equals(ContfiablesEnum.TRANSACCION_OK.getId())) {
            return Transaccion.OK((String)resp.getMensaje(), null);
        }
        if (resp.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
            return Transaccion.ERROR((String)("Error al reenviar factura: " + resp.getMensaje()));
        }
        try {
            this.enviarCorreo(fact);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Factura autorizada pero no eviada por correo " + e.getMessage());
            return Transaccion.ERROR((String)("Error al enviar factura por email: " + e.getMessage()));
        }
        this.log.log(Level.INFO, "response controlador automatico: " + resp.getMensaje());
        return Transaccion.OK((String)"Factura autorizada y enviada correctamente", null);
    }

    @Transactional
    public ResponseEntity<RespSimple> reenviarFactura(@RequestBody DatosFactura datosFacturas, BigDecimal idFactura) {
        this.log.log(Level.INFO, "PROCESO REENVIO FACTURAS");
        RespSimple respuesta = new RespSimple();
        Factura factura = new Factura();
        try {
            TCliente cliente = this.clienteDAO.getCliente4identificacion(datosFacturas.getRuc());
            TSecuenciaFactura secuenciaFactura = this.secuenciaFacturaDAO.findByCliente(cliente);
            factura.setInfoTributaria(new InfoTributaria());
            factura.getInfoTributaria().setAmbiente(this.ambiente);
            factura.getInfoTributaria().setTipoEmision(ContfiablesEnum.TIPO_EMISION.getId());
            factura.getInfoTributaria().setRazonSocial(cliente.getNombres().concat(" ").concat(cliente.getApellidos()));
            factura.getInfoTributaria().setRuc(cliente.getIdentification());
            factura.getInfoTributaria().setCodDoc(secuenciaFactura.getCodigoDocumento());
            factura.getInfoTributaria().setEstab(secuenciaFactura.getEstablecimiento());
            factura.getInfoTributaria().setPtoEmi(secuenciaFactura.getPuntoEmision());
            factura.getInfoTributaria().setSecuencial(datosFacturas.getNumComprobante().isEmpty() ? this.getSecuencia(cliente) : datosFacturas.getNumComprobante());
            factura.getInfoTributaria().setDirMatriz(datosFacturas.getDireccion());
            factura.getInfoTributaria().setContribuyenteRimpe(this.getTipoRegimen(cliente));
            factura.setInfoFactura(new InfoFactura());
            if (cliente.getNombreComercial() != null) {
                cliente.setNombreComercial(cliente.getNombreComercial().isEmpty() ? " " : cliente.getNombreComercial());
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            factura.getInfoFactura().setFechaEmision(dateFormat.format(datosFacturas.getFechaEmision()));
            factura.getInfoTributaria().setNombreComercial(cliente.getNombreComercial() == null ? " " : cliente.getNombreComercial());
            factura.getInfoFactura().setDirEstablecimiento(datosFacturas.getDireccion());
            factura.getInfoFactura().setObligadoContabilidad(cliente.getObligadoContabilidad() != false ? ContfiablesEnum.SI_OBLIGADO_CONTABILIDAD.getId() : ContfiablesEnum.NO_OBLIGADO_CONTABILIDAD.getId());
            factura.getInfoFactura().setTipoIdentificacionComprador(datosFacturas.getCodigoIdentificacion());
            factura.getInfoFactura().setRazonSocialComprador(datosFacturas.getRazonSocialComprador());
            factura.getInfoFactura().setIdentificacionComprador(datosFacturas.getIdentificacionComprador());
            factura.getInfoFactura().setDireccionComprador(datosFacturas.getDireccionComprador());
            TotalImpuesto totalImpuestoso = new TotalImpuesto();
            BigDecimal subTotalFactura = BigDecimal.ZERO;
            BigDecimal descuentoTotalFactura = BigDecimal.ZERO;
            List listaCodSri = this.tarifaIvaDAO.getCodigosIva();
            HashMap<String, TotalImpuesto> mapImpuestos = new HashMap<String, TotalImpuesto>();
            ArrayList<TotalImpuesto> lstTotalImpuesto = new ArrayList<TotalImpuesto>();
            for (DatosFacturasDetalle detalleT : datosFacturas.getLstDetalle()) {
                TTarifaIva tarifaIva = this.tarifaIvaDAO.getTarifa4Id(detalleT.getCodigoIva());
                BigDecimal porcentual = BigDecimal.valueOf(tarifaIva.getPorcentaje().intValue()).divide(new BigDecimal("100"));
                BigDecimal subTotalDetalle = BigDecimal.ZERO;
                BigDecimal descuentoDetalle = BigDecimal.ZERO;
                Object totalFinal = BigDecimal.ZERO;
                for (String codSri : listaCodSri) {
                    totalImpuestoso = new TotalImpuesto();
                    if (!tarifaIva.getCodigoSri().equals(codSri)) continue;
                    subTotalDetalle = detalleT.getValor().multiply(detalleT.getCantidad());
                    descuentoDetalle = subTotalDetalle.multiply(datosFacturas.getDescuentoComprador()).divide(BigDecimal.valueOf(100L));
                    totalFinal = subTotalDetalle.subtract(descuentoDetalle);
                    descuentoTotalFactura = descuentoTotalFactura.add(descuentoDetalle);
                    subTotalFactura = subTotalFactura.add((BigDecimal)totalFinal);
                    factura.getInfoFactura().setTotalSinImpuestos(subTotalFactura.setScale(2, RoundingMode.HALF_UP));
                    factura.getInfoFactura().setTotalDescuento(descuentoTotalFactura.setScale(2, RoundingMode.HALF_UP));
                    totalImpuestoso.setCodigo(ContfiablesEnum.CODIGO_IVA.getId());
                    totalImpuestoso.setCodigoPorcentaje(tarifaIva.getCodigoSri());
                    totalImpuestoso.setBaseImponible(((BigDecimal)totalFinal).setScale(2, RoundingMode.HALF_UP));
                    totalImpuestoso.setTarifa(tarifaIva.getPorcentaje().intValue());
                    totalImpuestoso.setValor(((BigDecimal)totalFinal).multiply(porcentual).setScale(2, RoundingMode.HALF_UP));
                    if (mapImpuestos.containsKey(tarifaIva.getCodigoSri())) {
                        TotalImpuesto imp = (TotalImpuesto)mapImpuestos.get(tarifaIva.getCodigoSri());
                        totalImpuestoso.setBaseImponible(totalImpuestoso.getBaseImponible().add(imp.getBaseImponible()));
                        totalImpuestoso.setValor(totalImpuestoso.getValor().add(imp.getValor()));
                    }
                    mapImpuestos.put(tarifaIva.getCodigoSri(), totalImpuestoso);
                }
            }
            lstTotalImpuesto = new ArrayList();
            for (TotalImpuesto ti : mapImpuestos.values()) {
                lstTotalImpuesto.add(ti);
            }
            TotalConImpuestos totalConImpuesto = new TotalConImpuestos();
            totalConImpuesto.setTotalImpuesto(lstTotalImpuesto);
            factura.getInfoFactura().setTotalConImpuestos(totalConImpuesto);
            BigDecimal totalImpuestosFromMap = new BigDecimal(0);
            for (TotalImpuesto ti : lstTotalImpuesto) {
                totalImpuestosFromMap = totalImpuestosFromMap.add(ti.getValor()).setScale(2, RoundingMode.HALF_UP);
            }
            factura.getInfoFactura().setImporteTotal(subTotalFactura.add(totalImpuestosFromMap).setScale(2, RoundingMode.HALF_UP));
            Pagos pagos = new Pagos();
            Pago pago = new Pago();
            List formasPago = this.formaPagoComprobanteDAO.findByFactura(idFactura);
            ArrayList<Pago> lstPago = new ArrayList<Pago>();
            for (TFormaPagoComprobantes fp : formasPago) {
                pago.setFormaPago(fp.getFormaPago().getCodigoSri());
                pago.setTotal(fp.getValor().setScale(2, RoundingMode.HALF_UP));
                lstPago.add(pago);
            }
            pagos.setPago(lstPago);
            factura.getInfoFactura().setPagos(pagos);
            BigDecimal totalImpuestos = new BigDecimal(0);
            Detalles detalles = new Detalles();
            ArrayList<Detalle> lstDetalle = new ArrayList<Detalle>();
            for (DatosFacturasDetalle detalleP : datosFacturas.getLstDetalle()) {
                Detalle detalle = new Detalle();
                detalle.setCodigoPrincipal(detalleP.getCodigo());
                detalle.setCodigoAuxiliar(detalleP.getCodigo());
                detalle.setDescripcion(detalleP.getDescripcion());
                detalle.setCantidad(detalleP.getCantidad());
                detalle.setPrecioUnitario(detalleP.getValor().setScale(4, RoundingMode.HALF_UP));
                detalle.setDescuento(detalleP.getValor().multiply(detalleP.getCantidad()).multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP));
                BigDecimal totalSinIva = detalleP.getValor().multiply(detalleP.getCantidad());
                detalle.setPrecioTotalSinImpuesto(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP));
                Impuestos impuestos = new Impuestos();
                Impuesto impuesto = new Impuesto();
                TTarifaIva tarifaIvaDetalle = this.tarifaIvaDAO.getTarifa4Id(detalleP.getCodigoIva());
                BigDecimal porcentualDetalle = BigDecimal.valueOf(tarifaIvaDetalle.getPorcentaje().intValue()).divide(new BigDecimal("100"));
                impuesto.setCodigo(ContfiablesEnum.CODIGO_IVA.getId());
                impuesto.setCodigoPorcentaje(tarifaIvaDetalle.getCodigoSri());
                impuesto.setTarifa(tarifaIvaDetalle.getPorcentaje().intValue());
                impuesto.setBaseImponible(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP));
                impuesto.setValor(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).multiply(porcentualDetalle).setScale(2, RoundingMode.HALF_UP));
                totalImpuestos = totalImpuestos.add(impuesto.getValor());
                ArrayList<Impuesto> lstImpuesto = new ArrayList<Impuesto>();
                lstImpuesto.add(impuesto);
                impuestos.setImpuesto(lstImpuesto);
                detalle.setImpuestos(impuestos);
                lstDetalle.add(detalle);
            }
            detalles.setDetalle(lstDetalle);
            factura.setDetalles(detalles);
            InfoAdicional infoAdicional = new InfoAdicional();
            CampoAdicional campoAdicional = new CampoAdicional();
            CampoAdicional campoAdicional2 = new CampoAdicional();
            CampoAdicional campoAdicional3 = new CampoAdicional();
            campoAdicional.setValue(datosFacturas.getEmailComprador());
            campoAdicional.setNombre("Correo:");
            campoAdicional2.setValue(datosFacturas.getTelefonoComprador());
            campoAdicional2.setNombre("Celular/Telefono:");
            campoAdicional3.setValue(datosFacturas.getObservacionesComprador().isEmpty() ? "Ninguna" : datosFacturas.getObservacionesComprador());
            campoAdicional3.setNombre("Observaciones:");
            ArrayList<CampoAdicional> lstCampoAdicional = new ArrayList<CampoAdicional>();
            lstCampoAdicional.add(campoAdicional);
            lstCampoAdicional.add(campoAdicional2);
            lstCampoAdicional.add(campoAdicional3);
            infoAdicional.setCampoAdicional(lstCampoAdicional);
            factura.setInfoAdicional(infoAdicional);
            TFactura tFacturaGuardad = new TFactura();
            tFacturaGuardad = this.facturaService.getFacturaByNumComprobante(factura.getInfoTributaria().getSecuencial(), cliente);
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            respuesta.setError("");
            respuesta.setMensaje("Factura registrada");
            try {
                respuesta = (RespSimple)this.template.postForObject(this.urlFacturar, (Object)factura, RespSimple.class, new Object[0]);
                if (respuesta == null) {
                    respuesta = new RespSimple();
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    respuesta.setMensaje("No se recibi\u00f3 respuesta del servicio de facturaci\u00f3n.");
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
                if (respuesta.getCodigo().contains("ERR")) {
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    respuesta.setMensaje(respuesta.getMensaje());
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
            }
            catch (Exception con) {
                this.log.log(Level.SEVERE, "ERROR DE CONEXION AL SRI: ", con);
                if (con.getMessage().contains("I/O error on POST request")) {
                    if (respuesta != null) {
                        respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                        respuesta.setMensaje("El servidor del SRI est\u00e1 intermitente, su factura se enviar\u00e1 luego.");
                    }
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
                if (respuesta != null) {
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    respuesta.setMensaje("Factura creada pero no autorizada");
                }
                return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
            }
            try {
                TPeticion peticion;
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                respuesta.setDescripcion(tFacturaGuardad != null ? String.valueOf(tFacturaGuardad.getId()) : "");
                respuesta.setMensaje(respuesta.getDescripcion());
                if (tFacturaGuardad != null) {
                    tFacturaGuardad.setRespuestaSri(respuesta.getDescripcion());
                    this.facturaService.actualizarMensajeSRIFactura(tFacturaGuardad);
                }
                if ((peticion = this.peticionService.obtenerPeticionPorNumeroComprobanteYidCliente(factura.getInfoTributaria().getSecuencial(), Long.valueOf(cliente.getIdCliente().toString()))) != null) {
                    String claveAcces = peticion.getClaveAcceso();
                    String autorizacion = peticion.getNumeroAutorizacion();
                    this.facturaService.actualizarClaveAccesoSRIFactura(cliente.getIdCliente(), factura.getInfoTributaria().getSecuencial(), claveAcces, respuesta.getDescripcion());
                    if (autorizacion == null) {
                        this.log.severe("ERROR DE AUTORIZACION: ".concat(respuesta.getDescripcion()));
                        if (respuesta.getDescripcion().contains("ARCHIVO NO CUMPLE ESTRUCTURA XML")) {
                            return Transaccion.XML_MALFORMED((String)"Factura emitida en espera de revisi\u00f3n.", null);
                        }
                        return Transaccion.XML_MALFORMED((String)"Factura emitida en espera de revisi\u00f3n.", null);
                    }
                    if (claveAcces != null && autorizacion.equals(claveAcces) && tFacturaGuardad != null) {
                        tFacturaGuardad.setIsAutorizado(Boolean.valueOf(true));
                        this.facturaService.actualizarEstadoFactura(tFacturaGuardad);
                    }
                }
            }
            catch (Exception ex) {
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                respuesta.setMensaje(respuesta.getDescripcion());
                this.log.log(Level.SEVERE, "ERROR: ", ex);
                return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            if (respuesta != null) {
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                respuesta.setError("Error");
                respuesta.setMensaje("Error en el proceso de facturaci\u00f3n");
                respuesta.setDescripcion(e.getMessage());
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.log.log(Level.SEVERE, "EJECUTANDO ROLLBACK POR ERROR AL REALIZAR LA FACTURACION: ", e);
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
        }
    }

    @Transactional
    public String getSecuencia(TCliente Cliente) {
        String respuesta = "";
        try {
            TSecuenciaFactura secuenciaRespuesta = this.secuenciaFacturaDAO.findByCliente(Cliente);
            if (secuenciaRespuesta.getSecuencial().toString().length() < 9) {
                respuesta = secuenciaRespuesta.getSecuencial().toString();
                for (int i = respuesta.length(); i < 9; ++i) {
                    respuesta = "0".concat(respuesta);
                }
                secuenciaRespuesta.setSecuencial(Integer.valueOf(secuenciaRespuesta.getSecuencial() + 1));
                secuenciaRespuesta = (TSecuenciaFactura)this.secuenciaFacturaDAO.save((Object)secuenciaRespuesta);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error al obtener las secuencias ", e);
        }
        return respuesta;
    }

    public void enviarCorreo(TFactura f) {
        String html = new CrearFormatoCorreo().generarCorreoHTML(f);
        String correo = f.getIdAdquiriente().getEmailAdquiriente();
        if (f.getIdAdquiriente().getIdentificacion().equals("9999999999999")) {
            correo = f.getCliente().getEmailCliente();
        }
        String claveAcceso = f.getAuthorizacion();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"claveAcceso", (Object)claveAcceso);
        parameters.add((Object)"correoAdquiriente", (Object)correo);
        parameters.add((Object)"cuerpo", (Object)(html + "\n"));
        HttpEntity requestEntity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
        try {
            String respuesta = (String)this.template.postForObject(this.urlEnviarCorreo, (Object)requestEntity, String.class, new Object[0]);
            this.log.info("respuesta correo: " + respuesta);
            f.setEnviada(Boolean.valueOf(true));
            this.facturaDAO.save((Object)f);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL ENVIAR CORREO: ", e);
        }
    }

    private String getTipoRegimen(TCliente cliente) {
        if (cliente.getTipoEmprendedor() == null) {
            return null;
        }
        if (cliente.getTipoEmprendedor().equals(ContfiablesEnum.CONTRIBUYENTE_GENERAL.getDescripcion())) {
            return null;
        }
        return cliente.getTipoEmprendedor();
    }
}

