/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.models.entities.integracion.TEstablecimiento;
import ec.tws2.back.contfiables.models.entities.integracion.TPuntoVenta;
import ec.tws2.back.contfiables.models.entities.integracion.TSecuenciaComprobante;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TTSecuenciaComprobanteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoComprobanteDAO;
import ec.tws2.back.contfiables.repositories.integracion.TEstablecimientoDAO;
import ec.tws2.back.contfiables.repositories.integracion.TPuntoVentaDAO;
import ec.tws2.back.contfiables.services.PuntoVentaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PuntoVentaServiceImpl
implements PuntoVentaService {
    @Autowired
    private TPuntoVentaDAO puntoVentaDAO;
    @Autowired
    private TTSecuenciaComprobanteDAO secuenciaComprobanteDAO;
    @Autowired
    private TTipoComprobanteDAO tipoComprobanteDAO;
    @Autowired
    private TEstablecimientoDAO establecimientoDAO;

    public ResponseEntity<RespSimple> obtenerPuntosVenta(Long idEstableciemiento) {
        RespSimple response = new RespSimple();
        TEstablecimiento establecimiento = this.establecimientoDAO.findById((Object)idEstableciemiento).orElse(null);
        if (establecimiento == null) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Los establecimientos del cliente solicitado no se encontrar\u00f3n.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        List listaPuntosVenta = this.puntoVentaDAO.findByEstablecimientoAndActivo(establecimiento, true);
        response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
        response.setMensaje("Lista de puntos de venta obtenido");
        response.setData((Object)listaPuntosVenta);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional
    public ResponseEntity<RespSimple> registrarPuntoVenta(TPuntoVenta puntoVenta) {
        RespSimple response = new RespSimple();
        if (puntoVenta.getIdPuntoVenta() != null) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Este registro ya contiene un identificador, no se puede registrar.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            TEstablecimiento establecimiento = this.establecimientoDAO.findById((Object)puntoVenta.getEstablecimiento().getIdEstablecimiento()).orElse(null);
            if (establecimiento == null) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Establecimiento del cliente solicitado no se encontr\u00f3.");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            boolean existe = this.puntoVentaDAO.existsByEstablecimientoAndPuntoEmision(establecimiento, puntoVenta.getPuntoEmision());
            if (existe) {
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Ya existe un punto de venta con esos datos.");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            TPuntoVenta puntoDB = (TPuntoVenta)this.puntoVentaDAO.save((Object)puntoVenta);
            List listaComprobantes = this.tipoComprobanteDAO.findAll();
            for (TTipoComprobante tc : listaComprobantes) {
                TSecuenciaComprobante secuencia = new TSecuenciaComprobante();
                secuencia.setActivo(true);
                secuencia.setPuntoVenta(puntoDB);
                secuencia.setTipoComprobante(tc);
                secuencia.setSecuencia(1L);
                this.secuenciaComprobanteDAO.save((Object)secuencia);
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Punto de venta creado.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (DataAccessException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al registrar el punto de emisi\u00f3n.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> obtenerEstablecimientos(Long idCliente) {
        RespSimple response = new RespSimple();
        response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
        response.setMensaje("lista obtenida");
        List establecimientos = this.establecimientoDAO.findByCliente(new TCliente(idCliente));
        response.setData((Object)establecimientos);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }
}

