/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.util.AsignarHoraDATE;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoComprobantesDAO;
import ec.tws2.back.contfiables.services.TFormaPagoComprobantesService;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FormaPagoComprobanteServiceImpl
implements TFormaPagoComprobantesService {
    @Autowired
    private TFormaPagoComprobantesDAO formaPagoComprobantesDAO;

    public ResponseEntity<RespSimple> getValueFacturasEfectivo(Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            response.setData((Object)this.formaPagoComprobantesDAO.buscarFacturasEfectivo(idCliente));
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Valor de las facturas con la forma de pago 'EFECTIVO'");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setDescripcion(e.getMessage());
            response.setMensaje("Error al obtener el valor de las facturas con la forma de pago 'EFECTIVO'");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getValueFacturasCredito(Long idCliente) {
        RespSimple response = new RespSimple();
        try {
            BigDecimal valor = this.formaPagoComprobantesDAO.buscarFacturasConCreditoActivo(idCliente, new AsignarHoraDATE().asiganarHora(new Date(), "inicio"));
            response.setData((Object)(valor == null ? BigDecimal.ZERO : valor));
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Valor de las facturas con la forma de pago 'CREDITO'");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setDescripcion(e.getMessage());
            response.setMensaje("Error al obtener el valor de las facturas con la forma de pago 'CREDITO'");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

