/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.util.CrearFormatoCorreo;
import ec.tws2.back.contfiables.core.validations.IdentificationValidator;
import ec.tws2.back.contfiables.core.validations.RegsValidation;
import ec.tws2.back.contfiables.models.domain.CampoAdicional;
import ec.tws2.back.contfiables.models.domain.DatosFactura;
import ec.tws2.back.contfiables.models.domain.DatosFacturasDetalle;
import ec.tws2.back.contfiables.models.domain.Detalle;
import ec.tws2.back.contfiables.models.domain.Detalles;
import ec.tws2.back.contfiables.models.domain.Factura;
import ec.tws2.back.contfiables.models.domain.FacturaDetalle;
import ec.tws2.back.contfiables.models.domain.Impuesto;
import ec.tws2.back.contfiables.models.domain.Impuestos;
import ec.tws2.back.contfiables.models.domain.InfoAdicional;
import ec.tws2.back.contfiables.models.domain.InfoFactura;
import ec.tws2.back.contfiables.models.domain.InfoTributaria;
import ec.tws2.back.contfiables.models.domain.Pago;
import ec.tws2.back.contfiables.models.domain.Pagos;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.domain.TotalConImpuestos;
import ec.tws2.back.contfiables.models.domain.TotalImpuesto;
import ec.tws2.back.contfiables.models.dtos.FirmaCaducidadContfiablesDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TAdquiriente;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.cliente.TTipoAdquiriente;
import ec.tws2.back.contfiables.models.entities.cliente.TTipoIdentificacion;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TFacturaDetalle;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPago;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPagoComprobantes;
import ec.tws2.back.contfiables.models.entities.facturacion.TSecuenciaFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TTarifaIva;
import ec.tws2.back.contfiables.models.entities.integracion.TPeticion;
import ec.tws2.back.contfiables.models.entities.integracion.TPuntoVenta;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TAdquirenteDAO;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.cliente.TTipoAdquirienteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TSecuenciaFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TarifaIvaDAO;
import ec.tws2.back.contfiables.repositories.integracion.TPuntoVentaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TBodegaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoIdentificacionDAO;
import ec.tws2.back.contfiables.services.AdquirienteService;
import ec.tws2.back.contfiables.services.FacturaService;
import ec.tws2.back.contfiables.services.FirmaElectronicaService;
import ec.tws2.back.contfiables.services.PeticionService;
import ec.tws2.back.contfiables.services.SuscripcionContfiablesService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

@Service
public class FacturacionServiceImpl {
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TarifaIvaDAO tarifaIvaDAO;
    @Autowired
    private TProductoDAO tProductoDAO;
    @Autowired
    private AdquirienteService adquirienteService;
    @Autowired
    private TSecuenciaFacturaDAO secuenciaFacturaDAO;
    @Autowired
    private TTipoAdquirienteDAO tTipoAdquirienteDAO;
    @Autowired
    private TAdquirenteDAO tAdquirenteDAO;
    @Autowired
    private TTipoIdentificacionDAO tipoIdentificacionDAO;
    @Autowired
    private PeticionService peticionService;
    @Autowired
    private FacturaService facturaService;
    @Autowired
    private IdentificationValidator identificationValidatorService;
    @Autowired
    FirmaElectronicaService firmaElectronicaService;
    @Autowired
    private TBodegaDAO bodegaDAO;
    @Autowired
    private TPuntoVentaDAO puntoVentaDAO;
    @Autowired
    private TFacturaDAO facturaDAO;
    @Autowired
    private TFormaPagoDAO formaPagoDAO;
    @Autowired
    RestTemplate template;
    @Value(value="${property.ambiente.factura}")
    private String ambiente;
    @Value(value="${property.path.factura}")
    private String urlFacturar;
    Logger log = Logger.getLogger(FacturacionServiceImpl.class.getName());
    @Value(value="${property.path.enviacorreo}")
    private String urlEnviarCorreo;
    @Autowired
    private SuscripcionContfiablesService suscripcionService;

    @Transactional
    public ResponseEntity<RespSimple> facturar(@RequestBody DatosFactura datosFacturas) {
        this.log.info("Facturando");
        RespSimple respuesta = new RespSimple();
        Factura factura = new Factura();
        try {
            String direccionMatriz;
            TAdquiriente adquirienteResp;
            String username = this.clienteDAO.getUsernameByIdentificacion(datosFacturas.getRuc());
            if (username == null) {
                return Transaccion.NOTFOUNT((String)"No existe un contribuyente con esa identificaci\u00f3n");
            }
            RespSimple validarSuscripcion = (RespSimple)this.suscripcionService.validarSuscripcionCliente(username).getBody();
            if (validarSuscripcion == null) {
                throw new CustomExceptionNoCleanData("No se pudo validar la suscripci\u00f3n del cliente.");
            }
            if (validarSuscripcion.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
                throw new CustomExceptionNoCleanData(validarSuscripcion.getMensaje());
            }
            RespSimple sumarSecuenciaSuscripcion = (RespSimple)this.suscripcionService.actualizarSecuenciaSuscripcion(username).getBody();
            if (sumarSecuenciaSuscripcion == null) {
                throw new CustomExceptionNoCleanData("No se pudo actualizar la secuencia de la suscripci\u00f3n.");
            }
            if (sumarSecuenciaSuscripcion.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
                throw new CustomExceptionNoCleanData(sumarSecuenciaSuscripcion.getMensaje());
            }
            TCliente clienteFirma = this.clienteDAO.getCliente4identificacion(datosFacturas.getRuc());
            RespSimple respFirma = (RespSimple)this.firmaElectronicaService.getAlertaCaducidadFirma(clienteFirma.getIdCliente()).getBody();
            if (respFirma == null || respFirma.getData() == null) {
                throw new CustomExceptionNoCleanData("No se pudo validar la firma electr\u00f3nica.");
            }
            FirmaCaducidadContfiablesDTO cad = (FirmaCaducidadContfiablesDTO)respFirma.getData();
            if (cad.getFechaCaducidad() == null || "CADUCADO".equalsIgnoreCase(cad.getEstado())) {
                throw new CustomExceptionNoCleanData("No se puede facturar: debe renovar su firma electr\u00f3nica.");
            }
            if (datosFacturas.getIdBodega() == null || datosFacturas.getIdBodega() == 0L) {
                throw new CustomExceptionNoCleanData("Error al generar factura, la bodega es requerida");
            }
            if (datosFacturas.getIdPuntoVenta() == null || datosFacturas.getIdPuntoVenta() == 0L) {
                throw new CustomExceptionNoCleanData("Error al generar factura, el punto de venta es requerido");
            }
            TBodega bodega = this.bodegaDAO.findById((Object)datosFacturas.getIdBodega()).orElse(null);
            TPuntoVenta puntoEmision = this.puntoVentaDAO.findById((Object)datosFacturas.getIdPuntoVenta()).orElse(null);
            if (bodega == null) {
                throw new CustomExceptionNoCleanData("Error al generar factura, la bodega seleccionada no existe");
            }
            if (puntoEmision == null) {
                throw new CustomExceptionNoCleanData("Error al generar factura, el punto de venta seleccionado no existe");
            }
            TTipoIdentificacion tipoIdentificacion = this.tipoIdentificacionDAO.findByCodigo(datosFacturas.getCodigoIdentificacion());
            String identificacion = datosFacturas.getIdentificacionComprador();
            this.identificationValidatorService.validarIdentificacion(tipoIdentificacion.getCodigo(), identificacion);
            if (!RegsValidation.validarCorreoElectronico((String)datosFacturas.getEmailComprador())) {
                throw new CustomExceptionNoCleanData("Ingrese un correo electr\u00f3nico v\u00e1lido.");
            }
            if (this.adquirienteService.existeAdquiriente(datosFacturas.getIdentificacionComprador()).booleanValue()) {
                t_Adquiriente = (TAdquiriente)this.tAdquirenteDAO.findByIdentificacion(datosFacturas.getIdentificacionComprador()).get();
                if (!t_Adquiriente.getIdentificacion().equals("9999999999999")) {
                    t_Adquiriente.setIdentificacion(datosFacturas.getIdentificacionComprador());
                    t_Adquiriente.setRazonSocial(datosFacturas.getRazonSocialComprador());
                    t_Adquiriente.setDireccion(datosFacturas.getDireccionComprador());
                    t_Adquiriente.setTelefono(datosFacturas.getTelefonoComprador());
                    t_Adquiriente.setEmailAdquiriente(datosFacturas.getEmailComprador());
                    t_Adquiriente.setIdTipoIdentificacion(tipoIdentificacion);
                    t_Adquiriente.setDescuento(0);
                    adquirienteResp = (TAdquiriente)this.tAdquirenteDAO.save((Object)t_Adquiriente);
                } else {
                    adquirienteResp = t_Adquiriente;
                }
            } else {
                t_Adquiriente = new TAdquiriente();
                TTipoAdquiriente t_TipoAdquiriente = (TTipoAdquiriente)this.tTipoAdquirienteDAO.findById((Object)new BigDecimal("1")).get();
                t_Adquiriente.setIdTipoIdentificacion(tipoIdentificacion);
                t_Adquiriente.setIdentificacion(datosFacturas.getIdentificacionComprador());
                t_Adquiriente.setRazonSocial(datosFacturas.getRazonSocialComprador());
                t_Adquiriente.setDireccion(datosFacturas.getDireccionComprador());
                t_Adquiriente.setTelefono(datosFacturas.getTelefonoComprador());
                t_Adquiriente.setEmailAdquiriente(datosFacturas.getEmailComprador());
                t_Adquiriente.setDescuento(0);
                t_Adquiriente.setIdTipoAdquiriente(t_TipoAdquiriente);
                adquirienteResp = (TAdquiriente)this.tAdquirenteDAO.save((Object)t_Adquiriente);
            }
            TCliente cliente = this.clienteDAO.getCliente4identificacion(datosFacturas.getRuc());
            TSecuenciaFactura secuenciaFactura = this.secuenciaFacturaDAO.findByCliente(cliente);
            if (cliente.getNombreComercial() != null) {
                cliente.setNombreComercial(cliente.getNombreComercial().isEmpty() ? " " : cliente.getNombreComercial());
            }
            String string = direccionMatriz = puntoEmision.getDireccion() == null ? cliente.getCiudad() : puntoEmision.getDireccion();
            if (direccionMatriz.length() >= 300) {
                direccionMatriz = direccionMatriz.substring(0, 299);
            }
            factura.setInfoTributaria(new InfoTributaria());
            factura.getInfoTributaria().setAmbiente(this.ambiente);
            factura.getInfoTributaria().setTipoEmision(ContfiablesEnum.TIPO_EMISION.getId());
            factura.getInfoTributaria().setRazonSocial(cliente.getNombres().concat(" ").concat(cliente.getApellidos()));
            factura.getInfoTributaria().setNombreComercial(cliente.getNombreComercial() == null ? " " : cliente.getNombreComercial());
            factura.getInfoTributaria().setRuc(cliente.getIdentification());
            factura.getInfoTributaria().setCodDoc(secuenciaFactura.getCodigoDocumento());
            factura.getInfoTributaria().setEstab(secuenciaFactura.getEstablecimiento());
            factura.getInfoTributaria().setPtoEmi(secuenciaFactura.getPuntoEmision());
            factura.getInfoTributaria().setDirMatriz(direccionMatriz);
            factura.getInfoTributaria().setContribuyenteRimpe(this.getTipoRegimen(cliente));
            factura.setInfoFactura(new InfoFactura());
            ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
            LocalDateTime fechaHoraEcuador = LocalDateTime.now(zonaEcuador);
            Date fecha = Date.from(fechaHoraEcuador.toInstant(ZoneOffset.UTC));
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            factura.getInfoFactura().setFechaEmision(dateFormat.format(fecha));
            factura.getInfoFactura().setDirEstablecimiento(direccionMatriz);
            factura.getInfoFactura().setObligadoContabilidad(cliente.getObligadoContabilidad() != false ? ContfiablesEnum.SI_OBLIGADO_CONTABILIDAD.getId() : ContfiablesEnum.NO_OBLIGADO_CONTABILIDAD.getId());
            factura.getInfoFactura().setTipoIdentificacionComprador(datosFacturas.getCodigoIdentificacion());
            factura.getInfoFactura().setRazonSocialComprador(datosFacturas.getRazonSocialComprador());
            factura.getInfoFactura().setIdentificacionComprador(datosFacturas.getIdentificacionComprador());
            factura.getInfoFactura().setDireccionComprador(datosFacturas.getDireccionComprador());
            if (datosFacturas.getLstDetalle().isEmpty()) {
                throw new CustomExceptionNoCleanData("La lista de items est\u00e1 sin items.");
            }
            TotalImpuesto totalImpuestoso = new TotalImpuesto();
            BigDecimal subTotalFactura = BigDecimal.ZERO;
            BigDecimal descuentoTotalFactura = BigDecimal.ZERO;
            List listaCodSri = this.tarifaIvaDAO.getCodigosIva();
            HashMap<String, TotalImpuesto> mapImpuestos = new HashMap<String, TotalImpuesto>();
            ArrayList<TotalImpuesto> lstTotalImpuesto = new ArrayList<TotalImpuesto>();
            for (DatosFacturasDetalle detalleT : datosFacturas.getLstDetalle()) {
                TTarifaIva tarifaIva = this.tarifaIvaDAO.getTarifa4Id(detalleT.getCodigoIva());
                BigDecimal porcentual = BigDecimal.valueOf(tarifaIva.getPorcentaje().intValue()).divide(new BigDecimal("100"));
                BigDecimal subTotalDetalle = BigDecimal.ZERO;
                Object descuentoDetalle = BigDecimal.ZERO;
                BigDecimal totalFinal = BigDecimal.ZERO;
                for (Object codSri : listaCodSri) {
                    totalImpuestoso = new TotalImpuesto();
                    if (!tarifaIva.getCodigoSri().equals(codSri)) continue;
                    subTotalDetalle = detalleT.getValor().multiply(detalleT.getCantidad());
                    descuentoDetalle = subTotalDetalle.multiply(datosFacturas.getDescuentoComprador()).divide(BigDecimal.valueOf(100L));
                    totalFinal = subTotalDetalle.subtract((BigDecimal)descuentoDetalle);
                    descuentoTotalFactura = descuentoTotalFactura.add((BigDecimal)descuentoDetalle);
                    subTotalFactura = subTotalFactura.add(totalFinal);
                    factura.getInfoFactura().setTotalSinImpuestos(subTotalFactura.setScale(2, RoundingMode.HALF_UP));
                    factura.getInfoFactura().setTotalDescuento(descuentoTotalFactura.setScale(2, RoundingMode.HALF_UP));
                    totalImpuestoso.setCodigo(ContfiablesEnum.CODIGO_IVA.getId());
                    totalImpuestoso.setCodigoPorcentaje(tarifaIva.getCodigoSri());
                    totalImpuestoso.setBaseImponible(totalFinal.setScale(2, RoundingMode.HALF_UP));
                    totalImpuestoso.setTarifa(tarifaIva.getPorcentaje().intValue());
                    totalImpuestoso.setValor(totalFinal.multiply(porcentual).setScale(2, RoundingMode.HALF_UP));
                    if (mapImpuestos.containsKey(tarifaIva.getCodigoSri())) {
                        TotalImpuesto imp = (TotalImpuesto)mapImpuestos.get(tarifaIva.getCodigoSri());
                        totalImpuestoso.setBaseImponible(totalImpuestoso.getBaseImponible().add(imp.getBaseImponible()));
                        totalImpuestoso.setValor(totalImpuestoso.getValor().add(imp.getValor()));
                    }
                    mapImpuestos.put(tarifaIva.getCodigoSri(), totalImpuestoso);
                }
            }
            lstTotalImpuesto = new ArrayList();
            for (TotalImpuesto ti : mapImpuestos.values()) {
                lstTotalImpuesto.add(ti);
            }
            TotalConImpuestos totalConImpuesto = new TotalConImpuestos();
            totalConImpuesto.setTotalImpuesto(lstTotalImpuesto);
            factura.getInfoFactura().setTotalConImpuestos(totalConImpuesto);
            BigDecimal totalImpuestosFromMap = new BigDecimal(0);
            for (TotalImpuesto ti : lstTotalImpuesto) {
                totalImpuestosFromMap = totalImpuestosFromMap.add(ti.getValor()).setScale(2, RoundingMode.HALF_UP);
            }
            factura.getInfoFactura().setImporteTotal(subTotalFactura.add(totalImpuestosFromMap).setScale(2, RoundingMode.HALF_UP));
            Pagos pagos = new Pagos();
            Pago pago = new Pago();
            ArrayList<Pago> lstPago = new ArrayList<Pago>();
            if (datosFacturas.getFormaPagoComprobante() == null || datosFacturas.getFormaPagoComprobante().isEmpty()) {
                this.log.info("PAGO EN EFECTIVO");
                pago.setFormaPago(this.formaPagoDAO.getFormaPago4Id(Integer.valueOf(Integer.parseInt(ContfiablesEnum.PAGO_EFECTIVO.getId()))).getCodigoSri());
                pago.setTotal(factura.getInfoFactura().getImporteTotal().setScale(2, RoundingMode.HALF_UP));
                lstPago.add(pago);
                this.log.info("Forma de pago: " + pago.getFormaPago() + " Valor: " + pago.getTotal());
            } else {
                this.log.info("FORMA DE PAGO CON OPCIONES");
                for (TFormaPagoComprobantes formaPago : datosFacturas.getFormaPagoComprobante()) {
                    pagos = new Pagos();
                    if (datosFacturas.getFormaPagoComprobante().size() == 1) {
                        this.log.info("FORMA DE PAGO UNICO");
                        pago.setFormaPago(formaPago.getFormaPago().getCodigoSri());
                        pago.setTotal(factura.getInfoFactura().getImporteTotal().setScale(2, RoundingMode.HALF_UP));
                        ((TFormaPagoComprobantes)datosFacturas.getFormaPagoComprobante().get(0)).setValor(pago.getTotal());
                        lstPago.add(pago);
                        this.log.info("Forma de pago: " + pago.getFormaPago() + " Valor: " + pago.getTotal());
                        break;
                    }
                    pago.setFormaPago(formaPago.getFormaPago().getCodigoSri());
                    pago.setTotal(formaPago.getValor().setScale(2, RoundingMode.HALF_UP));
                    this.log.info("Forma de pago: " + pago.getFormaPago() + " Valor: " + pago.getTotal());
                    lstPago.add(pago);
                }
            }
            pagos.setPago(lstPago);
            factura.getInfoFactura().setPagos(pagos);
            BigDecimal totalImpuestos = new BigDecimal(0);
            Detalles detalles = new Detalles();
            ArrayList<Detalle> lstDetalle = new ArrayList<Detalle>();
            for (DatosFacturasDetalle detalleP : datosFacturas.getLstDetalle()) {
                Detalle detalle = new Detalle();
                detalle.setCodigoPrincipal(detalleP.getCodigo());
                detalle.setCodigoAuxiliar(detalleP.getCodigo());
                detalle.setDescripcion(detalleP.getDescripcion());
                detalle.setCantidad(detalleP.getCantidad());
                detalle.setPrecioUnitario(detalleP.getValor().setScale(4, RoundingMode.HALF_UP));
                detalle.setDescuento(detalleP.getValor().multiply(detalleP.getCantidad()).multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP));
                BigDecimal totalSinIva = detalleP.getValor().multiply(detalleP.getCantidad());
                detalle.setPrecioTotalSinImpuesto(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP));
                Impuestos impuestos = new Impuestos();
                Impuesto impuesto = new Impuesto();
                TTarifaIva tarifaIvaDetalle = this.tarifaIvaDAO.getTarifa4Id(detalleP.getCodigoIva());
                BigDecimal porcentualDetalle = BigDecimal.valueOf(tarifaIvaDetalle.getPorcentaje().intValue()).divide(new BigDecimal("100"));
                impuesto.setCodigo(ContfiablesEnum.CODIGO_IVA.getId());
                impuesto.setCodigoPorcentaje(tarifaIvaDetalle.getCodigoSri());
                impuesto.setTarifa(tarifaIvaDetalle.getPorcentaje().intValue());
                impuesto.setBaseImponible(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP));
                impuesto.setValor(totalSinIva.subtract(totalSinIva.multiply(datosFacturas.getDescuentoComprador().divide(new BigDecimal("100")))).multiply(porcentualDetalle).setScale(2, RoundingMode.HALF_UP));
                totalImpuestos = totalImpuestos.add(impuesto.getValor());
                ArrayList<Impuesto> lstImpuesto = new ArrayList<Impuesto>();
                lstImpuesto.add(impuesto);
                impuestos.setImpuesto(lstImpuesto);
                detalle.setImpuestos(impuestos);
                lstDetalle.add(detalle);
            }
            detalles.setDetalle(lstDetalle);
            factura.setDetalles(detalles);
            InfoAdicional infoAdicional = new InfoAdicional();
            CampoAdicional campoAdicional = new CampoAdicional();
            CampoAdicional campoAdicional2 = new CampoAdicional();
            CampoAdicional campoAdicional3 = new CampoAdicional();
            campoAdicional.setValue(datosFacturas.getEmailComprador());
            campoAdicional.setNombre("Correo:");
            campoAdicional2.setValue(datosFacturas.getTelefonoComprador());
            campoAdicional2.setNombre("Celular/Telefono:");
            campoAdicional3.setValue(datosFacturas.getObservacionesComprador().isEmpty() ? "Ninguna" : datosFacturas.getObservacionesComprador());
            campoAdicional3.setNombre("Observaciones:");
            ArrayList<CampoAdicional> lstCampoAdicional = new ArrayList<CampoAdicional>();
            lstCampoAdicional.add(campoAdicional);
            lstCampoAdicional.add(campoAdicional2);
            lstCampoAdicional.add(campoAdicional3);
            infoAdicional.setCampoAdicional(lstCampoAdicional);
            factura.setInfoAdicional(infoAdicional);
            factura.getInfoTributaria().setSecuencial(datosFacturas.getNumComprobante().isEmpty() ? this.getSecuencia(cliente) : datosFacturas.getNumComprobante());
            TFactura tFacturaGuardad = new TFactura();
            if (datosFacturas.getNumComprobante().isEmpty()) {
                FacturaDetalle facturaDetalle = new FacturaDetalle();
                TFactura tFact = new TFactura();
                TFormaPago tFormaPago = new TFormaPago();
                tFact.setIdAdquiriente(adquirienteResp);
                tFact.setCliente(cliente);
                tFact.setNumComprobante(factura.getInfoTributaria().getSecuencial());
                tFact.setSubtotal(factura.getInfoFactura().getTotalSinImpuestos());
                tFact.setTotal(factura.getInfoFactura().getImporteTotal());
                tFact.setDescuento(datosFacturas.getDescuentoComprador());
                tFact.setImpuestos(totalImpuestos);
                tFact.setObservacionesComprador(campoAdicional3.getValue());
                tFact.setBodega(bodega);
                tFact.setPuntoVenta(puntoEmision);
                tFormaPago.setCodigoSri(pago.getFormaPago());
                tFact.setIdFormaPago(tFormaPago);
                facturaDetalle.setFactura(tFact);
                facturaDetalle.setFormaPagoComprobante(datosFacturas.getFormaPagoComprobante());
                ArrayList<TFacturaDetalle> lstListaProductos = new ArrayList<TFacturaDetalle>();
                for (DatosFacturasDetalle detalleF : datosFacturas.getLstDetalle()) {
                    TFacturaDetalle detalleBD = new TFacturaDetalle();
                    TProducto producto = (TProducto)this.tProductoDAO.findById((Object)detalleF.getId_producto()).get();
                    TTarifaIva tarifaIva = this.tarifaIvaDAO.getTarifa4Id(detalleF.getCodigoIva());
                    detalleBD.setIdProducto(producto);
                    detalleBD.setCantidad(detalleF.getCantidad());
                    detalleBD.setTarifa(BigDecimal.valueOf(tarifaIva.getPorcentaje().intValue()));
                    detalleBD.setValorIce(detalleF.getValorIce());
                    detalleBD.setDescuento(datosFacturas.getDescuentoComprador());
                    detalleBD.setValorTotal(detalleF.getValor());
                    lstListaProductos.add(detalleBD);
                }
                facturaDetalle.setDetalle(lstListaProductos);
                if (tFact.getIdAdquiriente().getIdentificacion().equals("9999999999999") && tFact.getTotal().compareTo(new BigDecimal(49)) == 1) {
                    throw new CustomExceptionNoCleanData("No es posible facturar a consumidor final un monto mayor a $50.00");
                }
                this.log.info("Total factura: " + facturaDetalle.getFactura().getTotal());
                this.facturaService.guardarFacturaWEB(facturaDetalle);
            }
            tFacturaGuardad = this.facturaService.getFacturaByNumComprobante(factura.getInfoTributaria().getSecuencial(), cliente);
            BigDecimal idFactura = new BigDecimal(0);
            if (tFacturaGuardad != null) {
                idFactura = tFacturaGuardad.getId();
                this.log.info("id factura: " + idFactura);
                if (tFacturaGuardad.getFechaEmision() != null) {
                    factura.getInfoFactura().setFechaEmision(dateFormat.format(tFacturaGuardad.getFechaEmision()));
                    this.log.info("fecha emision factura: " + factura.getInfoFactura().getFechaEmision());
                }
            }
            try {
                respuesta = (RespSimple)this.template.postForObject(this.urlFacturar, (Object)factura, RespSimple.class, new Object[0]);
                if (respuesta == null) {
                    respuesta = new RespSimple();
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    respuesta.setMensaje("No se recibi\u00f3 respuesta del servicio de facturaci\u00f3n.");
                    respuesta.setParametroRespuesta(String.valueOf(idFactura));
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
                respuesta.setParametroRespuesta(String.valueOf(idFactura));
                if (respuesta.getCodigo().contains("ERR")) {
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                    respuesta.setMensaje(respuesta.getMensaje());
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
            }
            catch (Exception con) {
                if (respuesta != null) {
                    respuesta.setParametroRespuesta(String.valueOf(idFactura));
                }
                if (con.getMessage().contains("I/O error on POST request") && respuesta != null) {
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                    respuesta.setMensaje("El servidor del SRI est\u00e1 intermitente, su factura se enviar\u00e1 una vez el servicio est\u00e9 disponible.");
                    return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
                }
                if (respuesta != null) {
                    respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                    respuesta.setMensaje("Factura Generada pero no Autorizada");
                    respuesta.setDescripcion(con.getMessage());
                }
                this.log.severe("FACTURA GENERADA PERO NO AUTORIZADA: ".concat(con.getMessage()));
                return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
            }
            try {
                TPeticion peticion;
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                respuesta.setMensaje(ContfiablesEnum.TRANSACCION_OK.getDescripcion());
                if (tFacturaGuardad != null) {
                    tFacturaGuardad.setRespuestaSri(respuesta.getDescripcion());
                    this.facturaService.actualizarMensajeSRIFactura(tFacturaGuardad);
                }
                if ((peticion = this.peticionService.obtenerPeticionPorNumeroComprobanteYidCliente(factura.getInfoTributaria().getSecuencial(), Long.valueOf(cliente.getIdCliente().toString()))) != null) {
                    String claveAcces = peticion.getClaveAcceso();
                    String autorizacion = peticion.getNumeroAutorizacion();
                    this.facturaService.actualizarClaveAccesoSRIFactura(cliente.getIdCliente(), factura.getInfoTributaria().getSecuencial(), claveAcces, respuesta.getDescripcion());
                    if (autorizacion == null) {
                        this.log.severe("ERROR DE AUTORIZACION: ".concat(respuesta.getDescripcion()));
                        if (respuesta.getDescripcion().contains("ARCHIVO NO CUMPLE ESTRUCTURA XML")) {
                            return Transaccion.XML_MALFORMED((String)"Factura emitida en espera de revisi\u00f3n.", null);
                        }
                        return Transaccion.XML_MALFORMED((String)"Factura emitida en espera de revisi\u00f3n.", null);
                    }
                    if (claveAcces != null && autorizacion.equals(claveAcces) && tFacturaGuardad != null) {
                        tFacturaGuardad.setIsAutorizado(Boolean.valueOf(true));
                        this.facturaService.actualizarEstadoFactura(tFacturaGuardad);
                    }
                }
            }
            catch (Exception ex) {
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                respuesta.setMensaje(respuesta.getDescripcion());
                this.log.severe("ERROR EN EL PROCESO DE FACTURACION: ".concat(ex.getMessage()));
                return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
            }
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            respuesta.setError("");
            respuesta.setMensaje("Factura generada con \u00e9xito");
            respuesta.setDescripcion(tFacturaGuardad != null ? String.valueOf(tFacturaGuardad.getId()) : "");
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException ce) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.CUSTOM_EXCEPTION((String)ce.getMessage());
        }
        catch (CustomExceptionNoCleanData e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.CUSTOM_EXCEPTION_NO_CLEAN_DATA((String)e.getMessage());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL REALIZAR LA FACTURACION ", e);
            if (respuesta != null) {
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR_BUT_NOTCLEAN_FRONT.getId());
                respuesta.setError("Error");
                respuesta.setMensaje("Error en el proceso de facturaci\u00f3n, factura no guardada.");
                respuesta.setDescripcion(e.getMessage());
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
        }
    }

    @Transactional
    public String getSecuencia(TCliente Cliente) {
        String respuesta = "";
        try {
            TSecuenciaFactura secuenciaRespuesta = this.secuenciaFacturaDAO.findByCliente(Cliente);
            if (secuenciaRespuesta.getSecuencial().toString().length() < 9) {
                respuesta = secuenciaRespuesta.getSecuencial().toString();
                for (int i = respuesta.length(); i < 9; ++i) {
                    respuesta = "0".concat(respuesta);
                }
                secuenciaRespuesta.setSecuencial(Integer.valueOf(secuenciaRespuesta.getSecuencial() + 1));
                secuenciaRespuesta = (TSecuenciaFactura)this.secuenciaFacturaDAO.save((Object)secuenciaRespuesta);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error al obtener las secuencias ", e);
            throw new CustomException("Error al obtener la secuencia de la factura.");
        }
        return respuesta;
    }

    private String getTipoRegimen(TCliente cliente) {
        if (cliente.getTipoEmprendedor() == null) {
            return null;
        }
        if (cliente.getTipoEmprendedor().equals(ContfiablesEnum.CONTRIBUYENTE_GENERAL.getDescripcion())) {
            return null;
        }
        return cliente.getTipoEmprendedor();
    }

    public ResponseEntity<RespSimple> reenviarCorreo(Long idFactura, String correo, String numAutorizacion) {
        RespSimple response = new RespSimple();
        TFactura f = new TFactura();
        f = numAutorizacion != null ? this.facturaDAO.findByAuthorizacion(numAutorizacion) : (TFactura)this.facturaDAO.findById((Object)new BigDecimal(idFactura)).orElse(null);
        if (f == null) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al enviar el correo, no se encontr\u00f3 la factura solicitada.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            String html = new CrearFormatoCorreo().generarCorreoHTML(f);
            String claveAcceso = f.getAuthorizacion();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.add((Object)"claveAcceso", (Object)claveAcceso);
            parameters.add((Object)"correoAdquiriente", (Object)correo);
            parameters.add((Object)"cuerpo", (Object)(html + "\n"));
            HttpEntity requestEntity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
            try {
                String respuesta = (String)this.template.postForObject(this.urlEnviarCorreo, (Object)requestEntity, String.class, new Object[0]);
                this.log.info("respuesta correo: " + respuesta);
                f.setEnviada(Boolean.valueOf(true));
                this.facturaDAO.save((Object)f);
                response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                response.setMensaje("Correo enviado correctamente");
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                this.log.severe("Error al enviar factura por email: ".concat(e.getMessage()));
                response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                response.setMensaje("Error al enviar el correo");
                if (e.getMessage().contains("Connection refused")) {
                    response.setMensaje("El servicio de correo no est\u00e1 en l\u00ednea, intentarlo m\u00e1s tarde.");
                }
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al enviar el correo");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

