/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.FacturaDetalle;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TFacturaDetalle;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPago;
import ec.tws2.back.contfiables.models.entities.facturacion.TFormaPagoComprobantes;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.models.entities.inventario.TKardexNoInventariable;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.models.enums.TipoPagoComprobantesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFacturaDetalleDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoComprobantesDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TFormaPagoDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TTipoComprobanteDAO;
import ec.tws2.back.contfiables.repositories.integracion.TPuntoVentaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TInventarioDAO;
import ec.tws2.back.contfiables.repositories.inventario.TKardexDAO;
import ec.tws2.back.contfiables.repositories.inventario.TKardexNoInventariableDAO;
import ec.tws2.back.contfiables.repositories.inventario.TProductoDAO;
import ec.tws2.back.contfiables.services.FacturaService;
import ec.tws2.back.contfiables.services.InventarioService;
import ec.tws2.back.contfiables.services.KardexService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class FacturaServiceImpl
implements FacturaService {
    private Logger log = Logger.getLogger(FacturaServiceImpl.class.getName());
    @Autowired
    private TFacturaDAO tFacturaDAO;
    @Autowired
    private TClienteDAO tClienteDAO;
    @Autowired
    private TFacturaDetalleDAO tFacturaDetalleDAO;
    @Autowired
    private TProductoDAO tProductoDAO;
    @Autowired
    private TKardexNoInventariableDAO kardexNoInventariableDAO;
    @Autowired
    private TInventarioDAO inventarioDAO;
    @Autowired
    private TKardexDAO kardexDAO;
    @Autowired
    private TTipoComprobanteDAO tipoComprobateDAO;
    @Autowired
    private TFormaPagoDAO formaPagoDAO;
    @Autowired
    private TFormaPagoComprobantesDAO formaPagoComprobanteDAO;
    @Autowired
    private TPuntoVentaDAO puntoVentaDAO;
    @Autowired
    private InventarioService inventarioService;
    @Autowired
    private KardexService kardexService;

    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseEntity<RespSimple> guardarFacturaWEB(FacturaDetalle factura) {
        this.log.info("Ingresando a guardar factura");
        RespSimple respuesta = new RespSimple();
        try {
            ArrayList<String> listTipoPagoEnum = new ArrayList<String>();
            for (TipoPagoComprobantesEnum fpe : TipoPagoComprobantesEnum.values()) {
                listTipoPagoEnum.add(fpe.toString());
            }
            TFactura t_factura = new TFactura();
            TTipoComprobante tipoComprobante = this.tipoComprobateDAO.findByPrefijo("FAC");
            t_factura.setIsAutorizado(Boolean.valueOf(false));
            t_factura.setFechaEmision(new Date());
            t_factura.setIdAdquiriente(factura.getFactura().getIdAdquiriente());
            t_factura.setCliente(factura.getFactura().getCliente());
            t_factura.setIdFormaPago(this.formaPagoDAO.findByCodigoSri(factura.getFactura().getIdFormaPago().getCodigoSri()));
            t_factura.setAuthorizacion("");
            t_factura.setRide("");
            t_factura.setNumComprobante(factura.getFactura().getNumComprobante());
            t_factura.setObservacionesComprador(factura.getFactura().getObservacionesComprador());
            List detalleItems = factura.getDetalle();
            BigDecimal valorIce = new BigDecimal(0);
            t_factura.setImpuestos(factura.getFactura().getImpuestos());
            t_factura.setSubtotal(factura.getFactura().getSubtotal());
            t_factura.setTotal(factura.getFactura().getTotal());
            t_factura.setValorIce(valorIce);
            t_factura.setDescuento(factura.getFactura().getDescuento());
            t_factura.setIntentosAutorizacion(0);
            t_factura.setBodega(factura.getFactura().getBodega());
            t_factura.setPuntoVenta(factura.getFactura().getPuntoVenta());
            t_factura.setPuntoVenta(this.puntoVentaDAO.buscarByIdClienteEstablecimieto(t_factura.getCliente().getIdCliente()));
            t_factura.setEnviada(Boolean.valueOf(false));
            TFactura facturaF = (TFactura)this.tFacturaDAO.save((Object)t_factura);
            if (factura.getFormaPagoComprobante() == null) {
                this.log.info("No se ha ingresado forma de pago, se procede a ingresar efectivo");
                TFormaPago formaPago = this.formaPagoDAO.findByCodigoSri("01");
                if (formaPago == null) {
                    throw new CustomExceptionNoCleanData("Error al obtener la forma de pago");
                }
                TFormaPagoComprobantes formaPagoCom = new TFormaPagoComprobantes();
                formaPagoCom.setBanco("Efectivo");
                formaPagoCom.setFechaTransaccion(new Date());
                formaPagoCom.setFechaVencimiento(new Date());
                formaPagoCom.setFormaPago(formaPago);
                formaPagoCom.setCaja("Efectivo");
                formaPagoCom.setNumDias(1);
                formaPagoCom.setNumDocumento(t_factura.getNumComprobante());
                formaPagoCom.setTipoPago("Efectivo");
                formaPagoCom.setValor(t_factura.getTotal());
                formaPagoCom.setTipoComprobante(tipoComprobante);
                formaPagoCom.setFactura(facturaF);
                this.formaPagoComprobanteDAO.save((Object)formaPagoCom);
            } else {
                this.log.info("Se ha ingresado forma de pago, se procede a ingresar las formas de pago");
                for (Object fp : factura.getFormaPagoComprobante()) {
                    fp.setId(null);
                    fp.setFactura(facturaF);
                    fp.setTipoComprobante(tipoComprobante);
                    fp.setNumDocumento(factura.getFactura().getPuntoVenta().getEstablecimiento().getEstablecimiento() + "-" + factura.getFactura().getPuntoVenta().getPuntoEmision() + "-" + factura.getFactura().getNumComprobante());
                    if (!listTipoPagoEnum.contains(fp.getTipoPago().toUpperCase())) {
                        throw new CustomExceptionNoCleanData("El tipo de pago no coincide con el registro interno");
                    }
                    try {
                        if (fp.getFechaVencimiento() != null) {
                            long diferenciaEnMilisegundos = fp.getFechaVencimiento().getTime() - fp.getFechaTransaccion().getTime();
                            long diferenciaEnDias = diferenciaEnMilisegundos / 86400000L;
                            fp.setNumDias(Integer.valueOf(String.valueOf(diferenciaEnDias)).intValue());
                        }
                    }
                    catch (Exception e) {
                        this.log.warning("Error al calcular los dias de la fecha en el modulo facturacion, no relevante");
                    }
                    fp.setTipoPago(fp.getTipoPago().toUpperCase());
                    this.formaPagoComprobanteDAO.save(fp);
                }
            }
            BigDecimal valorCostosTotalFactura = BigDecimal.ZERO;
            for (TFacturaDetalle det : detalleItems) {
                TProducto prod = this.tProductoDAO.findById((Object)det.getIdProducto().getId()).orElse(null);
                if (prod.getInventariable() == null) {
                    prod.setInventariable(Boolean.valueOf(false));
                }
                if (!prod.getInventariable().booleanValue()) continue;
                BigDecimal costoLinea = this.inventarioService.validarStock(facturaF.getBodega(), prod, det.getCantidad(), det.getValorTotal());
                valorCostosTotalFactura = valorCostosTotalFactura.add(costoLinea);
            }
            if (facturaF.getSubtotal().compareTo(valorCostosTotalFactura) < 0) {
                throw new CustomExceptionNoCleanData("El valor de venta de la factura es menor al costo de los productos inventariables, es posible que el descuento sea muy alto");
            }
            BigDecimal impuestos = BigDecimal.ZERO;
            BigDecimal subtotal = BigDecimal.ZERO;
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal descuento = BigDecimal.ZERO;
            for (int i = 0; i < detalleItems.size(); ++i) {
                TFacturaDetalle t_factura_detalle = new TFacturaDetalle();
                BigDecimal subtDet = ((TFacturaDetalle)detalleItems.get(i)).getCantidad().multiply(((TFacturaDetalle)detalleItems.get(i)).getValorTotal());
                BigDecimal descDet = subtDet.multiply(((TFacturaDetalle)detalleItems.get(i)).getDescuento().divide(new BigDecimal(100))).setScale(4, RoundingMode.HALF_UP);
                subtDet = subtDet.subtract(descDet).setScale(4, RoundingMode.HALF_UP);
                BigDecimal impDet = subtDet.multiply(((TFacturaDetalle)detalleItems.get(i)).getTarifa().divide(new BigDecimal(100))).setScale(4, RoundingMode.HALF_UP);
                impuestos = impuestos.add(impDet);
                subtotal = subtotal.add(subtDet);
                total = total.add(subtDet.add(impDet));
                descuento = descuento.add(descDet);
                t_factura_detalle.setCantidad(((TFacturaDetalle)detalleItems.get(i)).getCantidad());
                t_factura_detalle.setTarifa(((TFacturaDetalle)detalleItems.get(i)).getTarifa());
                t_factura_detalle.setDescuento(((TFacturaDetalle)detalleItems.get(i)).getDescuento());
                t_factura_detalle.setValorTotal(((TFacturaDetalle)detalleItems.get(i)).getValorTotal());
                t_factura_detalle.setValorIce(((TFacturaDetalle)detalleItems.get(i)).getValorIce());
                t_factura_detalle.setIdFactura(facturaF);
                t_factura_detalle.setIdProducto((TProducto)this.tProductoDAO.findById((Object)((TFacturaDetalle)factura.getDetalle().get(i)).getIdProducto().getId()).get());
                this.tFacturaDetalleDAO.save((Object)t_factura_detalle);
                TProducto productoDB = t_factura_detalle.getIdProducto();
                BigDecimal cantidadSaliente = t_factura_detalle.getCantidad().setScale(2, RoundingMode.HALF_UP);
                if (!productoDB.getInventariable().booleanValue()) {
                    TKardexNoInventariable kardexNoInventariable = new TKardexNoInventariable();
                    kardexNoInventariable.setCantidad(cantidadSaliente);
                    kardexNoInventariable.setFechaMovimiento(new Date());
                    kardexNoInventariable.setPrecioVenta(t_factura_detalle.getValorTotal().setScale(4, RoundingMode.HALF_UP));
                    kardexNoInventariable.setCliente(productoDB.getCliente());
                    kardexNoInventariable.setAdquiriente(t_factura.getIdAdquiriente().getIdentificacion() + " - " + t_factura.getIdAdquiriente().getRazonSocial());
                    kardexNoInventariable.setNumComprobante(t_factura.getNumComprobante());
                    kardexNoInventariable.setProducto(productoDB);
                    this.kardexNoInventariableDAO.save((Object)kardexNoInventariable);
                }
                ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
                LocalDateTime fechaHoraEcuador = LocalDateTime.now(zonaEcuador);
                if (!productoDB.getInventariable().booleanValue()) continue;
                this.inventarioService.egresoPorVenta(facturaF.getBodega(), productoDB, cantidadSaliente);
                this.kardexService.registrarEgresoVenta(t_factura_detalle, facturaF, "FAC");
            }
            respuesta.setData((Object)facturaF);
            respuesta.setError(ContfiablesEnum.TRANSACCION_OK.getId());
            respuesta.setMensaje("Factura almacenada");
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomExceptionNoCleanData e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new CustomExceptionNoCleanData(e.getMessage());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL GUARDAR FACTURA ", e);
            respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setMensaje("Error al guardar la factura, factura no almacenada en la base de datos ni enviada al SRI.");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new CustomException(e.getMessage());
        }
    }

    public ResponseEntity<RespSimple> actualizarDatosFacturaAutorizada(TFactura factura) {
        TFactura t_factura = new TFactura();
        RespSimple response = new RespSimple();
        try {
            TCliente t_cliente = new TCliente();
            t_cliente = this.tClienteDAO.getCliente4identificacion(factura.getCliente().getIdentification());
            t_factura = this.tFacturaDAO.obtenerFacturaPorNumComprobante(factura.getNumComprobante(), t_cliente.getIdCliente());
            t_factura.setAuthorizacion(factura.getAuthorizacion());
            t_factura.setIsAutorizado(factura.getIsAutorizado());
            this.tFacturaDAO.save((Object)t_factura);
            response.setCodigo("0");
            response.setDescripcion("Guardar autorizacion de factura");
            response.setMensaje("Factura autorizada.");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            response.setCodigo("1");
            response.setDescripcion("Guardar autorizacion de factura");
            response.setMensaje("Factura Generada pero no Autorizada.");
            response.setError("Error al actualizar el numero de autorizacion");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public TFactura getFactura(BigDecimal id) {
        return (TFactura)this.tFacturaDAO.findById((Object)id).get();
    }

    public TFacturaDetalle getDetalle(BigDecimal id) {
        return (TFacturaDetalle)this.tFacturaDetalleDAO.findById((Object)id).get();
    }

    public List<TFactura> obtenerUltimas3Facturas(BigDecimal idUsuario) {
        return this.tFacturaDAO.obtenerUltimas3Facturas(idUsuario);
    }

    public List<TFactura> obtenerFacturasAutorizadasPorFecha(Long idCliente, String fechaInicio, String fechaFinal) {
        return this.tFacturaDAO.obtenerFacturasAutorizadasPorFecha(idCliente, fechaInicio, fechaFinal);
    }

    public List<TFactura> obtenerFacturasNoAutorizadasPorFechaIdentificacion(int idCliente, String fechaInicio, String fechaFinal) {
        return this.tFacturaDAO.obtenerFacturasNoAutorizadasPorFechaIdentificacion(idCliente, fechaInicio, fechaFinal, false);
    }

    public List<TFactura> obtenerFacturas(Long idUsuario) {
        PageRequest pageable = PageRequest.of((int)0, (int)10);
        return this.tFacturaDAO.obtenerFacturas(idUsuario, (Pageable)pageable);
    }

    public List<TFacturaDetalle> getDetalleFactura(BigDecimal idFactura) {
        return this.tFacturaDetalleDAO.buscarDetalleByIdFactura(idFactura);
    }

    @Transactional
    public RespSimple actualizarEstadoFactura(TFactura factura) {
        RespSimple response = new RespSimple();
        try {
            TFactura fact = new TFactura();
            fact = (TFactura)this.tFacturaDAO.findById((Object)factura.getId()).get();
            fact.setIsAutorizado(factura.getIsAutorizado());
            this.tFacturaDAO.save((Object)fact);
            response.setCodigo("0");
            response.setDescripcion("Estado actualizado");
            response.setError("");
            response.setMensaje("Estado actualizado");
            return response;
        }
        catch (Exception e) {
            response.setCodigo("1");
            response.setError("Error");
            response.setDescripcion("Estado no actualizado");
            response.setMensaje("Error al actualizar el estado");
            return response;
        }
    }

    public TFactura getFacturaByNumComprobante(String numComrpbante, TCliente cliente) {
        return this.tFacturaDAO.findByNumComprobanteAndCliente(numComrpbante, cliente);
    }

    public RespSimple actualizarMensajeSRIFactura(TFactura factura) {
        TFactura fact = (TFactura)this.tFacturaDAO.findById((Object)factura.getId()).get();
        if (fact != null) {
            fact.setRespuestaSri(factura.getRespuestaSri());
            this.tFacturaDAO.save((Object)fact);
        }
        return null;
    }

    public List<TFactura> obtenerFacturasPorFechaEidentificacion(Long idCliente, String fechaInicio, String fechaFinal, String identificacion) {
        return this.tFacturaDAO.obtenerFacturasPorFechaEIdentificacion(idCliente, fechaInicio, fechaFinal, identificacion);
    }

    public List<TFactura> obtenerPorNumeroComprobante(String numComprobante, Long idCliente) {
        TCliente cliente = new TCliente();
        cliente.setIdCliente(idCliente);
        return this.tFacturaDAO.findByClienteAndNumComprobante(cliente, numComprobante);
    }

    public RespSimple actualizarClaveAccesoSRIFactura(Long idCliente, String numComprobante, String claveAcceso, String mensaje) {
        TCliente cliente = new TCliente();
        cliente.setIdCliente(idCliente);
        TFactura fact = this.tFacturaDAO.findByNumComprobanteAndCliente(numComprobante, cliente);
        if (fact != null) {
            fact.setAuthorizacion(claveAcceso);
            fact.setRespuestaSri(mensaje);
            this.tFacturaDAO.save((Object)fact);
        }
        return null;
    }

    public List<TFactura> obtenerTodasFacturasNoAutorizadas() {
        return this.tFacturaDAO.findByIsAutorizado(Boolean.valueOf(false));
    }

    public List<TFactura> obtenerFacturasNoEnviadas() {
        return this.tFacturaDAO.findByIsAutorizadoAndEnviada(Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public ResponseEntity<RespSimple> getFacturasCount(Long idCliente) {
        RespSimple response = new RespSimple();
        LocalDateTime fecha = LocalDateTime.now();
        try {
            Long numFacturas = this.tFacturaDAO.countByIdClienteAndAnio(idCliente, fecha.getYear());
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("num facturas obtenida");
            response.setData((Object)numFacturas);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de facturas");
            response.setDescripcion(e.getMessage());
            response.setData((Object)0);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getFacturasByClienteAndAnioOrMonth(Long idCliente, int anio, int mes) {
        RespSimple response = new RespSimple();
        try {
            if (mes == 0) {
                response.setData((Object)this.tFacturaDAO.buscarFacturasByClienteAndAnio(idCliente, anio));
            } else {
                response.setData((Object)this.tFacturaDAO.buscarFacturasByClienteAndAnioAndMes(idCliente, anio, mes));
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Lista obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setMensaje("Error al obtener la lista de facturas");
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setData(new ArrayList());
            response.setDescripcion(e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getFacturasTotalByClienteAndYear(Long idCliente) {
        RespSimple response = new RespSimple();
        LocalDateTime fecha = LocalDateTime.now();
        try {
            BigDecimal sumFacturas = this.tFacturaDAO.sumByIdClienteAndAnio(idCliente, fecha.getYear());
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("suma de facturas obtenida");
            response.setData((Object)sumFacturas);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lista de facturas");
            response.setDescripcion(e.getMessage());
            response.setData((Object)BigDecimal.ZERO);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getUltimas5facturas(Long idCliente) {
        try {
            List listaUltimasFacturas = this.tFacturaDAO.obtenerUltimas5Facturas(idCliente);
            return Transaccion.OK((String)"ultimas 5 facturas obtenidas", (Object)listaUltimasFacturas);
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al obtener las \u00faltimas 5 facturas");
        }
    }

    public List<TFactura> WebObtenerFacturasPorFechaEidentificacion(Long idCliente, String fechaInicio, String fechaFinal, String identificacion) {
        return null;
    }

    public List<TFactura> webObtenerFacturasAutorizadasPorFecha(Long idCliente, String fechaInicio, String fechaFinal) {
        return null;
    }

    public List<TFactura> obtenerPorRazonSocial(String razonSocial, Long idCliente) {
        return this.tFacturaDAO.findByRazonSocialAndCliente(razonSocial, idCliente);
    }

    public ResponseEntity<RespSimple> anularFactura(BigDecimal idFactura) {
        Optional factura = this.tFacturaDAO.findById((Object)idFactura);
        if (!factura.isPresent()) {
            return Transaccion.NOTFOUNT((String)"Factura no encontrada");
        }
        List facturaDetalle = this.tFacturaDetalleDAO.buscarDetalleByIdFactura(idFactura);
        for (TFacturaDetalle itemFacturaDetalle : facturaDetalle) {
            if (!itemFacturaDetalle.getIdProducto().getInventariable().booleanValue()) continue;
        }
        return Transaccion.OK((String)"Factura Anulada", (Object)facturaDetalle);
    }
}

