/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.facturacion;

import ec.tws2.back.contfiables.models.domain.InfoTributaria;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TSecuenciaFactura;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.facturacion.TSecuenciaFacturaDAO;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FacturaDataService {
    Logger log = Logger.getLogger(FacturaDataService.class.getName());
    @Value(value="${property.ambiente.factura}")
    private String ambiente;
    @Autowired
    private TSecuenciaFacturaDAO secuenciaFacturaDAO;

    public InfoTributaria getInfoTributaria(TCliente cliente, TSecuenciaFactura secuenciaFactura, String numComprobante) {
        InfoTributaria infoTributaria = new InfoTributaria();
        infoTributaria.setAmbiente(this.ambiente);
        infoTributaria.setTipoEmision(ContfiablesEnum.TIPO_EMISION.getId());
        infoTributaria.setRazonSocial(cliente.getNombres().concat(" ").concat(cliente.getApellidos()));
        infoTributaria.setRuc(cliente.getIdentification());
        if (secuenciaFactura != null) {
            infoTributaria.setCodDoc(secuenciaFactura.getCodigoDocumento());
            infoTributaria.setEstab(secuenciaFactura.getEstablecimiento());
            infoTributaria.setPtoEmi(secuenciaFactura.getPuntoEmision());
        }
        infoTributaria.setSecuencial(numComprobante.isEmpty() ? this.getSecuencia(cliente) : numComprobante);
        if (cliente != null) {
            infoTributaria.setDirMatriz(cliente.getCiudad());
            infoTributaria.setContribuyenteRimpe(cliente.getTipoEmprendedor());
        }
        return infoTributaria;
    }

    @Transactional
    public String getSecuencia(TCliente Cliente) {
        String respuesta = "";
        try {
            TSecuenciaFactura secuenciaRespuesta = this.secuenciaFacturaDAO.findByCliente(Cliente);
            if (secuenciaRespuesta != null && secuenciaRespuesta.getSecuencial() != null && secuenciaRespuesta.getSecuencial().toString().length() < 9) {
                respuesta = secuenciaRespuesta.getSecuencial().toString();
                for (int i = respuesta.length(); i < 9; ++i) {
                    respuesta = "0".concat(respuesta);
                }
                secuenciaRespuesta.setSecuencial(Integer.valueOf(secuenciaRespuesta.getSecuencial() + 1));
                secuenciaRespuesta = (TSecuenciaFactura)this.secuenciaFacturaDAO.save((Object)secuenciaRespuesta);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error al obtener las secuencias ", e);
        }
        return respuesta;
    }
}

