/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.contabilidad;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.integracion.TCuentaContable;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.integracion.TCuentaContableDAO;
import ec.tws2.back.contfiables.services.CuentaContableService;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CuentaContableServiceImpl
implements CuentaContableService {
    private Logger log = Logger.getLogger(CuentaContableServiceImpl.class.getName());
    @Autowired
    TCuentaContableDAO cuentaContableDAO;

    public ResponseEntity<RespSimple> getContableAccountsByClient(Long idCliente, Boolean activo) {
        RespSimple response = new RespSimple();
        try {
            if (activo.booleanValue()) {
                response.setData((Object)this.cuentaContableDAO.findByClienteAndEstadoOrderByCodigo(new TCliente(idCliente), Boolean.valueOf(true)));
            } else {
                response.setData((Object)this.cuentaContableDAO.findByClienteOrderByCodigo(new TCliente(idCliente)));
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("lista de cuentas contables obtenida");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Error al obtener la lisa de cuentas contables");
            response.setData(new ArrayList());
            this.log.log(Level.SEVERE, "Error al obtener la lisa de cuentas contables", e);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> saveContableAccount(TCuentaContable cuentaContable) {
        RespSimple response = new RespSimple();
        try {
            if (cuentaContable.getMovimiento() == null) {
                throw new CustomException("No se a podido identificar si la cuenta contable es de movimiento");
            }
            if (cuentaContable.getCodigo() == null || cuentaContable.getCodigo().isEmpty()) {
                throw new CustomException("El c\u00f3digo de la cuenta contable es requerido.");
            }
            if (cuentaContable.getDescripcion() == null || cuentaContable.getDescripcion().isEmpty()) {
                throw new CustomException("La descripci\u00f3n de la cuenta contable es requerido.");
            }
            if (cuentaContable.getGrupoContable() == null || cuentaContable.getGrupoContable().getIdGrupoContable() == null || cuentaContable.getGrupoContable().getIdGrupoContable() == 0L) {
                throw new CustomException("No se a podido identificar el grupo contable de la cuenta.");
            }
            if (cuentaContable.getModuloContable() == null || cuentaContable.getModuloContable().getIdModuloContable() == null || cuentaContable.getModuloContable().getIdModuloContable() == 0L) {
                throw new CustomException("No se a podido identificar el m\u00f3dulo contable de la cuenta.");
            }
            if (this.cuentaContableDAO.existsByCodigoAndCliente(cuentaContable.getCodigo(), cuentaContable.getCliente()).booleanValue()) {
                throw new CustomException("ya existe una cuenta contable con ese c\u00f3digo");
            }
            response.setData(this.cuentaContableDAO.save((Object)cuentaContable));
            response.setMensaje("Cuenta contable registrada correctamente.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (CustomException e) {
            response.setMensaje(e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setMensaje("Error al registrar la cuenta contable.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> updateContableAccount(TCuentaContable cuentaContable) {
        RespSimple response = new RespSimple();
        try {
            TCuentaContable cuentaDB = this.cuentaContableDAO.findById((Object)cuentaContable.getIdCuentaContable()).orElse(null);
            if (cuentaDB == null) {
                throw new CustomException("No existe una cuenta contable con esa identificaci\u00f3n para actualizar.");
            }
            cuentaDB.setDescripcion(cuentaContable.getDescripcion());
            response.setData(this.cuentaContableDAO.save((Object)cuentaDB));
            response.setMensaje("Cuenta contable actualizada.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            response.setMensaje("Error al actualizar la cuenta contable.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> deleteContableAccount(Long idCuenta) {
        RespSimple response = new RespSimple();
        try {
            TCuentaContable cuentaContable = this.cuentaContableDAO.findById((Object)idCuenta).orElse(null);
            if (cuentaContable == null) {
                throw new CustomException("No existe una cuenta contable con esa identificaci\u00f3n.");
            }
            if (this.cuentaContableDAO.existsByClienteAndCodigoStartsWithAndIdCuentaContableNot(cuentaContable.getCliente(), cuentaContable.getCodigo(), idCuenta).booleanValue()) {
                throw new CustomException("No es posible eliminar esta cuenta contable, est\u00e1 enlaz\u00e1da con otras cuentas.");
            }
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("Cuenta contable eliminada correctamente.");
            this.cuentaContableDAO.deleteById((Object)idCuenta);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (CustomException e) {
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje(e.getMessage());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error: ", e);
            response.setMensaje("Ya no es posible eliminar esta cuenta contable.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getContableAccountByClientAndQuery(Long idCliente, String query, Boolean movimiento) {
        RespSimple response = new RespSimple();
        try {
            if (movimiento.booleanValue()) {
                response.setData((Object)this.cuentaContableDAO.filtrarCuentaContableQueryObligaciones(idCliente, query, movimiento));
            } else {
                response.setData((Object)this.cuentaContableDAO.filtrarCuentaContableQuery(idCliente, query));
            }
            response.setMensaje("Lista de cuentas contables obtenida.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            response.setMensaje("Error al filtar las cuentas contables.");
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

