/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.cliente;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.util.utils;
import ec.tws2.back.contfiables.models.domain.PagoSuscripcionModel;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.AlertaSuscripcionContfiablesDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.cliente.THistoriaPago;
import ec.tws2.back.contfiables.models.entities.cliente.TSuscripcionContfiables;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.cliente.THistoriaPagoDAO;
import ec.tws2.back.contfiables.repositories.cliente.TSucripcionContfiablesDAO;
import ec.tws2.back.contfiables.services.SuscripcionContfiablesService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SuscripcionContfiablesServiceImpl
implements SuscripcionContfiablesService {
    private Logger log = Logger.getLogger(SuscripcionContfiablesServiceImpl.class.getName());
    @Autowired
    private TSucripcionContfiablesDAO suscripcionDAO;
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private THistoriaPagoDAO historiaDAO;

    @Transactional
    public ResponseEntity<RespSimple> validarSuscripcionCliente(String username) {
        LocalDateTime fechahoy = utils.getLocalDateNow();
        try {
            TSuscripcionContfiables suscripcion = this.suscripcionDAO.findByClienteUsername(username);
            if (suscripcion != null) {
                long diasRestantes = ChronoUnit.DAYS.between(fechahoy, suscripcion.getFechaFin());
                suscripcion.setDiasRestantes(Long.valueOf(diasRestantes));
                long factRestantes = suscripcion.getCupo() - suscripcion.getFacturasEmitidas();
                if (diasRestantes <= 0L || factRestantes <= 0L) {
                    long diasPositivos = Math.abs(diasRestantes);
                    long factPositivas = Math.abs(factRestantes);
                    if (diasPositivos <= 5L) {
                        suscripcion.setActivo(Boolean.valueOf(true));
                        this.suscripcionDAO.updateActivoAndTrialAndDiasRestantes(Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(diasRestantes), suscripcion.getCliente().getIdCliente());
                        return Transaccion.OK((String)"OK", (Object)suscripcion);
                    }
                    if (factPositivas <= 5L) {
                        return Transaccion.OK((String)"OK", (Object)suscripcion);
                    }
                }
                if (suscripcion.getCupo() <= suscripcion.getFacturasEmitidas()) {
                    suscripcion.setActivo(Boolean.valueOf(false));
                    suscripcion.setTrial(Boolean.valueOf(false));
                    this.suscripcionDAO.updateActivoAndTrialAndDiasRestantes(Boolean.valueOf(false), Boolean.valueOf(false), Long.valueOf(diasRestantes), suscripcion.getCliente().getIdCliente());
                    return Transaccion.ENDED_SUBSCRIPTION((String)"Has llegado al l\u00edmite de tu cupo. REF: cupo de ".concat(suscripcion.getCupo().toString()).concat(" facturas"), null);
                }
                if (fechahoy.isAfter(suscripcion.getFechaFin())) {
                    suscripcion.setActivo(Boolean.valueOf(false));
                    suscripcion.setTrial(Boolean.valueOf(false));
                    this.suscripcionDAO.updateActivoAndTrialAndDiasRestantes(Boolean.valueOf(false), Boolean.valueOf(false), Long.valueOf(diasRestantes), suscripcion.getCliente().getIdCliente());
                    return Transaccion.ENDED_SUBSCRIPTION((String)"Has llegado a la fecha l\u00edmite de la suscripci\u00f3n. REF: fecha f\u00edn de suscripci\u00f3n ".concat(suscripcion.getFechaFin().toString()), null);
                }
                suscripcion.setActivo(Boolean.valueOf(true));
                this.suscripcionDAO.updateActivoAndTrialAndDiasRestantes(Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(diasRestantes), suscripcion.getCliente().getIdCliente());
                return Transaccion.OK((String)"OK", (Object)suscripcion);
            }
            return Transaccion.CUSTOM_EXCEPTION((String)"Usuario no identificado");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL OBTENER LA SUSCRIPCION: ", e);
            return Transaccion.ERROR((String)"ERROR AL PROCESAR LA SOLICITUD");
        }
    }

    public ResponseEntity<RespSimple> getAlertaSuscripcionContfiables(Long idCliente) {
        try {
            LocalDateTime fechaActual = utils.getLocalDateNow();
            AlertaSuscripcionContfiablesDTO alertaSuscripcion = this.suscripcionDAO.getSuscripcionDTO(idCliente);
            long days = ChronoUnit.DAYS.between(fechaActual, alertaSuscripcion.getFechaFin());
            alertaSuscripcion.setDiasRestantes(Long.valueOf(days));
            long factRestantes = alertaSuscripcion.getCupo() - alertaSuscripcion.getFacturasEmitidas();
            if (days <= -5L || factRestantes <= -5L) {
                return Transaccion.ENDED_SUBSCRIPTION((String)"Tu suscripci\u00f3n ha terminado, no puedes acceder a tu cuenta", (Object)alertaSuscripcion);
            }
            if (factRestantes <= 30L) {
                return Transaccion.OK((String)("Tu cupo de " + alertaSuscripcion.getCupo() + " facturas est\u00e1 por terminar, te quedan " + factRestantes + " facturas hasta el : " + alertaSuscripcion.getFechaFin().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM))), (Object)alertaSuscripcion);
            }
            if (days <= 10L) {
                return Transaccion.OK((String)"Tu suscripci\u00f3n termina el ".concat(alertaSuscripcion.getFechaFin().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)) + ", te quedan " + days + " d\u00edas."), (Object)alertaSuscripcion);
            }
            return Transaccion.OK((String)"", (Object)alertaSuscripcion);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL VALIDAR LA ALERTA DE LA SUSCRIPCION DEL CLIENTE", e);
            return Transaccion.ERROR((String)"ERROR AL VALIDAR LA ALERTA DE LA SUSCRIPCION DEL CLIENTE");
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> renovarSuscripcion(PagoSuscripcionModel pagoModel) {
        try {
            boolean existe = this.suscripcionDAO.existsByCliente(new TCliente(pagoModel.getIdCliente()));
            if (!existe) {
                return Transaccion.NOTFOUNT((String)"No existe el cliente solicitado");
            }
            LocalDateTime fechaFin = this.suscripcionDAO.getFechaFinSuscripcion(pagoModel.getIdCliente());
            LocalDateTime fechaActual = utils.getLocalDateNow();
            Long facturasEmitidas = this.suscripcionDAO.getFacturasEmitidas(pagoModel.getIdCliente());
            long pagosCliente = this.historiaDAO.countByCliente(new TCliente(pagoModel.getIdCliente()));
            if (pagosCliente == 0L || fechaFin.isBefore(pagoModel.getFechaPago())) {
                fechaFin = LocalDateTime.now();
            }
            LocalDateTime finSuscripcion = fechaFin.plusMonths(1L);
            long days = ChronoUnit.DAYS.between(fechaActual, finSuscripcion);
            THistoriaPago pago = new THistoriaPago(new TCliente(pagoModel.getIdCliente()), facturasEmitidas, fechaFin, finSuscripcion, pagoModel.getValorPago());
            this.historiaDAO.save((Object)pago);
            int response = this.suscripcionDAO.updateSuscripcionCliente(Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(days), Integer.valueOf(999999), Integer.valueOf(0), fechaFin, finSuscripcion, pagoModel.getIdCliente());
            return response == 1 ? Transaccion.CREATED((String)("Suscripci\u00f3n renovada correctamente, nueva fecha: " + finSuscripcion)) : Transaccion.CREATED((String)"Suscripci\u00f3n no actualizada");
        }
        catch (CustomException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.ERROR((String)e.getMessage());
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Transaccion.ERROR((String)"Error al renovar la suscripci\u00f3n");
        }
    }

    @Transactional
    public ResponseEntity<RespSimple> actualizarSecuenciaSuscripcion(String username) {
        try {
            Integer secuencia = this.suscripcionDAO.getSecuenciaFactura(username);
            Long idCliente = this.clienteDAO.getIdCliente(username);
            if (secuencia == null) {
                return Transaccion.NOTFOUNT((String)"No existe la secuencia con el cliente seleccionado");
            }
            Integer n = secuencia;
            secuencia = secuencia + 1;
            this.suscripcionDAO.updateSecuencia(secuencia, idCliente);
            return Transaccion.CREATED((String)"Actualizada correctamente");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR SECUENCIA SUSCRIPCION ", e);
            return Transaccion.ERROR((String)"Error al actualizar la secuencia en la suscripci\u00f3n");
        }
    }

    public ResponseEntity<RespSimple> getAlertaSuscripcionContfiablesMovil(String username) {
        try {
            Long idCliente = this.clienteDAO.getIdCliente(username);
            if (idCliente == null) {
                return Transaccion.NOTFOUNT((String)"ERROR AL IDENTIFICAR EL USUARIO");
            }
            return this.getAlertaSuscripcionContfiables(idCliente);
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"ERROR AL VALIDAR LA INFORMACION");
        }
    }

    public ResponseEntity<RespSimple> getInformeSuscripcion() {
        return Transaccion.OK((String)"Lista de suscripciones obtenida", (Object)this.suscripcionDAO.getInformeSuscripcionView());
    }

    public ResponseEntity<RespSimple> getContadosSus() {
        return Transaccion.OK((String)"total de suscripciones", (Object)this.suscripcionDAO.getContadosViews());
    }
}

