/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.cliente;

import ec.tws2.back.contfiables.controllers.KeycloakController;
import ec.tws2.back.contfiables.core.exceptions.CustomException;
import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.core.security.Seguridad;
import ec.tws2.back.contfiables.core.validations.IdentificationValidator;
import ec.tws2.back.contfiables.models.domain.FileSignature;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.CobroContfiableDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.cliente.TSuscripcionContfiables;
import ec.tws2.back.contfiables.models.entities.facturacion.TSecuenciaFactura;
import ec.tws2.back.contfiables.models.entities.integracion.TCobroContfiable;
import ec.tws2.back.contfiables.models.entities.integracion.TEstablecimiento;
import ec.tws2.back.contfiables.models.entities.integracion.TFelectronic;
import ec.tws2.back.contfiables.models.entities.integracion.TPuntoVenta;
import ec.tws2.back.contfiables.models.entities.integracion.TTipoEmprendedor;
import ec.tws2.back.contfiables.models.entities.integracion.TVersionContfiables;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TMarca;
import ec.tws2.back.contfiables.models.entities.inventario.TSecuenciaComponente;
import ec.tws2.back.contfiables.models.entities.inventario.TSecuenciaProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TUnidadMedida;
import ec.tws2.back.contfiables.models.entities.proveedor.TCategoriaProveedor;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.cliente.TSucripcionContfiablesDAO;
import ec.tws2.back.contfiables.repositories.cliente.TipoEmprendedorDAO;
import ec.tws2.back.contfiables.repositories.facturacion.TSecuenciaFacturaDAO;
import ec.tws2.back.contfiables.repositories.integracion.TCobroContfiableDAO;
import ec.tws2.back.contfiables.repositories.integracion.TEstablecimientoDAO;
import ec.tws2.back.contfiables.repositories.integracion.TVersionContfiablesDAO;
import ec.tws2.back.contfiables.repositories.integracion.TfelectronicDAO;
import ec.tws2.back.contfiables.repositories.inventario.TBodegaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TMarcaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TSecuenciaComponenteDAO;
import ec.tws2.back.contfiables.repositories.inventario.TSecuenciaProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TTipoProductoDAO;
import ec.tws2.back.contfiables.repositories.inventario.TUnidadMedidaDAO;
import ec.tws2.back.contfiables.repositories.proveedor.TCategoriaProveedorDAO;
import ec.tws2.back.contfiables.services.ClienteService;
import ec.tws2.back.contfiables.services.FirmaElectronicaService;
import ec.tws2.back.contfiables.services.PuntoVentaService;
import jakarta.xml.bind.DatatypeConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ClienteServiceImpl
implements ClienteService {
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TipoEmprendedorDAO tipoEmprendedorDAO;
    @Autowired
    private FirmaElectronicaService firmaElectronicaService;
    @Autowired
    private TfelectronicDAO tfelectronicDAO;
    @Autowired
    private KeycloakController keycloakController;
    @Autowired
    private TSecuenciaFacturaDAO tSecuenciaFacturaDAO;
    @Autowired
    private TSecuenciaProductoDAO tSecuenciaProductoDAO;
    @Autowired
    private TSecuenciaComponenteDAO tSecuenciaComponenteDAO;
    @Autowired
    private TSucripcionContfiablesDAO suscripcionDAO;
    @Autowired
    private TEstablecimientoDAO establecimientoDAO;
    @Autowired
    private PuntoVentaService puntoVentaService;
    @Autowired
    private TBodegaDAO bodegaDAO;
    @Autowired
    private TVersionContfiablesDAO versionContfiablesDAO;
    @Autowired
    private TCobroContfiableDAO cobroContfiableDAO;
    @Autowired
    private TUnidadMedidaDAO unidadMedidaDAO;
    @Autowired
    private TMarcaDAO marcaDAO;
    @Autowired
    private TTipoProductoDAO tipoProductoDAO;
    @Autowired
    private Seguridad seguridad;
    @Autowired
    private TCategoriaProveedorDAO categoriaProveedorDAO;
    @Value(value="${path.pc}")
    private String path;
    @Autowired
    private IdentificationValidator identificationValidator;
    private Logger log = Logger.getLogger(ClienteServiceImpl.class.getName());

    public RespSimple exiteUsuario(TCliente usuario) {
        RespSimple respuesta = new RespSimple();
        try {
            TCliente c = this.clienteDAO.getCliente(usuario.getUser());
            if (c != null) {
                respuesta.setError(ContfiablesEnum.TRANSACCION_OK.getId());
            } else {
                respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            }
            return respuesta;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL EXISTE USUARIO ", e);
            respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return respuesta;
        }
    }

    public String getIdentificacionCliente(String usuario) {
        return this.clienteDAO.getIdentificacionCliente(usuario);
    }

    public Long getIdCliente(String usuario) {
        return this.clienteDAO.getIdCliente(usuario);
    }

    public TCliente getCliente(String usuario) {
        return this.clienteDAO.getCliente(usuario);
    }

    @Transactional
    public RespSimple almacenarCliente(FileSignature fileSignature) {
        if (fileSignature.getKeycloack() == null) {
            fileSignature.setKeycloack(Boolean.valueOf(false));
        }
        if (fileSignature.getCliente().getUser() == null) {
            throw new CustomException("Nombre de usuario no identificado");
        }
        fileSignature.getCliente().setUser(fileSignature.getCliente().getUser().toLowerCase());
        RespSimple respuesta = new RespSimple();
        try {
            boolean bandTipoEm = false;
            if (fileSignature.getCliente().getTipoEmprendedor() == null) {
                bandTipoEm = true;
            }
            if (!bandTipoEm && fileSignature.getCliente().getTipoEmprendedor().isEmpty()) {
                bandTipoEm = true;
            }
            if (fileSignature.getCliente().getTipoEmprendedor() == null) {
                throw new CustomException("El tipo de emprendedor es requerido.");
            }
            if (fileSignature.getCliente().getTipoEmprendedor().isEmpty()) {
                throw new CustomException("El tipo de emprendedor es requerido.");
            }
            ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
            LocalDateTime fechaHoraEcuador = LocalDateTime.now(zonaEcuador);
            Date fecha = Date.from(fechaHoraEcuador.toInstant(ZoneOffset.UTC));
            TSuscripcionContfiables suscripcion = new TSuscripcionContfiables();
            if (fileSignature.getCliente().getIdentification().length() != 13) {
                throw new CustomException("El RUC no es v\u00e1lido");
            }
            RespSimple respValidatorRuc = this.identificationValidator.validarRUC(fileSignature.getCliente().getIdentification());
            if (respValidatorRuc.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
                throw new CustomException(respValidatorRuc.getMensaje());
            }
            TTipoEmprendedor tipoEmprendedor = this.tipoEmprendedorDAO.findByTipo(fileSignature.getCliente().getTipoEmprendedor());
            if (tipoEmprendedor == null) {
                throw new CustomException("El tipo de emprendedor no existe");
            }
            boolean existeCliente = this.clienteDAO.existsByIdentificationOrUser(fileSignature.getCliente().getIdentification(), fileSignature.getCliente().getUser());
            if (existeCliente) {
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                respuesta.setMensaje("Ya existe un registo con esa identificaci\u00f3n o usuario.");
                return respuesta;
            }
            RespSimple respuestaSimple = this.firmaElectronicaService.almacenarArchivo(fileSignature);
            if (respuestaSimple.getError().equals(ContfiablesEnum.TRANSACCION_OK.getId())) {
                if (!fileSignature.getLogo64().isEmpty()) {
                    this.crearLogo(fileSignature);
                    fileSignature.getCliente().setLogo(fileSignature.getCliente().getIdentification().concat(".png"));
                }
                fileSignature.getCliente().setFechaRegistro(fecha);
                fileSignature.getCliente().setArchivoFirma(fileSignature.getCliente().getIdentification().concat(".p12"));
                fileSignature.getCliente().setClaveFirma(this.seguridad.encrypt(fileSignature.getPassword()));
                Date fechaCaducidad = this.firmaElectronicaService.obtenerFechaCaducidadP12(fileSignature.getCliente().getIdentification(), fileSignature.getPassword());
                fileSignature.getCliente().setFechaCaducidadFirma(fechaCaducidad);
                TCliente t_Cliente = new TCliente();
                t_Cliente.setTipoEmprendedor(bandTipoEm ? null : fileSignature.getCliente().getTipoEmprendedor());
                t_Cliente = fileSignature.getCliente();
                t_Cliente.setObligadoContabilidad(Boolean.valueOf(t_Cliente.getObligadoContabilidad() == null ? false : t_Cliente.getObligadoContabilidad()));
                t_Cliente = (TCliente)this.clienteDAO.save((Object)t_Cliente);
                LocalDateTime fechaActual = LocalDateTime.now();
                suscripcion.setCliente(t_Cliente);
                suscripcion.setCreatedAt(fechaActual);
                suscripcion.setFechaInicio(fechaActual);
                suscripcion.setTiempoDiasMensual(0);
                LocalDateTime nuevaFinSuscripcion = fechaActual.plusMonths(12L);
                suscripcion.setFechaFin(nuevaFinSuscripcion);
                long days = ChronoUnit.DAYS.between(suscripcion.getFechaInicio(), suscripcion.getFechaFin());
                suscripcion.setDiasTrial(Long.valueOf(days));
                suscripcion.setActivo(Boolean.valueOf(true));
                suscripcion.setTrial(Boolean.valueOf(true));
                suscripcion.setCupo(Integer.valueOf(300));
                suscripcion.setDiasRestantes(Long.valueOf(days));
                suscripcion.setFacturasEmitidas(Integer.valueOf(0));
                this.suscripcionDAO.save((Object)suscripcion);
                TBodega bodegaPrincipal = new TBodega();
                bodegaPrincipal.setActivo(Boolean.valueOf(true));
                bodegaPrincipal.setCalleNumeracion("Matriz");
                bodegaPrincipal.setCallePrincipal("Matriz");
                bodegaPrincipal.setCalleSecundaria("Matriz");
                bodegaPrincipal.setCliente(t_Cliente);
                bodegaPrincipal.setCodigo("01");
                bodegaPrincipal.setMostrarSaldo(Boolean.valueOf(true));
                bodegaPrincipal.setNombre("Principal");
                bodegaPrincipal.setPrincipal(Boolean.valueOf(true));
                bodegaPrincipal.setVolumenBruto(new BigDecimal(0.0));
                bodegaPrincipal.setVolumenNeto(new BigDecimal(0.0));
                this.bodegaDAO.save((Object)bodegaPrincipal);
                TCategoriaProveedor catProveedor = new TCategoriaProveedor();
                catProveedor.setAbreviatura("GN");
                catProveedor.setActivo(true);
                catProveedor.setCliente(t_Cliente);
                catProveedor.setDescripcion("General");
                this.categoriaProveedorDAO.save((Object)catProveedor);
                fileSignature.setCliente(t_Cliente);
                TFelectronic tfelectronic = new TFelectronic();
                tfelectronic.setCredentials(fileSignature.getPassword());
                tfelectronic.setIdCliente(fileSignature.getCliente());
                tfelectronic.setMCurrent(ContfiablesEnum.MCURRENT.getId());
                tfelectronic.setMUser(ContfiablesEnum.USERADMIN.getId());
                tfelectronic.setFile(respuestaSimple.getParametroRespuesta());
                this.tfelectronicDAO.save((Object)tfelectronic);
                TEstablecimiento establecimiento = new TEstablecimiento();
                establecimiento.setActivo(true);
                establecimiento.setCliente(t_Cliente);
                establecimiento.setDireccion("Matriz");
                establecimiento.setEstablecimiento("001");
                establecimiento.setNombre("Matriz");
                TEstablecimiento establecimientoDB = (TEstablecimiento)this.establecimientoDAO.save((Object)establecimiento);
                String direccionPuntoEmision = fileSignature.getDireccion() == null ? fileSignature.getCliente().getCiudad() : fileSignature.getDireccion();
                TPuntoVenta puntoVenta = new TPuntoVenta();
                puntoVenta.setEstablecimiento(establecimientoDB);
                puntoVenta.setActivo(Boolean.valueOf(true));
                puntoVenta.setPuntoEmision("100");
                puntoVenta.setNombre("Punto electr\u00f3nico");
                puntoVenta.setPrincipal(Boolean.valueOf(true));
                puntoVenta.setDireccion(direccionPuntoEmision);
                this.puntoVentaService.registrarPuntoVenta(puntoVenta);
                TSecuenciaFactura t_SecuenciaFactura = new TSecuenciaFactura();
                t_SecuenciaFactura.setCodigoDocumento("01");
                t_SecuenciaFactura.setEstablecimiento(establecimiento.getEstablecimiento());
                t_SecuenciaFactura.setPuntoEmision(puntoVenta.getPuntoEmision());
                t_SecuenciaFactura.setSecuencial(Integer.valueOf(1));
                t_SecuenciaFactura.setCliente(t_Cliente);
                this.tSecuenciaFacturaDAO.save((Object)t_SecuenciaFactura);
                TSecuenciaProducto tSecuenciaProducto = new TSecuenciaProducto();
                tSecuenciaProducto.setSecuencial(Integer.valueOf(1));
                tSecuenciaProducto.setCliente(t_Cliente);
                this.tSecuenciaProductoDAO.save((Object)tSecuenciaProducto);
                TSecuenciaComponente tSecuenciaComponente = new TSecuenciaComponente();
                tSecuenciaComponente.setSecuencia(Integer.valueOf(1));
                tSecuenciaComponente.setCliente(t_Cliente);
                this.tSecuenciaComponenteDAO.save((Object)tSecuenciaComponente);
                TUnidadMedida unidadMedida = new TUnidadMedida("Ud", "Unidad", t_Cliente);
                this.unidadMedidaDAO.save((Object)unidadMedida);
                TMarca marca = new TMarca("Gn", "General", t_Cliente);
                this.marcaDAO.save((Object)marca);
                TTipoProducto tipoProd = new TTipoProducto("Gn", "General", t_Cliente);
                this.tipoProductoDAO.save((Object)tipoProd);
                if (fileSignature.getKeycloack().booleanValue()) {
                    try {
                        this.keycloakController.saveUsuarioKeycloak(fileSignature.getCliente().getUser(), fileSignature.getCliente().getEmailCliente(), fileSignature.getCliente().getNombres(), fileSignature.getCliente().getApellidos(), fileSignature.getCliente().getClave());
                        String userId = this.keycloakController.getUserId(fileSignature.getCliente().getUser());
                        this.keycloakController.saveRolesUsuarioKeycloak(userId);
                    }
                    catch (Exception e) {
                        respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
                        this.log.log(Level.SEVERE, "Error de registro de usuario: ", e);
                        throw new CustomException("Error al registrar el usuario en el servidor.");
                    }
                }
                respuesta.setError(ContfiablesEnum.TRANSACCION_OK.getId());
                respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
                respuesta.setMensaje("Registro Exitoso / Puede Iniciar Sesi\u00f3n");
                return respuesta;
            }
            respuestaSimple.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setMensaje("Error al registrar el usuario");
            return respuestaSimple;
        }
        catch (CustomException ce) {
            this.log.log(Level.SEVERE, "ERROR AL ALMACENAR CLIENTE ", ce);
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setMensaje(ce.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return respuesta;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL ALMACENAR CLIENTE ", e);
            respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            respuesta.setMensaje("Error al registrar el usuario");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return respuesta;
        }
    }

    public RespSimple actualizarCliente(FileSignature fileSignature) {
        RespSimple respuesta;
        block7: {
            respuesta = new RespSimple();
            try {
                TCliente t_cliente = (TCliente)this.clienteDAO.findById((Object)fileSignature.getCliente().getIdCliente()).get();
                if (!fileSignature.getLogo64().isEmpty()) {
                    this.crearLogo(fileSignature);
                    fileSignature.getCliente().setLogo(fileSignature.getCliente().getIdentification().concat(".png"));
                    t_cliente.setLogo(fileSignature.getCliente().getLogo());
                }
                boolean bandTipoEm = false;
                if (fileSignature.getCliente().getTipoEmprendedor() == null) {
                    bandTipoEm = true;
                }
                if (!bandTipoEm && fileSignature.getCliente().getTipoEmprendedor().isEmpty()) {
                    bandTipoEm = true;
                }
                t_cliente.setTipoEmprendedor(bandTipoEm ? null : fileSignature.getCliente().getTipoEmprendedor());
                t_cliente.setIdentification(fileSignature.getCliente().getIdentification());
                t_cliente.setNombres(fileSignature.getCliente().getNombres());
                t_cliente.setApellidos(fileSignature.getCliente().getApellidos());
                t_cliente.setCiudad(fileSignature.getCliente().getCiudad());
                t_cliente.setTelefono(fileSignature.getCliente().getTelefono());
                t_cliente.setEmailCliente(fileSignature.getCliente().getEmailCliente());
                t_cliente.setNombreComercial(fileSignature.getCliente().getNombreComercial());
                t_cliente.setObligadoContabilidad(Boolean.valueOf(fileSignature.getCliente().getObligadoContabilidad() == null ? false : fileSignature.getCliente().getObligadoContabilidad()));
                Date fechaCaducidad = this.firmaElectronicaService.obtenerFechaCaducidadP12(fileSignature.getCliente().getIdentification(), fileSignature.getPassword());
                fileSignature.getCliente().setFechaCaducidadFirma(fechaCaducidad);
                t_cliente.setFechaCaducidadFirma(fechaCaducidad);
                this.clienteDAO.save((Object)t_cliente);
                respuesta.setError(ContfiablesEnum.TRANSACCION_OK.getId());
                if (fileSignature.getFile64().isEmpty()) break block7;
                RespSimple respuestaSimple = this.firmaElectronicaService.almacenarArchivo(fileSignature);
                if (respuestaSimple.getError().equals(ContfiablesEnum.TRANSACCION_OK.getId())) {
                    t_cliente.setArchivoFirma(fileSignature.getCliente().getIdentification().concat(".p12"));
                    t_cliente.setClaveFirma(this.seguridad.encrypt(fileSignature.getPassword()));
                    this.clienteDAO.save((Object)t_cliente);
                    TFelectronic tfelectronic = new TFelectronic();
                    tfelectronic.setCredentials(fileSignature.getPassword());
                    tfelectronic.setIdCliente(fileSignature.getCliente());
                    tfelectronic.setMCurrent(ContfiablesEnum.MCURRENT.getId());
                    tfelectronic.setMUser(ContfiablesEnum.USERADMIN.getId());
                    tfelectronic.setFile(respuestaSimple.getParametroRespuesta());
                    this.tfelectronicDAO.save((Object)tfelectronic);
                    respuesta.setError(ContfiablesEnum.TRANSACCION_OK.getId());
                    break block7;
                }
                return respuestaSimple;
            }
            catch (CustomException e) {
                this.log.log(Level.SEVERE, "ERROR AL ACTUALIZAR EL USUARIO".concat(e.getMessage()));
                respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ERROR AL ACTUALIZAR EL USUARIO".concat(e.getMessage()));
                respuesta.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            }
        }
        return respuesta;
    }

    public String decrypt(String palabra) throws Exception {
        return this.seguridad.decrypt(palabra);
    }

    public String encrypt(String palabra) throws Exception {
        return this.seguridad.encrypt(palabra);
    }

    public String obtenerLogo(String ruc) {
        return this.imageToBase64(this.path.concat("").concat(ruc).concat("/").concat(ruc.concat(".png")));
    }

    public boolean crearLogo(FileSignature fileSignature) {
        try {
            int width = 335;
            int height = 168;
            byte[] data = DatatypeConverter.parseBase64Binary((String)fileSignature.getLogo64());
            File file = new File(this.path.concat("").concat(fileSignature.getCliente().getIdentification()).concat("/").concat(fileSignature.getCliente().getIdentification().concat(".png")));
            try {
                ByteArrayInputStream inStreambj = new ByteArrayInputStream(data);
                BufferedImage newImage = ImageIO.read(inStreambj);
                BufferedImage resizedImage = new BufferedImage(width, height, 1);
                resizedImage.getGraphics().drawImage(newImage, 0, 0, width, height, null);
                ImageIO.write((RenderedImage)resizedImage, "png", file);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ERROR AL CREAR LOGO ", e);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL CREAR LOGO ", e);
        }
        return true;
    }

    public boolean crearPagoContfiable(String fileName, String qrImage, String identificacion) {
        try {
            int width = 400;
            int height = 400;
            byte[] data = DatatypeConverter.parseBase64Binary((String)qrImage);
            String rutaDirectorio = this.path.concat("").concat(identificacion).concat("/").concat("cobroContfiable");
            File directorio = new File(rutaDirectorio);
            if (!directorio.exists()) {
                if (directorio.mkdirs()) {
                    this.log.info("DIRECTORIO PARA COBROCONTFIBALE CREADO,IDENTIFICACION CLIENTE: ".concat(identificacion));
                } else {
                    return false;
                }
            }
            File file = new File(rutaDirectorio.concat("/").concat(fileName.concat(".png")));
            try {
                ByteArrayInputStream inStreambj = new ByteArrayInputStream(data);
                BufferedImage newImage = ImageIO.read(inStreambj);
                BufferedImage resizedImage = new BufferedImage(width, height, 1);
                resizedImage.getGraphics().drawImage(newImage, 0, 0, width, height, null);
                ImageIO.write((RenderedImage)resizedImage, "png", file);
                return true;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ERROR AL CREAR IMAGEN PAGO CONTFIABLE", e);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL IMAGEN PAGO CONTFIABLE ", e);
        }
        return false;
    }

    public String imageToBase64(String imagePath) {
        String string;
        File file = new File(imagePath);
        FileInputStream imageInFile = new FileInputStream(file);
        try {
            byte[] imageData = new byte[(int)file.length()];
            imageInFile.read(imageData);
            string = Base64.encodeBase64String((byte[])imageData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    imageInFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        imageInFile.close();
        return string;
    }

    public Integer obtenerSecuenciaProducto(Long id_cliente) {
        TCliente tCliente = (TCliente)this.clienteDAO.findById((Object)id_cliente).get();
        return this.tSecuenciaProductoDAO.findByCliente(tCliente).getSecuencial();
    }

    public Integer obtenerSecuenciaComponente(Long id_cliente) {
        TCliente tCliente = (TCliente)this.clienteDAO.findById((Object)id_cliente).get();
        return this.tSecuenciaComponenteDAO.findByCliente(tCliente).getSecuencia();
    }

    public ResponseEntity<RespSimple> getClienteSuscripcion(String username) {
        RespSimple response = new RespSimple();
        LocalDateTime fechahoy = LocalDateTime.now();
        try {
            response.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            response.setMensaje("suscripcion obtenida");
            TSuscripcionContfiables suscripcion = this.suscripcionDAO.findByClienteUsername(username);
            if (suscripcion != null && suscripcion.getFechaFin() != null && suscripcion.getFechaInicio() != null) {
                if (fechahoy.isAfter(suscripcion.getFechaFin())) {
                    suscripcion.setActivo(Boolean.valueOf(false));
                    suscripcion.setTrial(Boolean.valueOf(false));
                    this.suscripcionDAO.save((Object)suscripcion);
                } else if (!suscripcion.getActivo().booleanValue()) {
                    suscripcion.setActivo(Boolean.valueOf(true));
                    suscripcion.setTrial(Boolean.valueOf(false));
                    this.suscripcionDAO.save((Object)suscripcion);
                }
                try {
                    long diasRestantes = ChronoUnit.DAYS.between(suscripcion.getFechaFin(), suscripcion.getFechaInicio());
                    suscripcion.setDiasRestantes(Long.valueOf(diasRestantes));
                }
                catch (Exception e) {
                    suscripcion.setDiasRestantes(null);
                }
            }
            response.setData((Object)suscripcion);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setDescripcion(e.getMessage());
            response.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            response.setMensaje("Cliente no registrado");
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> eliminarUsuario(String usuario) {
        RespSimple respuesta = new RespSimple();
        try {
            String id_usuario = this.keycloakController.getUserId(usuario);
            this.keycloakController.deshabilitarUsuarioKeycloak(id_usuario);
            TCliente cliente = this.clienteDAO.getCliente(usuario);
            Path certificado = Paths.get(this.path + cliente.getIdentification() + "/" + cliente.getArchivoFirma(), new String[0]);
            Files.delete(certificado);
            cliente.setClaveFirma("");
            this.clienteDAO.save((Object)cliente);
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            respuesta.setMensaje("Eliminado");
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            respuesta.setMensaje("Ocurri\u00f3 un error al intentar eliminar su cuenta.");
            respuesta.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            return new ResponseEntity((Object)respuesta, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<RespSimple> getVersionContfiables(Long idVersion) {
        TVersionContfiables version = this.versionContfiablesDAO.findById((Object)idVersion).orElse(null);
        if (version == null) {
            return Transaccion.NOTFOUNT((String)"No se encontro al versi\u00f3n de contfiables");
        }
        return Transaccion.OK((String)"Version obtenida", (Object)version);
    }

    @Transactional
    public ResponseEntity<RespSimple> saveCobroContfiable(CobroContfiableDTO cobroContfiableDTO) {
        try {
            TCliente cliente = this.clienteDAO.findById((Object)cobroContfiableDTO.getIdCliente()).orElse(null);
            TCobroContfiable cobroContfiable = new TCobroContfiable();
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"No existe un cliente activo para registrar el pago ContFiable");
            }
            String uuidGenerated = cobroContfiableDTO.getQrImage();
            if (cobroContfiableDTO.getId() == null || cobroContfiableDTO.getId() == 0L) {
                cobroContfiableDTO.setId(null);
            } else {
                try {
                    TCobroContfiable cobroSaved = this.cobroContfiableDAO.findById((Object)cobroContfiableDTO.getId()).orElse(null);
                    if (cobroSaved != null) {
                        String rutaDirectorio = this.path.concat("").concat(cliente.getIdentification()).concat("/").concat("cobroContfiable/").concat(cobroSaved.getQrImage());
                        File file = new File(rutaDirectorio);
                        file.delete();
                        cobroContfiable = cobroSaved;
                    } else {
                        cobroContfiableDTO.setId(null);
                    }
                }
                catch (Exception e) {
                    this.log.severe("ERROR AL ELIMINAR LA IMAGEN ANTIGUA ".concat(e.getMessage()));
                }
            }
            UUID uuid = UUID.randomUUID();
            uuidGenerated = uuid.toString();
            boolean saveQr = this.crearPagoContfiable(uuidGenerated, cobroContfiableDTO.getQrImage(), cliente.getIdentification());
            if (!saveQr) {
                return Transaccion.CUSTOM_EXCEPTION((String)"Error al almacenar la im\u00e1gen QR");
            }
            cobroContfiable.setCliente(cliente);
            cobroContfiable.setEntidadFinanciera(cobroContfiableDTO.getEntidadFinanciera());
            cobroContfiable.setFavorito(Boolean.valueOf(cobroContfiableDTO.getFavorito() == null ? false : cobroContfiableDTO.getFavorito()));
            cobroContfiable.setQrImage(uuidGenerated.concat(".png"));
            this.cobroContfiableDAO.save((Object)cobroContfiable);
            this.log.info("IMAGEN DE COBROCONTFIABLES GUARDADA, CLIENTE: ".concat(cliente.getNombres().concat(" ").concat(cliente.getApellidos())));
            return Transaccion.CREATED((String)"Cobro ContFiable registrado");
        }
        catch (Exception e) {
            this.log.severe("ERROR AL ALMACENAR EL COBRO CONTFIABLE: ".concat(e.getMessage()));
            return Transaccion.ERROR((String)"ERROR AL ALMACENAR EL COBRO CONTFIABLE");
        }
    }

    public ResponseEntity<RespSimple> sgetListCobroContfiable(String username, Boolean onlyFavorite) {
        try {
            TCliente cliente = this.clienteDAO.getCliente(username);
            if (cliente == null) {
                return Transaccion.NOTFOUNT((String)"No existe el cliente a identificar.");
            }
            List listCobrosContfiables = onlyFavorite != false ? this.cobroContfiableDAO.findJustFavoritesByIdCliente(username) : this.cobroContfiableDAO.findAllByIdCliente(username);
            for (CobroContfiableDTO c : listCobrosContfiables) {
                try {
                    String qr = this.getImageBase64ToString(cliente, c.getQrImage());
                    c.setQrImage(qr == null ? "" : qr);
                }
                catch (Exception e) {
                    c.setQrImage("");
                }
            }
            return Transaccion.OK((String)"Lista de formas de cobro contfiables obtenida", (Object)listCobrosContfiables);
        }
        catch (Exception e) {
            this.log.severe("ERROR AL OBTENER LA LISTA DE COBRO CONTFIABLES: ".concat(e.getMessage()));
            return Transaccion.ERROR((String)"Error al obtener la lista de cobroCotfiables");
        }
    }

    private String getImageBase64ToString(TCliente cliente, String direccionImagen) {
        try {
            String rutaDirectorio = this.path.concat("").concat(cliente.getIdentification()).concat("/").concat("cobroContfiable/").concat(direccionImagen);
            return this.imageToBase64(rutaDirectorio);
        }
        catch (Exception e) {
            return "";
        }
    }

    public ResponseEntity<RespSimple> changeFavoriteCobroContfiable(Long idCobroContfiable, Boolean isFavorite) {
        try {
            TCobroContfiable cobroContfiable = this.cobroContfiableDAO.findById((Object)idCobroContfiable).orElse(null);
            if (cobroContfiable == null) {
                return Transaccion.NOTFOUNT((String)"No existe el cobro solicitado");
            }
            cobroContfiable.setFavorito(isFavorite);
            this.cobroContfiableDAO.save((Object)cobroContfiable);
            return Transaccion.OK((String)"Favorito actualizado.", (Object)isFavorite);
        }
        catch (Exception e) {
            return Transaccion.ERROR((String)"Error al actualizar el favorito");
        }
    }

    public ResponseEntity<RespSimple> getTipoEmprendedorList() {
        return Transaccion.OK((String)"Lista obtenida", (Object)this.tipoEmprendedorDAO.findByActivo());
    }

    public ResponseEntity<?> getPasswordCerticateByIdentification(String identification) {
        String password = this.clienteDAO.getPasswordCerticateByIdentification(identification);
        HashMap<String, String> encripted = new HashMap<String, String>();
        encripted.put("password", password);
        return new ResponseEntity(encripted, (HttpStatusCode)HttpStatus.OK);
    }
}

