/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.services.impl.cliente;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TAdquiriente;
import ec.tws2.back.contfiables.repositories.cliente.TAdquirenteDAO;
import ec.tws2.back.contfiables.services.AdquirienteService;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AdquirenteServiceImpl
implements AdquirienteService {
    @Autowired
    TAdquirenteDAO adquirenteDao;
    private Logger log = Logger.getLogger(AdquirenteServiceImpl.class.getName());

    public TAdquiriente getAdquiriente4identification(String identificacion) {
        TAdquiriente adquiriente = new TAdquiriente();
        try {
            adquiriente = (TAdquiriente)this.adquirenteDao.findByIdentificacion(identificacion).get();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL GET ADQUIRIENTE ", e);
        }
        return adquiriente;
    }

    public Boolean existeAdquiriente(String identificacion) {
        return this.adquirenteDao.existsByIdentificacion(identificacion);
    }

    public ResponseEntity<RespSimple> filtrarAdquiriente(String q) {
        RespSimple response = new RespSimple();
        try {
            response.setCodigo("0");
            response.setMensaje("lista obtenida");
            response.setData((Object)this.adquirenteDao.buscarPorRazonSocialORIdentifiacion(q.toLowerCase()));
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            response.setCodigo("1");
            response.setMensaje("Error en la lista de adquirientes:");
            response.setData(new ArrayList());
            this.log.log(Level.SEVERE, "error: ", e);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<RespSimple> getAdquiriente4RazonSocial(String razonSocial) {
        try {
            return Transaccion.OK((String)"Lista obtenida", (Object)this.adquirenteDao.findByRazonSocialContainingIgnoreCase(razonSocial.toLowerCase()));
        }
        catch (Exception e) {
            return Transaccion.CUSTOM_EXCEPTION((String)"Error en la lista de adquirientes");
        }
    }

    public ResponseEntity<RespSimple> filtrarAdquirienteByIdentificacion(String razonSocial) {
        try {
            return Transaccion.OK((String)"Lista obtenida", (Object)this.adquirenteDao.findByIdentificacionContainingIgnoreCase(razonSocial.toLowerCase()));
        }
        catch (Exception e) {
            return Transaccion.CUSTOM_EXCEPTION((String)"Error en la lista de adquirientes");
        }
    }
}

