/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.repositories.inventario;

import ec.tws2.back.contfiables.models.dtos.IProductoListDTO;
import ec.tws2.back.contfiables.models.dtos.ProductModelDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoFacturaMovilDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoMovilDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TProductoDAO
extends JpaRepository<TProducto, BigDecimal> {
    @Query(value="SELECT p FROM TProducto p WHERE p.cliente.idCliente = :idCliente AND CAST(p.id AS string) NOT IN :idProductos ORDER BY p.id DESC")
    public List<TProducto> getProductTodoInventariable(@Param(value="idCliente") Long var1, @Param(value="idProductos") List<String> var2);

    @Query(value="select p.* from t_producto p where p.id_cliente = :idCliente and cast(p.id_producto as varchar) NOT IN (SELECT unnest(string_to_array(:idProducto, ','))) ORDER BY p.id_producto DESC", nativeQuery=true)
    public List<TProducto> obtenerProductosMOVILV1(@Param(value="idCliente") Long var1, @Param(value="idProducto") String var2);

    @Query(value="SELECT p.id as id, p.codigo as codigo, p.nombreProducto as nombreProducto, p.precioUnitario as precioUnitario FROM TProducto p WHERE p.cliente.idCliente = :idCliente AND CAST(p.id AS string) NOT IN :idProductos ORDER BY p.id DESC")
    public List<ProductoFacturaMovilDTO> obtenerProductosFacturacionMovil(Long var1, List<String> var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.ProductoMovilDTO(p.id, p.codigo, p.nombreProducto, p.precioUnitario, p.idTarifaIva.idTarifaIva, p.idTarifaIva.porcentaje, p.cliente.idCliente, p.informacionAdicional) FROM TProducto p WHERE p.cliente.idCliente = :idCliente AND CAST(p.id AS string) NOT IN :idProductos ORDER BY p.id DESC")
    public List<ProductoMovilDTO> obtenerProductosMOVILV2(@Param(value="idCliente") Long var1, @Param(value="idProductos") List<String> var2);

    @Query(value="select p.* from t_producto p where p.id_cliente = :idCliente AND p.inventariable=false AND p.activo=true and cast(p.id_producto as varchar) NOT IN (SELECT unnest(string_to_array(:idProducto, ',')))", nativeQuery=true)
    public List<TProducto> obtenerProductos(@Param(value="idCliente") Long var1, @Param(value="idProducto") String var2);

    @Query(value="select p from TProducto p where p.cliente.idCliente = :idCliente")
    public List<TProducto> obtenerProductosFront(@Param(value="idCliente") Long var1);

    @Query(value="SELECT p.id_producto as id, \n       p.codigo as codigo, \n       p.nombre_producto as nombreProducto, \n       p.precio_unitario as precio, \n       um.abreviatura AS unidadM, \n       p.activo as activo, \n       p.inventariable as inventariable, \n       ti.stock as stock, \n       ti_bodega.nombre AS bodega, \n       tarifa_iva.porcentaje AS tarifaIva\nFROM contfiables.t_inventario ti \nRIGHT JOIN contfiables.t_producto p ON ti.id_producto = p.id_producto \nLEFT JOIN contfiables.t_unidad_medida um ON p.id_unidad_medida = um.id_unidad_medida \nLEFT JOIN contfiables.t_tarifa_iva tarifa_iva ON p.id_tarifa_iva = tarifa_iva.id_tarifa_iva\nLEFT JOIN contfiables.t_bodega ti_bodega ON ti.id_bodega = ti_bodega.id_bodega \nWHERE p.id_cliente = :idCliente \nORDER BY p.id_producto ;", nativeQuery=true)
    public List<IProductoListDTO> obtenerProductosFrontCustom(@Param(value="idCliente") Long var1);

    @Query(value="select p from TProducto p where p.cliente.idCliente = :idCliente AND p.inventariable=false AND p.activo=true AND (LOWER(p.codigo) LIKE %:q% OR LOWER(p.nombreProducto) LIKE %:q%)")
    public List<TProducto> filtrarProductosNoInventariables(@Param(value="idCliente") Long var1, @Param(value="q") String var2, Pageable var3);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO(p.id, 0l, p.codigo, p.nombreProducto, p.precioUnitario, p.idTarifaIva.codigoSri, p.idTarifaIva.porcentaje, p.cliente.idCliente, p.stock, p.inventariable, 0l)  FROM TProducto p WHERE p.cliente.idCliente =:idCliente AND p.activo=TRUE AND (LOWER(p.codigo) LIKE %:q% OR LOWER(p.nombreProducto) LIKE %:q%)")
    public List<ProductoInvenFacturacionDTO> filtrarProductosQueryFacturacionDTO(Long var1, String var2, Pageable var3);

    @Query(value="select p.nombreProducto from TProducto p where p.id=:id")
    public String obtenerNombreProducto(@Param(value="id") BigDecimal var1);

    @Query(value="select p.codigo from TProducto p where p.id=:id")
    public String obtenerCodigoProducto(@Param(value="id") BigDecimal var1);

    @Query(value="select p.precioUnitario from TProducto p where p.id=:id")
    public BigDecimal obtenerPrecioProducto(@Param(value="id") BigDecimal var1);

    @Query(value="select p.idTarifaIva.porcentaje from TProducto p where p.id =:id")
    public Integer obtenerIvaProducto(@Param(value="id") BigDecimal var1);

    @Query(value="select p.idTarifaIva.idTarifaIva from TProducto p where p.id=:id")
    public Integer obtenerIdTarifaIva(@Param(value="id") BigDecimal var1);

    public boolean existsByCodigoAndCliente(String var1, TCliente var2);

    public TProducto findByCodigoAndCliente(String var1, TCliente var2);

    public TProducto findByCodigoAndClienteAndActivo(String var1, TCliente var2, Boolean var3);

    public List<TProducto> findByClienteAndInventariable(TCliente var1, boolean var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.ProductModelDTO(tp.id, tp.codigo, tp.nombreProducto, tp.precioUnitario, tp.informacionAdicional, tp.idTarifaIva.idTarifaIva, tp.unidadMedida.idUnidadMedida, tp.marca.idMarca, tp.tipoProducto.idTipoProducto, tp.cliente.idCliente, tp.activo, tp.marketplace, tp.stock, tp.costoCompra, tp.inventariable, tp.stockMinimo, tp.stockMaximo) FROM TProducto tp WHERE tp.id = :idProducto")
    public ProductModelDTO getProductoDTO(Long var1);

    public List<TProducto> findByCliente(TCliente var1);
}

