/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.repositories.inventario;

import ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO;
import ec.tws2.back.contfiables.models.entities.inventario.TBodega;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface TInventarioDAO
extends JpaRepository<TInventario, Long> {
    @Query(value="SELECT inv.*\nFROM t_inventario inv\nJOIN t_producto p ON inv.id_producto = p.id_producto\nJOIN t_cliente c ON p.id_cliente = c.id_cliente\nJOIN t_bodega b ON inv.id_bodega = b.id_bodega\nWHERE c.id_cliente = :idCliente\n  AND b.id_bodega = :idBodega\n  AND p.activo = TRUE\n  AND (LOWER(p.codigo) LIKE CONCAT('%', :q, '%')\n       OR LOWER(p.nombre_producto) LIKE CONCAT('%', :q, '%')) LIMIT 10", nativeQuery=true)
    public List<TInventario> filtrarProductosQuery(Long var1, Long var2, String var3);

    @Query(value="SELECT inv FROM TInventario inv WHERE inv.producto.cliente.idCliente =:idCliente AND inv.bodega.idBodega=:idBodega AND inv.stock>0 AND inv.producto.activo=TRUE AND (LOWER(inv.producto.codigo) LIKE %:q% OR LOWER(inv.producto.nombreProducto) LIKE %:q%)")
    public List<TInventario> filtrarProductosQueryFacturacion(Long var1, Long var2, String var3, Pageable var4);

    public TInventario findByProducto(TProducto var1);

    public TInventario findByBodegaAndProducto(TBodega var1, TProducto var2);

    @Query(value="SELECT p FROM TInventario p WHERE p.bodega.idBodega=:idBodega AND p.stock > 0 AND p.producto.codigo =:codigo AND p.producto.activo = true")
    public TInventario filtrarByBodegaAndCodigoProducto(Long var1, String var2);

    @Query(value="SELECT count(ti) FROM TInventario ti WHERE ti.producto.cliente.idCliente =:idCliente AND ti.producto.activo = TRUE AND ti.producto.stockMinimo <= ti.stock")
    public Long countProductHasMinStock(Long var1);

    @Query(value="SELECT ti FROM TInventario ti WHERE ti.producto.cliente.idCliente =:idCliente AND ti.producto.activo = TRUE AND ti.producto.stockMinimo <= ti.stock")
    public List<TInventario> findProductHasMinStock(Long var1);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO(inv.producto.id, inv.idInventario, inv.producto.codigo, inv.producto.nombreProducto, inv.producto.precioUnitario, inv.producto.idTarifaIva.codigoSri, inv.producto.idTarifaIva.porcentaje, inv.producto.cliente.idCliente, inv.stock, inv.producto.inventariable, inv.bodega.idBodega)  FROM TInventario inv WHERE inv.producto.cliente.idCliente =:idCliente AND inv.bodega.idBodega=:idBodega AND inv.stock>0 AND inv.producto.activo=TRUE AND (LOWER(inv.producto.codigo) LIKE %:q% OR LOWER(inv.producto.nombreProducto) LIKE %:q%)")
    public List<ProductoInvenFacturacionDTO> filtrarProductosQueryFacturacionDTO(Long var1, Long var2, String var3, Pageable var4);
}

