/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.repositories.facturacion;

import ec.tws2.back.contfiables.models.dtos.DashboardFacturaAnioMes;
import ec.tws2.back.contfiables.models.dtos.Factura.FacturaDTO80mm;
import ec.tws2.back.contfiables.models.dtos.FacturaDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;

public interface TFacturaDAO
extends JpaRepository<TFactura, BigDecimal> {
    @Query(value="SELECT * FROM t_factura tf  where id_cliente =:id_cliente and tf.is_autorizado =true ORDER BY id_factura  DESC LIMIT 3", nativeQuery=true)
    public List<TFactura> obtenerUltimas3Facturas(@Param(value="id_cliente") BigDecimal var1);

    @Query(value="select * from t_factura tf where tf.id_cliente =:idCliente and tf.fecha_emision between TO_TIMESTAMP(:fechaInicio ,'YYYY-MM-DD HH24:MI:SS') and TO_TIMESTAMP(:fechaFinal ,'YYYY-MM-DD HH24:MI:SS') and tf.is_autorizado =true ORDER BY tf.id_factura  DESC", nativeQuery=true)
    public List<TFactura> obtenerFacturasAutorizadasPorFecha(@Param(value="idCliente") Long var1, @Param(value="fechaInicio") String var2, @Param(value="fechaFinal") String var3);

    public List<TFactura> findByClienteAndNumComprobante(TCliente var1, String var2);

    @Query(value="select t from TFactura t where t.cliente.idCliente =:idCliente ORDER BY t.id DESC")
    public List<TFactura> obtenerFacturas(@Param(value="idCliente") Long var1, Pageable var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.FacturaDTO(tf.id, tf.fechaEmision, tf.idAdquiriente.razonSocial, tf.total, tf.isAutorizado, tf.respuestaSri) FROM TFactura tf WHERE tf.cliente.idCliente =:idCliente AND  YEAR(tf.fechaEmision) = :anio AND MONTH(tf.fechaEmision) =  :mes ORDER BY tf.id DESC")
    public List<FacturaDTO> obtenerFacturasMesMovil(Long var1, int var2, int var3);

    @Query(value="select t from TFactura t where t.numComprobante =:numComprobante and t.cliente.idCliente =:idCliente ")
    public TFactura obtenerFacturaPorNumComprobante(@Param(value="numComprobante") String var1, @Param(value="idCliente") Long var2);

    @Query(value="select * from t_factura tf where tf.id_adquiriente = (select ta.id_adquiriente from t_adquiriente ta where ta.identificacion=:identificacion) and tf.id_cliente =:idCliente and tf.fecha_emision between TO_TIMESTAMP(:fechaInicio ,'YYYY-MM-DD HH24:MI:SS') and TO_TIMESTAMP(:fechaFinal ,'YYYY-MM-DD HH24:MI:SS') and tf.is_autorizado = true ORDER BY id_factura  DESC", nativeQuery=true)
    public List<TFactura> obtenerFacturasPorFechaEIdentificacion(@Param(value="idCliente") Long var1, @Param(value="fechaInicio") String var2, @Param(value="fechaFinal") String var3, @Param(value="identificacion") String var4);

    @Query(value="select t from TFactura t where t.numComprobante =:numComprobante and t.cliente.idCliente =:idCliente ")
    public TFactura obtenerFacturaPorNumComprobante(@Param(value="numComprobante") String var1, @Param(value="idCliente") BigDecimal var2);

    @Query(value="select * from t_factura tf where tf.id_cliente =:idCliente and tf.fecha_emision between TO_TIMESTAMP(:fechaInicio ,'YYYY-MM-DD HH24:MI:SS') and TO_TIMESTAMP(:fechaFinal ,'YYYY-MM-DD HH24:MI:SS') and tf.is_autorizado =:isAutorizado ORDER BY id_factura  DESC", nativeQuery=true)
    public List<TFactura> obtenerFacturasNoAutorizadasPorFechaIdentificacion(@Param(value="idCliente") int var1, @Param(value="fechaInicio") String var2, @Param(value="fechaFinal") String var3, @Param(value="isAutorizado") boolean var4);

    public TFactura findByNumComprobanteAndCliente(String var1, TCliente var2);

    public TFactura findByAuthorizacion(String var1);

    public List<TFactura> findByIsAutorizado(Boolean var1);

    public List<TFactura> findByIsAutorizadoAndEnviada(Boolean var1, Boolean var2);

    @Query(value="SELECT tf FROM TFactura tf where tf.cliente.idCliente= :idCliente and UPPER(tf.idAdquiriente.razonSocial) LIKE %:queryRazonSocial%")
    public List<TFactura> findByRazonSocialAndCliente(String var1, Long var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.FacturaDTO(tf.id, tf.fechaEmision, tf.numComprobante, tf.idAdquiriente.razonSocial, tf.subtotal, tf.impuestos, tf.total, tf.bodega.nombre, tf.authorizacion, tf.isAutorizado, tf.respuestaSri) FROM TFactura tf WHERE tf.cliente.idCliente =:idCliente ORDER BY tf.fechaEmision DESC")
    public List<FacturaDTO> ultimas5Facturas(Long var1, Pageable var2);

    @Query(value="SELECT * FROM t_factura tf  where id_cliente =:id_cliente and tf.is_autorizado =true ORDER BY id_factura  DESC LIMIT 5", nativeQuery=true)
    public List<TFactura> obtenerUltimas5Facturas(@Param(value="id_cliente") Long var1);

    @Query(value="SELECT COUNT(f) FROM TFactura f WHERE f.cliente.idCliente =:idCliente AND YEAR(f.fechaEmision) = :anio")
    public Long countByIdClienteAndAnio(Long var1, int var2);

    @Query(value="SELECT SUM(f.total) FROM TFactura f WHERE f.cliente.idCliente =:idCliente AND f.anulado <> TRUE AND YEAR(f.fechaEmision) = :anio")
    public BigDecimal sumByIdClienteAndAnio(Long var1, int var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.DashboardFacturaAnioMes( f.id, f.fechaEmision, f.total) FROM TFactura f WHERE f.cliente.idCliente =:idCliente AND YEAR(f.fechaEmision) = :anio")
    public List<DashboardFacturaAnioMes> buscarFacturasByClienteAndAnio(Long var1, int var2);

    @Query(value="SELECT NEW ec.tws2.back.contfiables.models.dtos.DashboardFacturaAnioMes( f.id, f.fechaEmision, f.total) FROM TFactura f WHERE f.cliente.idCliente =:idCliente AND YEAR(f.fechaEmision) = :anio AND MONTH(f.fechaEmision) = :mes")
    public List<DashboardFacturaAnioMes> buscarFacturasByClienteAndAnioAndMes(Long var1, int var2, int var3);

    @Query(value="SELECT tf.authorizacion as autorizacion, tf.numComprobante as numeroComprobante, tf.fechaEmision as fechaEmision, tf.cliente.obligadoContabilidad as obligadoContabilidad, tf.cliente.identification as ruc, tf.cliente.nombreComercial as nombreComercial, tf.cliente.nombres as nombresEmpresa, tf.cliente.apellidos apellidosEmpresa, tf.cliente.ciudad as direccionEmpresa, tf.cliente.telefono as telefonoEmpresa, tf.cliente.emailCliente as correoEmpresa, tf.idAdquiriente.razonSocial as razonSocialAdquiriente, tf.idAdquiriente.identificacion as identificacionAdquiriente, tf.idAdquiriente.direccion as direccionAdquiriente, tf.idAdquiriente.telefono as telefonoAdquiriente,  tf.subtotal as subtotal, tf.impuestos as iva, tf.total as total, tf.descuento as descuento, tf.observacionesComprador as observaciones, tf.idFormaPago.id as formaPago, tf.puntoVenta.puntoEmision as puntoEmision, tf.puntoVenta.establecimiento.establecimiento as establecimiento, tf.puntoVenta.direccion as direccionPuntoEmision FROM TFactura tf WHERE tf.id = :idFactura")
    public FacturaDTO80mm obtenerDatosFacturaReporte80mm(BigDecimal var1);

    @Query(value="select t from TFactura t where t.id =:idFactura")
    public TFactura obtenerFactura(@Param(value="idFactura") Long var1);

    @Modifying
    @Transactional
    @Procedure(procedureName="contfiables.procesar_devolucion_factura")
    public void procesarDevolucionFactura(@Param(value="factura_id_anular") Integer var1);
}

