/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.models.entities.inventario;

import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.entities.facturacion.TTarifaIva;
import ec.tws2.back.contfiables.models.entities.integracion.TCodigosIce;
import ec.tws2.back.contfiables.models.entities.inventario.TMarca;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProducto;
import ec.tws2.back.contfiables.models.entities.inventario.TUnidadMedida;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Entity
@Table(name="t_producto", schema="contfiables")
public class TProducto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_producto", nullable=false)
    private BigDecimal id;
    @Column(name="codigo", nullable=false, length=25)
    private String codigo;
    @Column(name="nombre_producto", length=250)
    private String nombreProducto;
    @Column(name="precio_unitario", precision=10, scale=3)
    private BigDecimal precioUnitario;
    @Column(name="informacion_adicional", length=500)
    private String informacionAdicional;
    @ManyToOne
    @JoinColumn(name="id_tarifa_iva")
    private TTarifaIva idTarifaIva;
    @ManyToOne
    @JoinColumn(name="id_codigo_ice")
    private TCodigosIce idCodigoIce;
    @ManyToOne
    @JoinColumn(name="id_unidad_medida")
    private TUnidadMedida unidadMedida;
    @ManyToOne
    @JoinColumn(name="id_marca")
    private TMarca marca;
    @ManyToOne
    @JoinColumn(name="id_tipo_producto")
    private TTipoProducto tipoProducto;
    @ManyToOne
    @JoinColumn(name="id_cliente")
    private TCliente cliente;
    @Column(name="created_at")
    private Date cratedAt;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="activo")
    private Boolean activo;
    @Column(name="marketplace")
    private Boolean marketplace;
    @Column(name="stock")
    private BigDecimal stock;
    @Column(name="costo_compra")
    private BigDecimal costoCompra;
    @Column(name="inventariable")
    private Boolean inventariable;
    @Column(name="stock_minimo", columnDefinition="NUMERIC DEFAULT 0")
    private BigDecimal stockMinimo;
    @Column(name="stock_maximo", columnDefinition="NUMERIC DEFAULT 0")
    private BigDecimal stockMaximo;

    public TProducto(Long id) {
        this.id = new BigDecimal(id);
    }

    public BigDecimal getPrecioUnitario() {
        this.precioUnitario = this.precioUnitario == null ? new BigDecimal("0.00") : this.precioUnitario;
        return this.precioUnitario;
    }

    public Boolean getMarketplace() {
        this.marketplace = this.marketplace == null ? false : this.marketplace;
        return this.marketplace;
    }

    public Boolean getActivo() {
        this.activo = this.activo == null ? false : this.activo;
        return this.activo;
    }

    public BigDecimal getStock() {
        this.stock = this.stock == null ? new BigDecimal("0.00") : this.stock;
        return this.stock;
    }

    public BigDecimal getCostoCompra() {
        this.costoCompra = this.costoCompra == null ? new BigDecimal("0.00") : this.costoCompra;
        return this.costoCompra;
    }

    public Boolean getInventariable() {
        this.inventariable = this.inventariable == null ? false : this.inventariable;
        return this.inventariable;
    }

    public BigDecimal getStockMinimo() {
        this.stockMinimo = this.stockMinimo == null ? BigDecimal.ZERO : this.stockMinimo;
        return this.stockMinimo;
    }

    public BigDecimal getStockMaximo() {
        this.stockMaximo = this.stockMaximo == null ? BigDecimal.ZERO : this.stockMaximo;
        return this.stockMaximo;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNombreProducto() {
        return this.nombreProducto;
    }

    public String getInformacionAdicional() {
        return this.informacionAdicional;
    }

    public TTarifaIva getIdTarifaIva() {
        return this.idTarifaIva;
    }

    public TCodigosIce getIdCodigoIce() {
        return this.idCodigoIce;
    }

    public TUnidadMedida getUnidadMedida() {
        return this.unidadMedida;
    }

    public TMarca getMarca() {
        return this.marca;
    }

    public TTipoProducto getTipoProducto() {
        return this.tipoProducto;
    }

    public TCliente getCliente() {
        return this.cliente;
    }

    public Date getCratedAt() {
        return this.cratedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setNombreProducto(String nombreProducto) {
        this.nombreProducto = nombreProducto;
    }

    public void setPrecioUnitario(BigDecimal precioUnitario) {
        this.precioUnitario = precioUnitario;
    }

    public void setInformacionAdicional(String informacionAdicional) {
        this.informacionAdicional = informacionAdicional;
    }

    public void setIdTarifaIva(TTarifaIva idTarifaIva) {
        this.idTarifaIva = idTarifaIva;
    }

    public void setIdCodigoIce(TCodigosIce idCodigoIce) {
        this.idCodigoIce = idCodigoIce;
    }

    public void setUnidadMedida(TUnidadMedida unidadMedida) {
        this.unidadMedida = unidadMedida;
    }

    public void setMarca(TMarca marca) {
        this.marca = marca;
    }

    public void setTipoProducto(TTipoProducto tipoProducto) {
        this.tipoProducto = tipoProducto;
    }

    public void setCliente(TCliente cliente) {
        this.cliente = cliente;
    }

    public void setCratedAt(Date cratedAt) {
        this.cratedAt = cratedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    public void setMarketplace(Boolean marketplace) {
        this.marketplace = marketplace;
    }

    public void setStock(BigDecimal stock) {
        this.stock = stock;
    }

    public void setCostoCompra(BigDecimal costoCompra) {
        this.costoCompra = costoCompra;
    }

    public void setInventariable(Boolean inventariable) {
        this.inventariable = inventariable;
    }

    public void setStockMinimo(BigDecimal stockMinimo) {
        this.stockMinimo = stockMinimo;
    }

    public void setStockMaximo(BigDecimal stockMaximo) {
        this.stockMaximo = stockMaximo;
    }

    public TProducto() {
    }

    public TProducto(BigDecimal id, String codigo, String nombreProducto, BigDecimal precioUnitario, String informacionAdicional, TTarifaIva idTarifaIva, TCodigosIce idCodigoIce, TUnidadMedida unidadMedida, TMarca marca, TTipoProducto tipoProducto, TCliente cliente, Date cratedAt, Date updatedAt, Boolean activo, Boolean marketplace, BigDecimal stock, BigDecimal costoCompra, Boolean inventariable, BigDecimal stockMinimo, BigDecimal stockMaximo) {
        this.id = id;
        this.codigo = codigo;
        this.nombreProducto = nombreProducto;
        this.precioUnitario = precioUnitario;
        this.informacionAdicional = informacionAdicional;
        this.idTarifaIva = idTarifaIva;
        this.idCodigoIce = idCodigoIce;
        this.unidadMedida = unidadMedida;
        this.marca = marca;
        this.tipoProducto = tipoProducto;
        this.cliente = cliente;
        this.cratedAt = cratedAt;
        this.updatedAt = updatedAt;
        this.activo = activo;
        this.marketplace = marketplace;
        this.stock = stock;
        this.costoCompra = costoCompra;
        this.inventariable = inventariable;
        this.stockMinimo = stockMinimo;
        this.stockMaximo = stockMaximo;
    }
}

