/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.models.entities.cliente;

import ec.tws2.back.contfiables.core.util.utils;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name="t_historial_pago")
public class THistoriaPago {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_historial_pago", nullable=false)
    private Long idHistoriaPago;
    @Column(name="create_at")
    private LocalDateTime createAT;
    @ManyToOne
    @JoinColumn(name="id_cliente")
    private TCliente cliente;
    @Column(name="facturas_emitidas")
    private Long facturasEmitidas;
    @Column(name="fecha_inicio")
    private LocalDateTime fechaInicio;
    @Column(name="fecha_final")
    private LocalDateTime fechaFinal;
    @Column(name="valor_pago", precision=12, scale=2)
    private BigDecimal valorPago;
    @Column(name="activo")
    private Boolean activo;

    public THistoriaPago(Long idHistoriaPago) {
        this.idHistoriaPago = idHistoriaPago;
    }

    public THistoriaPago(TCliente cliente, Long facturasEmitidas, LocalDateTime fechaInicio, LocalDateTime fechaFinal, BigDecimal valorPago) {
        this.cliente = cliente;
        this.facturasEmitidas = facturasEmitidas;
        this.fechaInicio = fechaInicio;
        this.fechaFinal = fechaFinal;
        this.valorPago = valorPago;
        this.createAT = utils.getLocalDateNow();
        this.activo = true;
    }

    public Long getIdHistoriaPago() {
        return this.idHistoriaPago;
    }

    public LocalDateTime getCreateAT() {
        return this.createAT;
    }

    public TCliente getCliente() {
        return this.cliente;
    }

    public Long getFacturasEmitidas() {
        return this.facturasEmitidas;
    }

    public LocalDateTime getFechaInicio() {
        return this.fechaInicio;
    }

    public LocalDateTime getFechaFinal() {
        return this.fechaFinal;
    }

    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    public Boolean getActivo() {
        return this.activo;
    }

    public void setIdHistoriaPago(Long idHistoriaPago) {
        this.idHistoriaPago = idHistoriaPago;
    }

    public void setCreateAT(LocalDateTime createAT) {
        this.createAT = createAT;
    }

    public void setCliente(TCliente cliente) {
        this.cliente = cliente;
    }

    public void setFacturasEmitidas(Long facturasEmitidas) {
        this.facturasEmitidas = facturasEmitidas;
    }

    public void setFechaInicio(LocalDateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    public void setFechaFinal(LocalDateTime fechaFinal) {
        this.fechaFinal = fechaFinal;
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    public THistoriaPago() {
    }

    public THistoriaPago(Long idHistoriaPago, LocalDateTime createAT, TCliente cliente, Long facturasEmitidas, LocalDateTime fechaInicio, LocalDateTime fechaFinal, BigDecimal valorPago, Boolean activo) {
        this.idHistoriaPago = idHistoriaPago;
        this.createAT = createAT;
        this.cliente = cliente;
        this.facturasEmitidas = facturasEmitidas;
        this.fechaInicio = fechaInicio;
        this.fechaFinal = fechaFinal;
        this.valorPago = valorPago;
        this.activo = activo;
    }
}

