/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.filter;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TSuscripcionContfiables;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.services.SuscripcionContfiablesService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@WebFilter(value={"/*"})
@Component
public class ClienteFilter
implements Filter {
    Logger log = Logger.getLogger(ClienteFilter.class.getName());
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private SuscripcionContfiablesService suscripcionService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String username;
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            this.log.info("Method: " + httpRequest.getMethod() + " -> " + httpRequest.getRequestURI());
            httpResponse.setHeader("Access-Control-Allow-Origin", "http://localhost:3000");
            httpResponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            httpResponse.setHeader("Access-Control-Max-Age", "3600");
            httpResponse.setHeader("Access-Control-Allow-Headers", "x-requested-with, authorization, Content-Type, Authorization, credential, X-XSRF-TOKEN");
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            if ("OPTIONS".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(200);
                return;
            }
        }
        catch (Exception e) {
            this.log.warning("ERROR AL MAPEAR LA RUTA SOLICITADA");
        }
        String idCliente = request.getParameter("idCliente");
        RespSimple respSimple = new RespSimple();
        respSimple.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
        if (idCliente == null) {
            chain.doFilter(request, response);
            return;
        }
        this.log.info("solicitud del cliente: " + idCliente);
        if (idCliente.equals("")) {
            respSimple.setMensaje("Error en la identificaci\u00f3n del cliente.");
            this.procesarRespuestaClienteSuscripcionTerminada(respSimple, response);
        }
        if ((username = this.clienteDAO.getUsernameByIdCliente(Long.valueOf(Long.parseLong(idCliente)))) == null) {
            respSimple.setMensaje("Error el cliente no existe.");
            this.log.warning("BLOCKED: " + respSimple.getMensaje());
            this.procesarRespuestaClienteSuscripcionTerminada(respSimple, response);
            return;
        }
        RespSimple respuestaSuscripcion = (RespSimple)this.suscripcionService.validarSuscripcionCliente(username).getBody();
        if (respuestaSuscripcion == null || respuestaSuscripcion.getData() == null) {
            respSimple.setMensaje("Error el cliente no cuenta con una suscripci\u00f3n existente.");
            this.log.warning("BLOCKED: " + respSimple.getMensaje());
            this.procesarRespuestaClienteSuscripcionTerminada(respSimple, response);
            return;
        }
        TSuscripcionContfiables suscripcion = (TSuscripcionContfiables)respuestaSuscripcion.getData();
        if (suscripcion != null && !suscripcion.getActivo().booleanValue()) {
            respSimple.setMensaje("No cuentas con una sucripci\u00f3n activa.");
            this.log.warning("BLOCKED: " + respSimple.getMensaje());
            this.procesarRespuestaClienteSuscripcionTerminada(respSimple, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void procesarRespuestaClienteSuscripcionTerminada(RespSimple respSimple, ServletResponse response) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.getWriter().write(respSimple.toString());
        httpServletResponse.setStatus(400);
    }
}

