/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.core.validations;

import ec.tws2.back.contfiables.core.exceptions.CustomException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class RegexValidations {
    public boolean validateInput(String input, String campo) {
        if (this.isURL(input)) {
            throw new CustomException("El campo '" + campo + "' contiene un enlace, por favor cambiar el valor");
        }
        if (this.containsEmojis(input)) {
            throw new CustomException("El campo '" + campo + "' contiene emojis o gr\u00e1ficos, por favor cambiar el valor");
        }
        return true;
    }

    public boolean isURL(String texto) {
        try {
            String regex = "^(http://www\\.|https://www\\.|http://|https://)?[a-z0-9]+([\\-\\.]{1}[a-z0-9]+)*\\.[a-z]{2,5}(:[0-9]{1,5})?(/.*)?$";
            Pattern pattern = Pattern.compile(regex, 2);
            Matcher matcher = pattern.matcher(texto);
            return matcher.find();
        }
        catch (Exception e) {
            throw new CustomException("Error al validar el texto: " + texto);
        }
    }

    public boolean containsEmojis(String texto) {
        try {
            String regex = "[\\p{C}\\p{Zl}\\p{Zp}]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(texto);
            return matcher.find();
        }
        catch (Exception e) {
            throw new CustomException("Error al validar el texto: " + texto);
        }
    }
}

