/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.core.validations;

import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import org.springframework.stereotype.Service;

@Service
public class IdentificationValidator {
    public RespSimple validarIdentificacion(String codigoSRI, String identificacion) {
        RespSimple response = new RespSimple();
        switch (codigoSRI) {
            case "04": {
                response = this.validarRUC(identificacion);
                if (response.getCodigo().equals("0")) {
                    return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
                }
                throw new CustomExceptionNoCleanData(response.getMensaje());
            }
            case "05": {
                if (this.validarCedulaEcuatoriana(identificacion)) {
                    return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
                }
                throw new CustomExceptionNoCleanData("Identificaci\u00f3n no v\u00e1lida como c\u00e9dula Ecuatoriana.");
            }
            case "06": {
                return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
            }
            case "07": {
                if (identificacion.equals("9999999999999")) {
                    return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
                }
                throw new CustomExceptionNoCleanData("El tipo de identificaci\u00f3n 'Consumidor final' no correponde con el n\u00famero ingresado.");
            }
            case "08": {
                return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
            }
            case "09": {
                return new RespSimple(ContfiablesEnum.TRANSACCION_OK.getId(), "Identificaci\u00f3n v\u00e1lida.");
            }
        }
        throw new CustomExceptionNoCleanData("El c\u00f3digo del tipo de identificaci\u00f3n del SRI no es correcto.");
    }

    public boolean validarCedulaEcuatoriana(String identificacion) {
        if (identificacion == null || identificacion.length() != 10 || !identificacion.matches("\\d{10}")) {
            return false;
        }
        int digitoVerificador = Integer.parseInt(identificacion.substring(9));
        int suma = 0;
        int[] coeficientes = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};
        for (int i = 0; i < 9; ++i) {
            int digito = Integer.parseInt(identificacion.substring(i, i + 1));
            int producto = digito * coeficientes[i];
            if (producto > 9) {
                producto -= 9;
            }
            suma += producto;
        }
        int digitoVerificadorEsperado = 10 - suma % 10;
        if (digitoVerificadorEsperado == 10) {
            digitoVerificadorEsperado = 0;
        }
        return digitoVerificador == digitoVerificadorEsperado;
    }

    public RespSimple validarRUC(String number) {
        RespSimple response;
        block11: {
            response = new RespSimple();
            int dto = number.length();
            int acu = 0;
            try {
                if (number.equals("")) {
                    response.setCodigo("1");
                    response.setMensaje("No has ingresado ning\u00fan dato, por favor ingresar los datos correspondientes.");
                    return response;
                }
                if (number.length() != 13) {
                    return new RespSimple(ContfiablesEnum.TRANSACCION_ERROR_BUT_NOTCLEAN_FRONT.getId(), "La identificaci\u00f3n no tiene los d\u00edgitos requeridos para ser un RUC");
                }
                for (int i = 0; i < dto; ++i) {
                    int valor = Integer.parseInt(number.substring(i, i + 1));
                    if (valor != 0 && valor != 1 && valor != 2 && valor != 3 && valor != 4 && valor != 5 && valor != 6 && valor != 7 && valor != 8 && valor != 9) continue;
                    ++acu;
                }
                if (acu == dto) {
                    if (!number.substring(10, 13).equals("001")) {
                        response.setCodigo("1");
                        response.setMensaje("Los tres \u00faltimos d\u00edgitos no tienen el c\u00f3digo del RUC 001.");
                        return response;
                    }
                    if (Integer.parseInt(number.substring(0, 2)) > 24) {
                        response.setCodigo("1");
                        response.setMensaje("Los dos primeros d\u00edgitos no pueden ser mayores a 24.");
                        return response;
                    }
                    int porcion1 = Integer.parseInt(number.substring(2, 3));
                    if (porcion1 < 6) {
                        response.setCodigo("0");
                        response.setMensaje("El RUC pertenece a una persona natural");
                        return response;
                    }
                    if (porcion1 == 6) {
                        response.setCodigo("0");
                        response.setMensaje("El RUC pertenece a una entidad p\u00fablica.");
                        return response;
                    }
                    if (porcion1 == 9) {
                        response.setCodigo("0");
                        response.setMensaje("El RUC pertenece a una sociedad privada.");
                        return response;
                    }
                    break block11;
                }
                response.setCodigo("1");
                response.setMensaje("ERROR: Por favor no ingrese texto");
                return response;
            }
            catch (Exception e) {
                response.setCodigo("1");
                response.setMensaje("Error al validar el RUC");
                return response;
            }
        }
        response.setCodigo("1");
        response.setMensaje("Error al validar el RUC");
        return response;
    }
}

