/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.core.validations;

import ec.tws2.back.contfiables.core.exceptions.CustomExceptionNoCleanData;
import ec.tws2.back.contfiables.models.domain.DatosFactura;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TAdquiriente;
import ec.tws2.back.contfiables.models.entities.cliente.TTipoAdquiriente;
import ec.tws2.back.contfiables.models.entities.cliente.TTipoIdentificacion;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TAdquirenteDAO;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.repositories.cliente.TTipoAdquirienteDAO;
import ec.tws2.back.contfiables.repositories.integracion.TPuntoVentaDAO;
import ec.tws2.back.contfiables.repositories.inventario.TBodegaDAO;
import ec.tws2.back.contfiables.services.AdquirienteService;
import ec.tws2.back.contfiables.services.SuscripcionContfiablesService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FacturaValidationsService {
    @Autowired
    private TClienteDAO clienteDAO;
    @Autowired
    private TBodegaDAO bodegaDAO;
    @Autowired
    private SuscripcionContfiablesService suscripcionService;
    @Autowired
    private TPuntoVentaDAO puntoVentaDAO;
    @Autowired
    private AdquirienteService adquirienteService;
    @Autowired
    private TAdquirenteDAO tAdquirenteDAO;
    @Autowired
    private TTipoAdquirienteDAO tTipoAdquirienteDAO;

    public Boolean validarParametrosYsuscripcion(DatosFactura datosFacturas) {
        String username = this.clienteDAO.getUsernameByIdentificacion(datosFacturas.getRuc());
        if (username == null) {
            throw new CustomExceptionNoCleanData("No existe un contribuyente con esa identificaci\u00f3n");
        }
        ResponseEntity respValidar = this.suscripcionService.validarSuscripcionCliente(username);
        RespSimple validarSuscripcion = (RespSimple)respValidar.getBody();
        if (validarSuscripcion == null || validarSuscripcion.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
            throw new CustomExceptionNoCleanData(validarSuscripcion != null ? validarSuscripcion.getMensaje() : "Error al validar suscripci\u00f3n");
        }
        ResponseEntity respActualizar = this.suscripcionService.actualizarSecuenciaSuscripcion(username);
        RespSimple sumarSecuenciaSuscripcion = (RespSimple)respActualizar.getBody();
        if (sumarSecuenciaSuscripcion == null || sumarSecuenciaSuscripcion.getCodigo().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
            throw new CustomExceptionNoCleanData(sumarSecuenciaSuscripcion != null ? sumarSecuenciaSuscripcion.getMensaje() : "Error al actualizar secuencia de suscripci\u00f3n");
        }
        if (datosFacturas.getIdBodega() == null || datosFacturas.getIdBodega() == 0L) {
            throw new CustomExceptionNoCleanData("Error al generar factura, la bodega es requerida");
        }
        if (datosFacturas.getIdPuntoVenta() == null || datosFacturas.getIdPuntoVenta() == 0L) {
            throw new CustomExceptionNoCleanData("Error al generar la factura, el punto de venta es requerido");
        }
        Boolean bodega = this.bodegaDAO.existsByIdBodega(datosFacturas.getIdBodega());
        Boolean puntoEmision = this.puntoVentaDAO.existsByIdPuntoVenta(datosFacturas.getIdPuntoVenta());
        if (!bodega.booleanValue()) {
            throw new CustomExceptionNoCleanData("Error al generar factura, la bodega seleccionada no existe");
        }
        if (!puntoEmision.booleanValue()) {
            throw new CustomExceptionNoCleanData("Error al generar factura, el punto de venta seleccionado no existe");
        }
        return true;
    }

    public TAdquiriente validarAdquiriente(DatosFactura datosFacturas, TTipoIdentificacion tipoIdentificacion) {
        try {
            if (this.adquirienteService.existeAdquiriente(datosFacturas.getIdentificacionComprador()).booleanValue()) {
                TAdquiriente t_Adquiriente = (TAdquiriente)this.tAdquirenteDAO.findByIdentificacion(datosFacturas.getIdentificacionComprador()).get();
                if (!t_Adquiriente.getIdentificacion().equals("9999999999999")) {
                    t_Adquiriente.setIdentificacion(datosFacturas.getIdentificacionComprador());
                    t_Adquiriente.setRazonSocial(datosFacturas.getRazonSocialComprador());
                    t_Adquiriente.setDireccion(datosFacturas.getDireccionComprador());
                    t_Adquiriente.setTelefono(datosFacturas.getTelefonoComprador());
                    t_Adquiriente.setEmailAdquiriente(datosFacturas.getEmailComprador());
                    t_Adquiriente.setIdTipoIdentificacion(tipoIdentificacion);
                    t_Adquiriente.setDescuento(0);
                    return (TAdquiriente)this.tAdquirenteDAO.save((Object)t_Adquiriente);
                }
                return t_Adquiriente;
            }
            TAdquiriente t_Adquiriente = new TAdquiriente();
            TTipoAdquiriente t_TipoAdquiriente = (TTipoAdquiriente)this.tTipoAdquirienteDAO.findById((Object)new BigDecimal("1")).get();
            t_Adquiriente.setIdTipoIdentificacion(tipoIdentificacion);
            t_Adquiriente.setIdentificacion(datosFacturas.getIdentificacionComprador());
            t_Adquiriente.setRazonSocial(datosFacturas.getRazonSocialComprador());
            t_Adquiriente.setDireccion(datosFacturas.getDireccionComprador());
            t_Adquiriente.setTelefono(datosFacturas.getTelefonoComprador());
            t_Adquiriente.setEmailAdquiriente(datosFacturas.getEmailComprador());
            t_Adquiriente.setDescuento(0);
            t_Adquiriente.setIdTipoAdquiriente(t_TipoAdquiriente);
            return (TAdquiriente)this.tAdquirenteDAO.save((Object)t_Adquiriente);
        }
        catch (Exception e) {
            throw new CustomExceptionNoCleanData("Error al registrar el nuevo adquiriente de la factura");
        }
    }
}

