/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.core.util;

import ec.tws2.back.contfiables.core.security.Seguridad;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.annotation.PostConstruct;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EnvioCorreo {
    private static final Logger log = Logger.getLogger(EnvioCorreo.class.getName());
    Properties props = System.getProperties();
    @Autowired
    private Seguridad seguridad;
    private InternetAddress[] direccionTo;
    private InternetAddress[] direccionTo1;
    @Value(value="${property.email.server}")
    String server;
    @Value(value="${property.email.trasport}")
    String trasport;
    @Value(value="${property.email.port}")
    String port;
    @Value(value="${property.email.usuario}")
    String usuario;
    @Value(value="${property.email.clave}")
    String clave;
    String correoDesde = "info@contfiables.com";

    @PostConstruct
    public void init() throws Exception {
        this.props.put("mail.smtp.host", this.server);
        this.props.put("mail.smtp.port", this.port);
        this.props.put("mail.smtp.user", this.seguridad.decrypt(this.usuario));
        this.props.put("mail.smtp.auth", "true");
    }

    public boolean fnConectaCorreo() throws Exception {
        boolean ban = false;
        Session sesion = Session.getDefaultInstance((Properties)this.props);
        sesion.setDebug(true);
        try {
            Transport t = sesion.getTransport(this.trasport);
            t.connect(this.server, this.seguridad.decrypt(this.usuario), this.seguridad.decrypt(this.clave));
            ban = true;
            t.close();
        }
        catch (NoSuchProviderException ex) {
            ban = false;
            log.severe("Error Provider: al enviar Correo: " + ex.getMessage());
        }
        catch (MessagingException ex) {
            ban = false;
            log.severe("Error Mensaje: al enviar Correo: " + ex.getMessage());
        }
        return ban;
    }

    public void fnNotificar(String sCorreo, String sCC, String sTitulo, String sCuerpo, String sAdjunto) throws Exception {
        if (this.fnConectaCorreo()) {
            Session sesion = Session.getDefaultInstance((Properties)this.props);
            sesion.setDebug(true);
            try {
                this.setTo(sCC);
                this.setTo1(sCorreo);
                MimeMessage mensaje = new MimeMessage(sesion);
                mensaje.setSubject(sTitulo);
                mensaje.setFrom((Address)new InternetAddress(this.correoDesde));
                mensaje.setRecipients(Message.RecipientType.TO, (Address[])this.direccionTo1);
                mensaje.addRecipients(Message.RecipientType.BCC, (Address[])this.direccionTo);
                MimeBodyPart texto = new MimeBodyPart();
                texto.setContent((Object)sCuerpo, "text/html");
                MimeBodyPart adjunto = new MimeBodyPart();
                adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(sAdjunto)));
                String nombre = "";
                nombre = sAdjunto.substring(sAdjunto.lastIndexOf(47) + 1, sAdjunto.lastIndexOf(102));
                adjunto.setFileName(nombre);
                MimeMultipart multiParte = new MimeMultipart();
                multiParte.addBodyPart((BodyPart)texto);
                multiParte.addBodyPart((BodyPart)adjunto);
                mensaje.setContent((Multipart)multiParte);
                Transport t = sesion.getTransport(this.trasport);
                t.connect(this.server, this.seguridad.decrypt(this.usuario), this.seguridad.decrypt(this.clave));
                t.sendMessage((Message)mensaje, mensaje.getAllRecipients());
                t.close();
                log.info("Se ha enviado una notificacion al Correo Electronico");
            }
            catch (MessagingException e) {
                log.severe("Error Cuerpo: al enviar Correo: " + e.getMessage());
            }
        }
    }

    public void fnNotificarSA(String sCorreo, String sCC, String sTitulo, String sCuerpo) throws Exception {
        if (this.fnConectaCorreo()) {
            Session sesion = Session.getDefaultInstance((Properties)this.props);
            sesion.setDebug(true);
            try {
                this.setTo(sCC);
                this.setTo1(sCorreo);
                MimeMessage mensaje = new MimeMessage(sesion);
                mensaje.setSubject(sTitulo);
                mensaje.setFrom((Address)new InternetAddress(this.correoDesde));
                mensaje.setRecipients(Message.RecipientType.TO, (Address[])this.direccionTo1);
                mensaje.addRecipients(Message.RecipientType.BCC, (Address[])this.direccionTo);
                MimeBodyPart texto = new MimeBodyPart();
                texto.setText(sCuerpo);
                MimeMultipart multiParte = new MimeMultipart();
                multiParte.addBodyPart((BodyPart)texto);
                mensaje.setContent((Multipart)multiParte);
                Transport t = sesion.getTransport(this.trasport);
                t.connect(this.server, this.seguridad.decrypt(this.usuario), this.seguridad.decrypt(this.clave));
                t.sendMessage((Message)mensaje, mensaje.getAllRecipients());
                t.close();
                log.info("Se ha enviado una notificacion al Correo Electronico");
            }
            catch (MessagingException e) {
                log.severe("Error Cuerpo: al enviar Correo: " + e.getMessage());
            }
        }
    }

    public void fnNotificarContfiables(String sCorreo, String correoDesd, String sTitulo, String sCuerpo) throws Exception {
        if (this.fnConectaCorreo()) {
            Session sesion = Session.getDefaultInstance((Properties)this.props);
            sesion.setDebug(true);
            try {
                this.setTo1(sCorreo);
                MimeMessage mensaje = new MimeMessage(sesion);
                mensaje.setSubject(sTitulo);
                mensaje.setFrom((Address)new InternetAddress(correoDesd));
                mensaje.setRecipients(Message.RecipientType.TO, (Address[])this.direccionTo1);
                mensaje.addRecipients(Message.RecipientType.BCC, (Address[])this.direccionTo);
                MimeBodyPart texto = new MimeBodyPart();
                texto.setText(sCuerpo);
                MimeMultipart multiParte = new MimeMultipart();
                multiParte.addBodyPart((BodyPart)texto);
                mensaje.setContent((Multipart)multiParte);
                Transport t = sesion.getTransport(this.trasport);
                t.connect(this.server, this.seguridad.decrypt(this.usuario), this.seguridad.decrypt(this.clave));
                t.sendMessage((Message)mensaje, mensaje.getAllRecipients());
                t.close();
                log.info("Se ha enviado una notificacion al Correo Electronico");
            }
            catch (MessagingException e) {
                log.severe("Error Cuerpo: al enviar Correo: " + e.getMessage());
            }
        }
    }

    public void fnNotificar(String sCorreo, String sTitulo, String sCuerpo, String sAdjunto) throws Exception {
        if (this.fnConectaCorreo()) {
            Session sesion = Session.getDefaultInstance((Properties)this.props);
            sesion.setDebug(true);
            try {
                this.setTo1(sCorreo);
                MimeMessage mensaje = new MimeMessage(sesion);
                mensaje.setSubject(sTitulo);
                mensaje.setFrom((Address)new InternetAddress(this.correoDesde));
                mensaje.setRecipients(Message.RecipientType.TO, (Address[])this.direccionTo1);
                MimeBodyPart texto = new MimeBodyPart();
                texto.setText(sCuerpo);
                MimeBodyPart adjunto = new MimeBodyPart();
                adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(sAdjunto)));
                String nombre = "";
                nombre = sAdjunto.substring(sAdjunto.lastIndexOf(47) + 1);
                adjunto.setFileName(nombre);
                MimeMultipart multiParte = new MimeMultipart();
                multiParte.addBodyPart((BodyPart)texto);
                multiParte.addBodyPart((BodyPart)adjunto);
                mensaje.setContent((Multipart)multiParte);
                Transport t = sesion.getTransport(this.trasport);
                t.connect(this.server, this.seguridad.decrypt(this.usuario), this.seguridad.decrypt(this.clave));
                t.sendMessage((Message)mensaje, mensaje.getAllRecipients());
                t.close();
                log.info("Se ha enviado una notificacion al Correo Electronico");
            }
            catch (MessagingException e) {
                log.severe("Error Cuerpo: al enviar Correo: " + e.getMessage());
            }
        }
    }

    public void setTo(String mails) {
        String[] tmp = mails.split(",");
        this.direccionTo = new InternetAddress[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            try {
                this.direccionTo[i] = new InternetAddress(tmp[i]);
                continue;
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
    }

    public void setTo1(String mails) {
        if (mails != null) {
            String[] tmp = mails.split(",");
            this.direccionTo1 = new InternetAddress[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                try {
                    this.direccionTo1[i] = new InternetAddress(tmp[i]);
                    continue;
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
        }
    }
}

