/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.domain.TipoProductoCuentaContableModel;
import ec.tws2.back.contfiables.models.entities.inventario.TTipoProducto;
import ec.tws2.back.contfiables.services.TipoProductoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tipoProducto/"})
public class TipoProductoController {
    @Autowired
    TipoProductoService tipoProductoService;

    @PostMapping(value={"getTipoProducto"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerListaTiposProducto(@RequestParam(value="idCliente") Long idCliente) {
        return this.tipoProductoService.obtenerListaTipoProducto(idCliente);
    }

    @PostMapping(value={"getTipoProductoById"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerTipoProductoById(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="idTipoProducto") Long idTipoProducto) {
        return this.tipoProductoService.obtenerTipoProductoById(idCliente, idTipoProducto);
    }

    @PostMapping(value={"guardarTipoProducto"}, produces={"application/json"})
    public ResponseEntity<RespSimple> guardarTipoProducto(@RequestBody TipoProductoCuentaContableModel tipoProductoModel) {
        return this.tipoProductoService.guardarTipoProducto(tipoProductoModel);
    }

    @PostMapping(value={"actualizarTipoProducto"}, produces={"application/json"})
    public ResponseEntity<RespSimple> actualizarTipoProducto(@RequestBody TTipoProducto tipoProducto) {
        return this.tipoProductoService.actualizarTipoProducto(tipoProducto);
    }

    @PostMapping(value={"getDetCtaCont4TipoProd"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getDetCtaCont4TipoProd(@RequestParam Long idTipoProducto) {
        return this.tipoProductoService.getDetCtaCont4TipoProd(idTipoProducto);
    }

    @PostMapping(value={"getTipoProductoActive"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getTipoProductoActive(@RequestParam Long idCliente, @RequestParam Boolean activo) {
        return this.tipoProductoService.getTipoProductoActive(idCliente, activo);
    }
}

