/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.PagoSuscripcionModel;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.services.SuscripcionContfiablesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"suscripcion/"})
public class SuscripcionContfiablesController {
    @Autowired
    private SuscripcionContfiablesService suscripcionService;

    @PostMapping(value={"getClienteSuscripcion"})
    public ResponseEntity<RespSimple> getSuscripcion(@RequestParam String usuario) {
        return this.suscripcionService.validarSuscripcionCliente(usuario);
    }

    @PostMapping(value={"renovarSuscripcion"})
    public ResponseEntity<RespSimple> getRenovarSuscripcion(@RequestBody PagoSuscripcionModel pagoModel) {
        return this.suscripcionService.renovarSuscripcion(pagoModel);
    }

    @PostMapping(value={"alertaSuscripcion"})
    public ResponseEntity<RespSimple> getAlertaSuscripcionContfiables(@RequestParam Long idCliente) {
        return this.suscripcionService.getAlertaSuscripcionContfiables(idCliente);
    }

    @PostMapping(value={"getInformeSuscripcion"})
    public ResponseEntity<RespSimple> getInformeSuscripcion() {
        return this.suscripcionService.getInformeSuscripcion();
    }

    @PostMapping(value={"getContados"})
    public ResponseEntity<RespSimple> getContadosSus() {
        return this.suscripcionService.getContadosSus();
    }
}

