/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.proveedor.TProveedor;
import ec.tws2.back.contfiables.services.FormaPagoService;
import ec.tws2.back.contfiables.services.ProveedorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"proveedor/"})
public class ProveedorController {
    @Autowired
    private ProveedorService proveedorService;
    @Autowired
    private FormaPagoService formaPagoService;

    @PostMapping(value={"getTipoIdentificacionProveedores"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerListaTipoIdentificacionProveedores() {
        return this.proveedorService.obtenerTiposIdentificacion();
    }

    @PostMapping(value={"getProveedores"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerListaProveedores(@RequestParam(value="idCliente") Long idCliente) {
        return this.proveedorService.obtenerListaProveedores(idCliente);
    }

    @PostMapping(value={"getProveedoresActivos"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerListaProveedoresActivos(@RequestParam(value="idCliente") Long idCliente) {
        return this.proveedorService.obtenerListaProveedoresActivos(idCliente);
    }

    @PostMapping(value={"registrarProveedor"}, produces={"application/json"})
    public ResponseEntity<RespSimple> registrarProveedor(@RequestBody TProveedor Prov) {
        return this.proveedorService.registrarProveedor(Prov);
    }

    @PostMapping(value={"actualizarProveedor"}, produces={"application/json"})
    public ResponseEntity<RespSimple> actualizarProveedor(@RequestBody TProveedor Prov) {
        return this.proveedorService.actualizarProveedor(Prov);
    }

    @PostMapping(value={"getProveedorById"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getProveedorById(@RequestParam Long idCliente, @RequestParam Long idProveedor) {
        return this.proveedorService.obtenerProveedorById(idCliente, idProveedor);
    }

    @PostMapping(value={"getFormasPagoProveedor"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getFormasPagoProveedor() {
        return this.formaPagoService.obtenerFormasPago();
    }
}

