/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.core.util.ObtenerErrores;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.ProductModelDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoFacturaMovilDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoInvenFacturacionDTO;
import ec.tws2.back.contfiables.models.dtos.ProductoMovilDTO;
import ec.tws2.back.contfiables.models.entities.facturacion.TTarifaIva;
import ec.tws2.back.contfiables.models.entities.inventario.TInventario;
import ec.tws2.back.contfiables.models.entities.inventario.TProducto;
import ec.tws2.back.contfiables.services.ProductoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"productos"})
public class ProductosController {
    @Autowired
    ProductoService productosService;
    @Autowired
    ObtenerErrores obtenerErrores;

    @PostMapping(path={"/obtenerProductosFacturacionMovil"}, produces={"application/json"})
    public List<ProductoFacturaMovilDTO> obtenerProductosMovil(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="idProducto") String idProducto) {
        return this.productosService.obtenerProductosFacturacionMovil(idCliente, idProducto);
    }

    @PostMapping(value={"getProductoByCode"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getProductoByCode(@RequestParam(value="codigo") String codigo, @RequestParam(value="idCliente") Long idCliente, @RequestParam(value="idBodega") Long idBodega) {
        return this.productosService.getProductoByCode(codigo, idBodega, idCliente);
    }

    @PostMapping(path={"/productsNoInventariableList"}, produces={"application/json"})
    public List<TProducto> obtenerProductos(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="idProducto") String idProducto) {
        return this.productosService.obtenerProductosAPIMOVILV1(idCliente, idProducto);
    }

    @PostMapping(path={"/productsNoInventariableListDTO"}, produces={"application/json"})
    public List<ProductoMovilDTO> productsNoInventariableListDTO(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="idProducto") String idProducto) {
        return this.productosService.obtenerProductosAPIMOVILV2(idCliente, idProducto);
    }

    @PostMapping(path={"/getProductDTO"})
    public ResponseEntity<RespSimple> getProductDTO(@RequestParam(value="idProducto") Long idProducto) {
        return this.productosService.getProductDTO(idProducto);
    }

    @PostMapping(path={"/listprod"}, produces={"application/json"})
    public List<TProducto> obtenerProductosFront(@RequestParam(value="idCliente") Long idCliente) {
        return this.productosService.obtenerProductosFront(idCliente);
    }

    @PostMapping(path={"/listprodDTO"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerProductosDTOFront(@RequestParam(value="idCliente") Long idCliente) {
        return this.productosService.obtenerProductosDTOFront(idCliente);
    }

    @PostMapping(value={"/completarRegistroWEB"})
    public ResponseEntity<RespSimple> guardarProducto(@RequestBody TProducto producto) {
        ResponseEntity resp = this.productosService.guardarProductoCliente(producto);
        return resp;
    }

    @PostMapping(value={"/v2/registerProduct"})
    public ResponseEntity<RespSimple> registerProduct(@RequestBody ProductModelDTO producto) {
        return this.productosService.guardarProductoClienteNEW(producto);
    }

    @PostMapping(value={"/listaIva"}, produces={"application/json"})
    public List<TTarifaIva> enlistarIva() {
        return this.productosService.enlistarIva();
    }

    @PostMapping(value={"/producto"}, produces={"application/json"})
    public TProducto obtenerProducto(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerProducto(idProducto);
    }

    @PostMapping(value={"/producto/nombre"}, produces={"application/json"})
    public String obtenerNombreProducto(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerNombreProducto(idProducto);
    }

    @PostMapping(value={"/producto/codigo"}, produces={"application/json"})
    public String obtenerCodigoProducto(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerCodigoProducto(idProducto);
    }

    @PostMapping(value={"/producto/precio"}, produces={"application/json"})
    public BigDecimal obtenerPrecioProducto(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerPrecioProducto(idProducto).setScale(2, RoundingMode.HALF_UP);
    }

    @PostMapping(value={"/producto/iva"}, produces={"application/json"})
    public int obtenerIvaProducto(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerIvaProducto(idProducto);
    }

    @PostMapping(value={"/getProductoInventario"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getProductoInventario(@RequestParam(value="idProductoInventario") Long idProductoInventario) {
        return this.productosService.getProductoInventarioByIdProducto(idProductoInventario);
    }

    @PostMapping(value={"/producto/idIva"}, produces={"application/json"})
    public int obtenerIdTarifaIva(@RequestParam(value="idProducto") BigDecimal idProducto) {
        return this.productosService.obtenerIdTarifaIva(idProducto);
    }

    @PostMapping(value={"/producto/calcularMonto"}, produces={"application/json"})
    public BigDecimal obtenerIdTarifaIva(@RequestParam double precio, @RequestParam double iva, @RequestParam double descuento) {
        BigDecimal descuentoPrecioT = BigDecimal.valueOf(precio).subtract(BigDecimal.valueOf(precio).multiply(BigDecimal.valueOf(descuento).divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP);
        BigDecimal ivaPrecioT = BigDecimal.valueOf(iva).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        return descuentoPrecioT.add(descuentoPrecioT.multiply(ivaPrecioT)).setScale(2, RoundingMode.HALF_UP);
    }

    @PostMapping(value={"/filtrarProductosNoInventariables"}, produces={"application/json"})
    public List<TProducto> filtrarProductosNoInventariables(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="query") String query) {
        return this.productosService.filtrarProductosNoInventariablesByQuery(idCliente, query);
    }

    @PostMapping(value={"/filtrarProductosInventariables"}, produces={"application/json"})
    public List<TInventario> filtrarProductosInventariablesByQuery(@RequestParam(value="idBodega") Long idBodega, @RequestParam(value="idCliente") Long idCliente, @RequestParam(value="query") String query, Boolean activo) {
        return this.productosService.filtrarProductosInventariablesByQuery(idBodega, idCliente, query, activo);
    }

    @PostMapping(value={"/filtrarProductosInventariablesConStock"}, produces={"application/json"})
    public List<TInventario> filtrarProductosInventariablesConStock(@RequestParam(value="idBodega") Long idBodega, @RequestParam(value="idCliente") Long idCliente, @RequestParam(value="query") String query) {
        return this.productosService.filtrarProductosInventariablesByQueryFacturacion(idBodega, idCliente, query);
    }

    @PostMapping(value={"/filtrarProductosFacturacion"}, produces={"application/json"})
    public List<ProductoInvenFacturacionDTO> filtrarProductosFacturacion(@RequestParam(value="idBodega") Long idBodega, @RequestParam(value="idCliente") Long idCliente, @RequestParam(value="query") String query) {
        return this.productosService.filtrarProductosFacturacion(idBodega, idCliente, query);
    }

    @PostMapping(value={"/getProductsWithMinStockCount"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getProductsWithMinStcokCount(@RequestParam(value="idCliente") Long idCliente) {
        return this.productosService.getProductsWithMinStockCount(idCliente);
    }

    @PostMapping(value={"/getProductsWithMinStock"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getProductsWithMinStcok(@RequestParam(value="idCliente") Long idCliente) {
        return this.productosService.getProductsWithMinStock(idCliente);
    }

    public ResponseEntity<RespSimple> convertirAllProductsToInventariable(Long idCliente, String idsProductos) {
        return this.productosService.hacerProductoInventariable(idCliente, idsProductos);
    }

    @PostMapping(value={"/siguienteSecuencia"}, produces={"application/json"})
    public Long obtenerSiguienteSecuencia(@RequestParam(value="idCliente") Long idCliente) {
        return this.productosService.obtenerSiguienteSecuencia(idCliente);
    }
}

