/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.core.exceptions.Transaccion;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.services.ProductoComponenteService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"productoComponentes"})
public class ProductoComponenteController {
    @Autowired
    private ProductoComponenteService componentesProducto;

    @PostMapping(path={"/listProductoComponenteDTO"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerProductosDTOFront(@RequestParam(value="idProducto") Long idProducto) {
        return this.componentesProducto.obtenerComponentesProducto(idProducto);
    }

    @PostMapping(value={"/vincular"})
    public ResponseEntity<RespSimple> vincularComponente(@RequestParam(value="idProducto") BigDecimal idProducto, @RequestParam(value="idComponente") BigDecimal idComponente) {
        try {
            return this.componentesProducto.vincularComponente(idProducto, idComponente);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Transaccion.ERROR((String)("Error al vincular componente: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/eliminar"})
    public ResponseEntity<RespSimple> eliminarVinculacion(@RequestParam Long idProductoComponente) {
        try {
            return this.componentesProducto.eliminarVinculacion(idProductoComponente);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Transaccion.ERROR((String)("Error al eliminar la vinculaci\u00f3n: " + e.getMessage()));
        }
    }
}

