/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.core.security.Seguridad;
import ec.tws2.back.contfiables.models.domain.Keycloak;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KeycloakController {
    @Autowired
    Seguridad seguridad;
    @Value(value="${property.seguridad.server}")
    String serverSeguridad;
    @Value(value="${property.seguridad.client_id}")
    String client_id;
    @Value(value="${property.seguridad.username}")
    String username;
    @Value(value="${property.seguridad.password}")
    String password;
    @Value(value="${property.seguridad.grant_type}")
    String grant_type;

    public String getTokenAdmin() throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.serverSeguridad + "/auth/realms/lhia/protocol/openid-connect/token";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.seguridad.decrypt(this.client_id));
        map.add((Object)"username", (Object)this.seguridad.decrypt(this.username));
        map.add((Object)"password", (Object)this.seguridad.decrypt(this.password));
        map.add((Object)"grant_type", (Object)this.seguridad.decrypt(this.grant_type));
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity answer = restTemplate.exchange(url, HttpMethod.POST, entity, Keycloak.class, new Object[0]);
        Keycloak body = (Keycloak)answer.getBody();
        if (body == null) {
            throw new Exception("No se pudo obtener el cuerpo de la respuesta de Keycloak");
        }
        return body.getAccess_token();
    }

    public void saveUsuarioKeycloak(String username, String email, String firstName, String lastName, String clave) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.serverSeguridad + "/auth/admin/realms/lhia/users";
        String requestJson = "{\r\n    \"username\": \"" + username + "\",\r\n    \"email\": \"" + email + "\",\r\n    \"enabled\": true,\r\n    \"emailVerified\": true,\r\n    \"firstName\": \"" + firstName + "\",\r\n    \"lastName\": \"" + lastName + "\",\r\n    \"credentials\": [\r\n        {\r\n            \"type\": \"password\",\r\n            \"value\": \"" + clave + "\",\r\n            \"temporary\": false\r\n        }\r\n    ]\r\n}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.getTokenAdmin());
        HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
    }

    public String getUserId(String userName) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.serverSeguridad + "/auth/admin/realms/lhia/users?username=" + userName;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(this.getTokenAdmin());
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity answer = restTemplate.exchange(url, HttpMethod.GET, entity, Keycloak[].class, new Object[0]);
        Keycloak[] body = (Keycloak[])answer.getBody();
        if (body == null || body.length == 0) {
            throw new Exception("Usuario no encontrado en Keycloak");
        }
        return body[0].getId();
    }

    public void saveRolesUsuarioKeycloak(String userId) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.serverSeguridad + "/auth/admin/realms/lhia/users/" + userId + "/role-mappings/realm";
        String requestJson = "[\r\n    {\r\n        \"id\": \"3911c5dc-982c-47d3-b7a6-7c35bd174b10\",\r\n        \"name\": \"user\"\r\n    },\r\n    {\r\n        \"id\": \"870705a5-beb2-4d82-a957-da90692a0794\",\r\n        \"name\": \"admin\"\r\n    }\r\n]";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.getTokenAdmin());
        HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
    }

    public String deshabilitarUsuarioKeycloak(String userId) throws Exception {
        try {
            RestTemplate restTemplate = new RestTemplate();
            String url = this.serverSeguridad + "/auth/admin/realms/lhia/users/" + userId;
            String requestJson = "{\r\n    \"enabled\": false\r\n}";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.getTokenAdmin());
            HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
            restTemplate.put(url, (Object)entity, new Object[]{String.class});
            return "0";
        }
        catch (Exception e) {
            return "1";
        }
    }
}

