/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.FileSignature;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.FirmaCaducidadContfiablesDTO;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.services.FirmaElectronicaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FirmaElectronicaController {
    @Autowired
    FirmaElectronicaService firmaElectronicaService;

    @PostMapping(value={"almacenarArchivo"}, produces={"application/json"})
    public ResponseEntity<RespSimple> almacenarArchivo(@RequestBody FileSignature fileSignature) {
        RespSimple resp = this.firmaElectronicaService.almacenarArchivo(fileSignature);
        boolean exito = ContfiablesEnum.TRANSACCION_OK.getId().equals(resp.getError());
        if (exito) {
            return ResponseEntity.ok((Object)resp);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)resp);
    }

    @GetMapping(value={"firmas/vencimientos"}, produces={"application/json"})
    public ResponseEntity<?> listarVencimientos() {
        try {
            List data = this.firmaElectronicaService.listarFechasTodas();
            return ResponseEntity.ok((Object)data);
        }
        catch (Exception e) {
            RespSimple r = new RespSimple();
            r.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            r.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            r.setMensaje("Error listando vencimientos: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)r);
        }
    }

    @PostMapping(value={"firmas/vencimientos/persistir-todo"}, produces={"application/json"})
    public ResponseEntity<RespSimple> persistirTodasLasFechas() {
        try {
            int n = this.firmaElectronicaService.persistirTodasLasFechasCaducidad();
            RespSimple r = new RespSimple();
            r.setError(ContfiablesEnum.TRANSACCION_OK.getId());
            r.setCodigo(ContfiablesEnum.TRANSACCION_OK.getId());
            r.setMensaje("Fechas de caducidad guardadas: " + n);
            return ResponseEntity.ok((Object)r);
        }
        catch (Exception e) {
            RespSimple r = new RespSimple();
            r.setError(ContfiablesEnum.TRANSACCION_ERROR.getId());
            r.setCodigo(ContfiablesEnum.TRANSACCION_ERROR.getId());
            r.setMensaje("Error al persistir vencimientos: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)r);
        }
    }

    @GetMapping(value={"/Caducidad"})
    public ResponseEntity<FirmaCaducidadContfiablesDTO> caducidadPorId(@RequestParam Long idCliente) {
        FirmaCaducidadContfiablesDTO dto = this.firmaElectronicaService.obtenerCaducidadPorIdCliente(idCliente);
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/alertaCaducidadFirma"})
    public ResponseEntity<RespSimple> getAlertaCaducidadFirma(@RequestParam Long idCliente) {
        return this.firmaElectronicaService.getAlertaCaducidadFirma(idCliente);
    }
}

