/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.DatosFactura;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.facturacion.TFactura;
import ec.tws2.back.contfiables.models.entities.facturacion.TFacturaDetalle;
import ec.tws2.back.contfiables.services.FacturaService;
import ec.tws2.back.contfiables.services.TFormaPagoComprobantesService;
import ec.tws2.back.contfiables.services.impl.facturacion.FacturacionServiceImpl;
import ec.tws2.back.contfiables.services.impl.facturacion.ReenvioFacturacionService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"factura"})
public class FacturaController {
    private static final Logger log = LoggerFactory.getLogger(FacturaController.class);
    private final FacturaService facturaService;
    private final FacturacionServiceImpl facturacionService;
    private final TFormaPagoComprobantesService formaPagoComprobantesService;
    private final ReenvioFacturacionService reenvioFacturacionService;

    @PostMapping(value={"reenviarFacturabyIdFactura"}, produces={"application/json"})
    public ResponseEntity<RespSimple> reenviarFacturabyIdFactura(@RequestParam BigDecimal idFactura) {
        return this.reenvioFacturacionService.buscarFacturaAreeenviar(idFactura);
    }

    @PostMapping(value={"facturar"}, produces={"application/json"})
    public ResponseEntity<RespSimple> facturarWEB(@RequestBody DatosFactura datosFacturas) {
        return this.facturacionService.facturar(datosFacturas);
    }

    @PostMapping(value={"ultimas5facturas"}, produces={"application/json"})
    public ResponseEntity<RespSimple> ultimas5facturas(@RequestParam Long idCliente) {
        return this.facturaService.getUltimas5facturas(idCliente);
    }

    @PostMapping(value={"reenviarFacturaPorCorreo"}, produces={"application/json"})
    public ResponseEntity<RespSimple> reenviarFacturaPorCorreo(@RequestParam Long idFactura, @RequestParam String correo) {
        return this.facturacionService.reenviarCorreo(idFactura, correo, null);
    }

    @PostMapping(value={"movil/reenviarFacturaPorCorreoByNumAut"}, produces={"application/json"})
    public ResponseEntity<RespSimple> reenviarFacturaPorCorreoByNumAut(@RequestParam String numAutorizacion, @RequestParam String correo) {
        return this.facturacionService.reenviarCorreo(null, correo, numAutorizacion);
    }

    @PostMapping(value={"getFactura"}, produces={"application/json"})
    public TFactura getFactura() {
        return this.facturaService.getFactura(BigDecimal.valueOf(1L));
    }

    @PostMapping(value={"/getDetalleFactura"}, produces={"application/json"})
    public List<TFacturaDetalle> getDetalleFactura(@RequestParam BigDecimal idFactura) {
        return this.facturaService.getDetalleFactura(idFactura);
    }

    @PostMapping(value={"/actualizarAutorizacionFactura"}, produces={"application/json"})
    public ResponseEntity<RespSimple> actualizarAutorizacionFactura(@RequestBody TFactura factura) {
        return this.facturaService.actualizarDatosFacturaAutorizada(factura);
    }

    @PostMapping(value={"obtenerUltimas3Facturas"}, produces={"application/json"})
    public List<TFactura> obtenerUltimas3Facturas(@RequestParam BigDecimal idUsuario) {
        return this.facturaService.obtenerUltimas3Facturas(idUsuario);
    }

    @PostMapping(value={"obtenerFacturasPorFechaIdentificacion"}, produces={"application/json"})
    public List<TFactura> obtenerFacturasPorFechaIdentificacion(@RequestParam Long idCliente, @RequestParam String identificacionAdquiriente, @RequestParam String fechaInicio, @RequestParam String fechaFinal) {
        String Hora0 = " 00:00:00";
        String Hora24 = " 23:59:59";
        if (!identificacionAdquiriente.equals("0")) {
            return this.facturaService.obtenerFacturasPorFechaEidentificacion(idCliente, fechaInicio + Hora0, fechaFinal + Hora24, identificacionAdquiriente);
        }
        return this.facturaService.obtenerFacturasAutorizadasPorFecha(idCliente, fechaInicio + Hora0, fechaFinal + Hora24);
    }

    @PostMapping(value={"web/obtenerFacturasPorFechaIdentificacion"}, produces={"application/json"})
    public List<TFactura> WebObtenerFacturasPorFechaIdentificacion(@RequestParam Long idCliente, @RequestParam String identificacionAdquiriente, @RequestParam String fechaInicio, @RequestParam String fechaFinal) {
        String Hora0 = " 00:00:00";
        String Hora24 = " 23:59:59";
        if (!identificacionAdquiriente.equals("0")) {
            return this.facturaService.WebObtenerFacturasPorFechaEidentificacion(idCliente, fechaInicio + Hora0, fechaFinal + Hora24, identificacionAdquiriente);
        }
        return this.facturaService.webObtenerFacturasAutorizadasPorFecha(idCliente, fechaInicio + Hora0, fechaFinal + Hora24);
    }

    @PostMapping(value={"obtenerFacturasPorNumComprobante"}, produces={"application/json"})
    public List<TFactura> obtenerFacturasPorNumComprobante(@RequestParam Long idCliente, String numComprobante) {
        return this.facturaService.obtenerPorNumeroComprobante(numComprobante, idCliente);
    }

    @PostMapping(value={"obtenerFacturasPorRazonSocial"}, produces={"application/json"})
    public List<TFactura> obtenerFacturasPorRazonSocial(@RequestParam Long idCliente, String razonSocial) {
        return this.facturaService.obtenerPorRazonSocial(razonSocial.toUpperCase(), idCliente);
    }

    @PostMapping(value={"/obtenerFacturasNoAutorizadasPorFecha"}, produces={"application/json"})
    public List<TFactura> obtenerFacturasNoAutorizadasPorFecha(@RequestParam String idCliente, @RequestParam String fechaInicio, @RequestParam String fechaFinal) {
        String Hora0 = " 00:00:00";
        String Hora24 = " 23:59:59";
        return this.facturaService.obtenerFacturasNoAutorizadasPorFechaIdentificacion(Integer.valueOf(idCliente).intValue(), fechaInicio + Hora0, fechaFinal + Hora24);
    }

    @PostMapping(value={"obtenerFacturas"}, produces={"application/json"})
    public List<TFactura> obtenerFacturas(@RequestParam Long idUsuario) {
        return this.facturaService.obtenerFacturas(idUsuario);
    }

    @PostMapping(value={"actualizarEstadoAutorizadoFactura"}, produces={"application/json"})
    public RespSimple actualizarEstadoAutorzacionFactura(@RequestBody TFactura factura) {
        return this.facturaService.actualizarEstadoFactura(factura);
    }

    @PostMapping(value={"/getFacturasCount"})
    public ResponseEntity<RespSimple> filtrarCantidadFacturasEmitidas(@RequestParam(value="idCliente") Long idCliente) {
        return this.facturaService.getFacturasCount(idCliente);
    }

    @PostMapping(value={"/getFacturasTotalByClienteAndYear"})
    public ResponseEntity<RespSimple> getFacturasTotalByClienteAndYear(@RequestParam(value="idCliente") Long idCliente) {
        return this.facturaService.getFacturasTotalByClienteAndYear(idCliente);
    }

    @PostMapping(value={"/getFacturasByClienteAndAnioAndMes"})
    public ResponseEntity<RespSimple> getFacturasByClienteAndAnioAndMes(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="anio") int anio, @RequestParam(value="mes") int mes) {
        return this.facturaService.getFacturasByClienteAndAnioOrMonth(idCliente, anio, mes);
    }

    @PostMapping(value={"/getValorFacturasEfectivoByCliente"})
    public ResponseEntity<RespSimple> getValorFacturasEfectivoByCliente(@RequestParam(value="idCliente") Long idCliente) {
        return this.formaPagoComprobantesService.getValueFacturasEfectivo(idCliente);
    }

    @PostMapping(value={"/getValorFacturasCreditoByCliente"})
    public ResponseEntity<RespSimple> getValorFacturasCreditoByCliente(@RequestParam(value="idCliente") Long idCliente) {
        return this.formaPagoComprobantesService.getValueFacturasCredito(idCliente);
    }

    @PostMapping(value={"/anularFactura"})
    public ResponseEntity<RespSimple> anularFactura(@RequestParam(value="idFactura") BigDecimal idFactura) {
        return this.facturaService.anularFactura(idFactura);
    }

    public FacturaController(FacturaService facturaService, FacturacionServiceImpl facturacionService, TFormaPagoComprobantesService formaPagoComprobantesService, ReenvioFacturacionService reenvioFacturacionService) {
        this.facturaService = facturaService;
        this.facturacionService = facturacionService;
        this.formaPagoComprobantesService = formaPagoComprobantesService;
        this.reenvioFacturacionService = reenvioFacturacionService;
    }
}

