/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.ComprobanteAjusteDetalle;
import ec.tws2.back.contfiables.models.domain.ComprobanteCompraDetalle;
import ec.tws2.back.contfiables.models.domain.ComprobanteDetalleObligacionesMODEL;
import ec.tws2.back.contfiables.models.domain.ComprobanteTransferenciaDetalle;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.facturacion.TTipoComprobante;
import ec.tws2.back.contfiables.services.ComprobantesService;
import ec.tws2.back.contfiables.services.SecuenciaComprobanteService;
import ec.tws2.back.contfiables.services.TipoComprobanteService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"comprobantes/"})
public class ComprobantesController {
    @Autowired
    private SecuenciaComprobanteService secuenciaService;
    @Autowired
    private TipoComprobanteService tipoComprobanteService;
    @Autowired
    private ComprobantesService comprobanteCompraService;

    @PostMapping(value={"getComprobante"})
    public ResponseEntity<RespSimple> getComprobante(@RequestParam(value="prefijo") String prefijo) {
        switch (prefijo) {
            case "AJ*": {
                return this.tipoComprobanteService.obtenerTipoComprobanteAjustes();
            }
        }
        return this.tipoComprobanteService.obtenerTipoComprobante(prefijo);
    }

    @PostMapping(value={"getListTipoComprobantes"})
    public ResponseEntity<RespSimple> getListTipoComprobantes(@RequestParam(value="idCliente") Long idCliente) {
        return this.tipoComprobanteService.obtenerListaTipoComprobantes(idCliente);
    }

    @PostMapping(value={"postTipoComprobante"})
    public ResponseEntity<RespSimple> postTipoComprobante(@RequestBody TTipoComprobante tipoComprobante) {
        return this.tipoComprobanteService.registrarTipoComprobantes(tipoComprobante);
    }

    @PostMapping(value={"putTipoComprobante"})
    public ResponseEntity<RespSimple> putTipoComprobante(@RequestBody TTipoComprobante tipoComprobante) {
        return this.tipoComprobanteService.actualizarTipoComprobantes(tipoComprobante);
    }

    @PostMapping(value={"getListComprobantesCompras"})
    public ResponseEntity<RespSimple> getListComprobantesCompras(@RequestParam(value="idBodega") Long idBodega, @RequestParam(value="idPuntoVenta") Long idPuntoVenta, @RequestParam(value="fechaInicial") Long fechaInicial, @RequestParam(value="fechaFinal") Long fechaFinal, @RequestParam(value="tipo") String tipo) {
        return this.comprobanteCompraService.obtenerComprobantesCompra(idBodega, idPuntoVenta, new Date(fechaInicial), new Date(fechaFinal), tipo);
    }

    @PostMapping(value={"getSecuenciaComprobanteX"})
    public ResponseEntity<RespSimple> getSecuenciaComprobanteCompra(@RequestParam(value="idPuntoVenta") Long idPuntoVenta, @RequestParam(value="idTipoComprobante") Long idTipoComprobante) {
        return this.secuenciaService.obtenerSecuenciaComprobanteX(idTipoComprobante, idPuntoVenta);
    }

    @PostMapping(value={"registrarComprobanteCompra"})
    public ResponseEntity<RespSimple> registrarComprobanteCompra(@RequestBody ComprobanteCompraDetalle comprobanteCompraDetalle) throws Exception {
        return this.comprobanteCompraService.registrarComprobanteCompra(comprobanteCompraDetalle);
    }

    @PostMapping(value={"registrarComprobanteObligacion"})
    public ResponseEntity<RespSimple> registrarComprobanteObligacion(@RequestBody ComprobanteDetalleObligacionesMODEL comprobanteObligacion) {
        return this.comprobanteCompraService.registrarComprobanteObligacion(comprobanteObligacion);
    }

    @PostMapping(value={"putComprobanteCompraObligacion"})
    public ResponseEntity<RespSimple> putComprobanteCompraObligacion(@RequestBody ComprobanteDetalleObligacionesMODEL comprobanteObligacion) {
        return this.comprobanteCompraService.actualizarComprobanteObligacion(comprobanteObligacion);
    }

    @PostMapping(value={"registrarComprobanteAjuste"})
    public ResponseEntity<RespSimple> registrarComprobanteAjuste(@RequestBody ComprobanteAjusteDetalle comprobanteAjusteDetalle) throws Exception {
        return this.comprobanteCompraService.registrarComprobanteAjuste(comprobanteAjusteDetalle);
    }

    @PostMapping(value={"getDetalleComprobanteCompra"})
    public ResponseEntity<RespSimple> getDetalleComprobanteCompra(@RequestParam(value="idComprobante") Long idComprobante, @RequestParam(value="tipoCom") String tipoCom) throws Exception {
        return this.comprobanteCompraService.obtenerDetalleComprobanteCompra(idComprobante, tipoCom);
    }

    @PostMapping(value={"eliminarComprobanteCompra"})
    public ResponseEntity<RespSimple> eliminarComprobanteCompra(@RequestParam(value="idComprobante") Long idComprobante, @RequestParam(value="tipoCom") String tipoCom) throws Exception {
        return this.comprobanteCompraService.eliminarComprobanteCompra(idComprobante, tipoCom);
    }

    @PostMapping(value={"getTiposComprobantesTributarios"})
    public ResponseEntity<RespSimple> getTiposComprobantesTributarios() {
        return this.tipoComprobanteService.obtenerTipoDocumentosTributarios();
    }

    @PostMapping(value={"getSustentoTributarios"})
    public ResponseEntity<RespSimple> getSustentoTributarios() {
        return this.tipoComprobanteService.obtenerListaSustentoTributarios();
    }

    @PostMapping(value={"getComprobantesObligaciones"})
    public ResponseEntity<RespSimple> getComprobantesObligaciones() {
        return this.tipoComprobanteService.getComprobantesObligaciones();
    }

    @PostMapping(value={"registrarComprobanteTransferencia"})
    public ResponseEntity<RespSimple> registrarComprobanteTransferencia(@RequestBody ComprobanteTransferenciaDetalle comprobanteTransDetalle) throws Exception {
        return this.comprobanteCompraService.registrarComprobanteTransferencia(comprobanteTransDetalle);
    }
}

