/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.core.util.EnvioCorreo;
import ec.tws2.back.contfiables.models.domain.FileSignature;
import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.dtos.CobroContfiableDTO;
import ec.tws2.back.contfiables.models.entities.cliente.TCliente;
import ec.tws2.back.contfiables.models.enums.ContfiablesEnum;
import ec.tws2.back.contfiables.repositories.cliente.TClienteDAO;
import ec.tws2.back.contfiables.services.ClienteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class ClienteController {
    private static final Logger log = LoggerFactory.getLogger(ClienteController.class);
    private final ClienteService clienteService;
    private final TClienteDAO tClienteDAO;
    private final EnvioCorreo envioCorreo;

    @PostMapping(value={"/getPasswordCerticateByIdentification"})
    public ResponseEntity<?> getPasswordCerticateByIdentification(@RequestParam String identification) {
        return this.clienteService.getPasswordCerticateByIdentification(identification);
    }

    @PostMapping(value={"changeFavoriteCobroContfiable"})
    public ResponseEntity<RespSimple> changeFavoriteCobroContfiable(@RequestParam Long idCobroContfiable, @RequestParam Boolean isFavorite) {
        return this.clienteService.changeFavoriteCobroContfiable(idCobroContfiable, isFavorite);
    }

    @PostMapping(value={"getListCobroContfiable"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getListCobroContfiable(@RequestParam String username, @RequestParam Boolean onlyFavorites) {
        return this.clienteService.sgetListCobroContfiable(username, onlyFavorites);
    }

    @PostMapping(value={"saveCobroContfiable"}, produces={"application/json"})
    public ResponseEntity<RespSimple> saveCobroContfiable(@RequestBody CobroContfiableDTO cobroContifable) {
        return this.clienteService.saveCobroContfiable(cobroContifable);
    }

    @PostMapping(value={"getVersionContfiables"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getVersionContfiables(@RequestParam Long idVersion) {
        return this.clienteService.getVersionContfiables(idVersion);
    }

    @PostMapping(value={"getClienteSuscripcion"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getClienteSuscripcion(@RequestParam String usuario) {
        return this.clienteService.getClienteSuscripcion(usuario);
    }

    @PostMapping(value={"existeUsuario"}, produces={"application/json"})
    public ResponseEntity<RespSimple> existeUsuario(@RequestBody TCliente usuario) {
        RespSimple response = this.clienteService.exiteUsuario(usuario);
        if (response.getError().equals(ContfiablesEnum.TRANSACCION_ERROR.getId())) {
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"getIdentificacionUsuario"}, produces={"application/json"})
    public ResponseEntity<String> existeUsuario(@RequestParam(value="usuario") String usuario) {
        String response = this.clienteService.getIdentificacionCliente(usuario);
        if (response == null) {
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"getIdUsuario"}, produces={"application/json"})
    public ResponseEntity<Long> idUsuario(@RequestParam(value="usuario") String usuario) {
        Long response = this.clienteService.getIdCliente(usuario);
        if (response == null) {
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"getCliente"}, produces={"application/json"})
    public ResponseEntity<TCliente> getCliente(@RequestParam(value="usuario") String usuario) {
        TCliente cliente = this.clienteService.getCliente(usuario);
        if (cliente == null) {
            return new ResponseEntity((Object)cliente, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)cliente, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"completarRegistro"}, produces={"application/json"})
    public RespSimple completarRegistro(@RequestBody FileSignature fileSignature) {
        return this.clienteService.almacenarCliente(fileSignature);
    }

    @PostMapping(value={"registroCliente"}, produces={"application/json"})
    public RespSimple registro(@RequestBody FileSignature fileSignature) {
        return this.clienteService.almacenarCliente(fileSignature);
    }

    @PostMapping(value={"actualizarCliente"}, produces={"application/json"})
    public String actualizarCliente(@RequestBody FileSignature fileSignature) {
        String respuesta;
        log.info("ACTUALIZANDO EL CLIENTE");
        try {
            respuesta = this.clienteService.actualizarCliente(fileSignature).getError();
        }
        catch (Exception e) {
            respuesta = "1";
        }
        return respuesta;
    }

    @PostMapping(value={"decrypt"}, produces={"application/json"})
    public String decrypt(@RequestParam(value="clave") String usuario) throws Exception {
        return this.clienteService.decrypt(usuario);
    }

    @PostMapping(value={"encrypt"}, produces={"application/json"})
    public String encrypt(@RequestParam(value="clave") String usuario) throws Exception {
        return this.clienteService.encrypt(usuario);
    }

    @PostMapping(value={"logo"}, produces={"application/json"})
    public String obtenerLogo(@RequestParam(value="ruc") String ruc) throws Exception {
        return this.clienteService.obtenerLogo(ruc);
    }

    @PostMapping(value={"sentEmailContfiables"}, produces={"application/json"})
    public String sentEmailContfiables(@RequestParam String correoDesd, @RequestParam String cuerpo) {
        String respuesta;
        try {
            this.envioCorreo.fnNotificarContfiables("info@contfiables.com", correoDesd, "Solicitud de firma electr\u00f3nica", cuerpo);
            respuesta = "0";
        }
        catch (Exception e) {
            respuesta = "1";
        }
        return respuesta;
    }

    @PostMapping(value={"secuenciaProducto"}, produces={"application/json"})
    public int obtenerIdTarifaIva(@RequestParam Long idCliente) {
        return this.clienteService.obtenerSecuenciaProducto(idCliente);
    }

    @PostMapping(value={"secuenciaComponente"}, produces={"application/json"})
    public int obtenerSecuenciaComponente(@RequestParam Long idCliente) {
        return this.clienteService.obtenerSecuenciaComponente(idCliente);
    }

    @PostMapping(value={"eliminarUsuario"}, produces={"application/json"})
    public ResponseEntity<RespSimple> eliminarUsuario(@RequestParam String usuario) {
        return this.clienteService.eliminarUsuario(usuario);
    }

    @PostMapping(value={"/getTipoEmprendedorList"})
    public ResponseEntity<RespSimple> getTipoEmprendedorList() {
        return this.clienteService.getTipoEmprendedorList();
    }

    public ClienteController(ClienteService clienteService, TClienteDAO tClienteDAO, EnvioCorreo envioCorreo) {
        this.clienteService = clienteService;
        this.tClienteDAO = tClienteDAO;
        this.envioCorreo = envioCorreo;
    }
}

