/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.proveedor.TCategoriaProveedor;
import ec.tws2.back.contfiables.services.CategoriaProveedorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"categoriaProveedor/"})
public class CategoriaProveedorController {
    @Autowired
    CategoriaProveedorService catProveedorService;

    @PostMapping(value={"getCategoriaProveedores"}, produces={"application/json"})
    public ResponseEntity<RespSimple> obtenerListaCatProveedores(@RequestParam(value="idCliente") Long idCliente, @RequestParam(value="activo") Boolean activo) {
        if (activo.booleanValue()) {
            return this.catProveedorService.obtenerListaCategoriaProveedoresActivos(idCliente);
        }
        return this.catProveedorService.obtenerListaCategoriaProveedores(idCliente);
    }

    @PostMapping(value={"registrarCategoriaProveedor"}, produces={"application/json"})
    public ResponseEntity<RespSimple> registrarCategoriaProveedor(@RequestBody TCategoriaProveedor catProv) {
        return this.catProveedorService.registrarCategoriaProveedor(catProv);
    }

    @PostMapping(value={"actualizarCategoriaProveedor"}, produces={"application/json"})
    public ResponseEntity<RespSimple> actualizarCategoriaProveedor(@RequestBody TCategoriaProveedor catProv) {
        return this.catProveedorService.actualizarCategoriaProveedor(catProv);
    }

    @PostMapping(value={"getCategoriaProveedorById"}, produces={"application/json"})
    public ResponseEntity<RespSimple> getCategoriaProveedorId(@RequestParam Long idCategoria, @RequestParam Long idCliente) {
        return this.catProveedorService.obtenerCategoriaProveedorById(idCliente, idCategoria);
    }
}

