/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.contfiables.controllers;

import ec.tws2.back.contfiables.models.domain.RespSimple;
import ec.tws2.back.contfiables.models.entities.cliente.TAdquiriente;
import ec.tws2.back.contfiables.models.entities.cliente.TTipoIdentificacion;
import ec.tws2.back.contfiables.repositories.inventario.TTipoIdentificacionDAO;
import ec.tws2.back.contfiables.services.AdquirienteService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdquirienteController {
    @Autowired
    AdquirienteService adquirienteService;
    @Autowired
    TTipoIdentificacionDAO tipoIdentificacionDAO;
    Logger log = Logger.getLogger(AdquirienteController.class.getName());

    @PostMapping(value={"getAdquiriente"}, produces={"application/json"})
    public ResponseEntity<TAdquiriente> getAdquiriente(@RequestParam(value="identificacion") String identificacion) {
        TAdquiriente adquiriente = new TAdquiriente();
        try {
            adquiriente = this.adquirienteService.getAdquiriente4identification(identificacion);
            if (adquiriente.getId() == null) {
                return new ResponseEntity((Object)adquiriente, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)adquiriente, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ERROR AL GET ADQUIRIENTE ", e);
            return new ResponseEntity((Object)adquiriente, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/listaTiposIdentificacion"}, produces={"application/json"})
    public List<TTipoIdentificacion> enlistarTipoIdentificacion() {
        return this.tipoIdentificacionDAO.enlistarTipoIdentificacion();
    }

    @PostMapping(value={"/filtrarAdquirienteQuery"}, produces={"application/json"})
    public ResponseEntity<RespSimple> filtrarAdquirienteQuery(@RequestParam(value="q") String q) {
        return this.adquirienteService.filtrarAdquiriente(q);
    }

    @PostMapping(value={"/filtrarAdquirienteByRazonSocial"}, produces={"application/json"})
    public ResponseEntity<RespSimple> filtrarAdquirienteByRazonSocial(@RequestParam(value="q") String q) {
        return this.adquirienteService.getAdquiriente4RazonSocial(q);
    }

    @PostMapping(value={"/filtrarAdquirienteByIdentificacion"}, produces={"application/json"})
    public ResponseEntity<RespSimple> filtrarAdquirienteByIdentificacion(@RequestParam(value="q") String q) {
        return this.adquirienteService.filtrarAdquirienteByIdentificacion(q);
    }
}

