/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.config;

import com.lhia.client.api.lhia_ja_api.config.ApiResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(name="ApiResponse", description="Respuesta gen\u00e9rica de todos los endpoints, parametrizada con el tipo de `data`.")
public class ApiResponse<T> {
    @Schema(description="Indica si la operaci\u00f3n fue exitosa o no", example="true")
    private boolean success;
    @Schema(description="C\u00f3digo HTTP de la respuesta", example="200")
    private int status;
    @Schema(description="C\u00f3digo de negocio que describe el resultado", example="SUCCESS")
    private ResponseCode code;
    @Schema(description="Mensaje descriptivo de la operaci\u00f3n", example="OK")
    private String message;
    @Schema(description="Carga de datos devuelta por el endpoint (puede variar seg\u00fan operaci\u00f3n)")
    private T data;
    @Schema(description="Marca de tiempo ISO 8601 de la respuesta", example="2025-09-17T12:00:00")
    private String timestamp = ApiResponse.now();

    public ApiResponse(boolean success, int status, ResponseCode code, String message, T data) {
        this.success = success;
        this.status = status;
        this.code = code;
        this.message = message;
        this.data = data;
        this.timestamp = ApiResponse.now();
    }

    private static String now() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public static <T> ApiResponse<T> ok(T data) {
        return new ApiResponse(true, 200, ResponseCode.SUCCESS, "OK", data);
    }

    public static <T> ApiResponse<T> ok(String message, T data) {
        return new ApiResponse(true, 200, ResponseCode.SUCCESS, message, data);
    }

    public static <T> ApiResponse<T> ok(ResponseCode code, String message, T data) {
        return new ApiResponse(true, 200, code, message, data);
    }

    public static <T> ApiResponse<T> error(int status, ResponseCode code, String message) {
        return new ApiResponse(false, status, code, message, null);
    }

    public static <T> ApiResponse<T> error(int status, ResponseCode code, String message, T data) {
        return new ApiResponse(false, status, code, message, data);
    }

    public static <T> ApiResponse<T> error(int status, ResponseCode code, T data) {
        return new ApiResponse(false, status, code, "Error", data);
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public ResponseCode getCode() {
        return this.code;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public T getData() {
        return (T)this.data;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Generated
    public void setCode(ResponseCode code) {
        this.code = code;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        ResponseCode this$code = this.getCode();
        ResponseCode other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getStatus();
        ResponseCode $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiResponse(success=" + this.isSuccess() + ", status=" + this.getStatus() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public ApiResponse(boolean success, int status, ResponseCode code, String message, T data, String timestamp) {
        this.success = success;
        this.status = status;
        this.code = code;
        this.message = message;
        this.data = data;
        this.timestamp = timestamp;
    }

    @Generated
    public ApiResponse() {
    }
}

