/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.common.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lhia.client.api.lhia_ja_api.config.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationEntry
implements AuthenticationEntryPoint {
    private final ObjectMapper objectMapper;

    public CustomAuthenticationEntry(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String exMsg;
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String msg = "No autorizado";
        String string = exMsg = authException != null && authException.getMessage() != null ? authException.getMessage() : "";
        if (exMsg.toUpperCase().contains("JWT EXPIRED")) {
            msg = "Token caducado";
        }
        ApiResponse apiResponse = ApiResponse.error((int)HttpStatus.UNAUTHORIZED.value(), (ApiResponse.ResponseCode)ApiResponse.ResponseCode.UNAUTHORIZED, (String)msg);
        byte[] json = this.objectMapper.writeValueAsBytes((Object)apiResponse);
        response.getOutputStream().write(json);
        response.getOutputStream().flush();
    }
}

