/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.common.helper;

import com.lhia.client.api.lhia_ja_api.common.exceptions.SinglePagePdfRequiredException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfToImageConverter {
    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<byte[]> convertFirstPageFromBase64Pdf(String base64Pdf) {
        try {
            byte[] pdfBytes = Base64.getDecoder().decode(base64Pdf);
            try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(pdfBytes));){
                Optional<byte[]> optional;
                int pageCount = document.getNumberOfPages();
                if (pageCount > 1) {
                    throw new SinglePagePdfRequiredException(pageCount);
                }
                PDFRenderer renderer = new PDFRenderer(document);
                BufferedImage image = renderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
                try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)image, "PNG", byteArray);
                    optional = Optional.of(byteArray.toByteArray());
                }
                return optional;
            }
        }
        catch (SinglePagePdfRequiredException e) {
            throw e;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

