/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.client.apis;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lhia.client.api.lhia_ja_api.client.models.OperationResult;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class OpenAiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    @Value(value="${openai.api.key}")
    private String OPENAI_KEY;
    @Value(value="${openai.url.answer}")
    private String OPENAI_URL;
    @Value(value="${openai.model.answer}")
    private String OPENAI_MODEL;
    private final RestTemplate restTemplate = new RestTemplate();

    public OperationResult sendMessage(Map<String, Object> body) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(body);
            log.info("Payload completo:\n{}", (Object)json);
            HashMap<String, Object> requestBody = new HashMap<String, Object>(body);
            requestBody.put("model", this.OPENAI_MODEL);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.OPENAI_KEY);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            log.info("Enviando solicitud a BaseAI.");
            ResponseEntity response = this.restTemplate.postForEntity(this.OPENAI_URL, (Object)request, String.class, new Object[0]);
            log.info("Response status: {}, body:\n{}", (Object)response.getStatusCode(), response.getBody());
            String bodyJson = (String)response.getBody();
            if (bodyJson == null || !bodyJson.trim().startsWith("{")) {
                return OperationResult.failure((String)"Respuesta de BaseAI no es JSON.");
            }
            JsonNode root = objectMapper.readTree(bodyJson);
            String content = root.path("choices").path(0).path("message").path("content").asText();
            return OperationResult.success((String)content);
        }
        catch (HttpClientErrorException e) {
            String errorBody = e.getResponseBodyAsString();
            log.error("Error HTTP BaseAI: status={}, body={}", (Object)e.getStatusCode(), (Object)errorBody);
            return OperationResult.failure((String)String.format("Error HTTP BaseAI: %s - %s", e.getStatusCode(), errorBody));
        }
        catch (Exception e) {
            log.error("Error inesperado al llamar a BaseAI", (Throwable)e);
            return OperationResult.failure((String)("Error inesperado: " + e.getMessage()));
        }
    }

    public OperationResult sendMessageV2(Map<String, Object> body) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(body);
            log.info("Payload completo:\n{}", (Object)json);
            HashMap<String, Object> requestBody = new HashMap<String, Object>(body);
            requestBody.put("model", this.OPENAI_MODEL);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.OPENAI_KEY);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            log.info("Enviando solicitud a BaseAI.");
            ResponseEntity response = this.restTemplate.postForEntity(this.OPENAI_URL, (Object)request, String.class, new Object[0]);
            log.info("Response => ", (Object)response);
            String bodyJson = (String)response.getBody();
            if (bodyJson == null || !bodyJson.trim().startsWith("{")) {
                return OperationResult.failure((String)"Respuesta de BaseAI no es JSON.");
            }
            JsonNode root = objectMapper.readTree(bodyJson);
            String content = root.path("choices").path(0).path("message").path("content").asText();
            return OperationResult.success((String)content);
        }
        catch (HttpClientErrorException e) {
            return OperationResult.failure((String)("Error HTTP BaseAI: " + e.getStatusCode()));
        }
        catch (Exception e) {
            return OperationResult.failure((String)("Error inesperado: " + e.getMessage()));
        }
    }
}

