/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lhia.client.api.lhia_ja_api.config.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.context.annotation.Primary;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;

@Component
@Primary
public class JsonAccessDeniedHandler
implements AccessDeniedHandler {
    private final ObjectMapper mapper;

    public JsonAccessDeniedHandler(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException {
        ApiResponse apiError = ApiResponse.error((int)403, (ApiResponse.ResponseCode)ApiResponse.ResponseCode.FORBIDDEN, (String)"Acceso denegado");
        response.setStatus(403);
        response.setContentType("application/json;charset=UTF-8");
        String body = this.mapper.writeValueAsString((Object)apiError);
        response.getWriter().write(body);
    }
}

