/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.api.mapper;

import com.lhia.client.api.lhia_ja_api.api.dto.ServiceDocumentDTO;
import com.lhia.client.api.lhia_ja_api.infrastructure.entity.TAnalysisEntity;
import java.math.BigDecimal;
import java.time.LocalDate;

public class ServiceDocumentMapper {
    public static TAnalysisEntity toEntity(ServiceDocumentDTO dto) {
        if (dto == null) {
            return null;
        }
        TAnalysisEntity entity = new TAnalysisEntity();
        String provider = dto.getProvider();
        entity.setProvider(provider != null ? provider : "");
        String holder = dto.getFullNameHolder();
        entity.setFullNameHolder(holder != null ? holder : "");
        String valDoc = dto.getValueDocument();
        if (valDoc != null) {
            try {
                entity.setValueDocument(new BigDecimal(valDoc));
            }
            catch (NumberFormatException e) {
                entity.setValueDocument(BigDecimal.ZERO);
            }
        } else {
            entity.setValueDocument(BigDecimal.ZERO);
        }
        String contract = dto.getContractNumber();
        entity.setContractNumber(contract != null ? contract : "");
        LocalDate issue = dto.getIssueDate();
        entity.setIssueDate(issue != null ? issue : LocalDate.now());
        String serviceAddr = dto.getServiceAddress();
        entity.setServiceAddress(serviceAddr != null ? serviceAddr : "");
        String formAddr = dto.getFormAddress();
        entity.setFormAddress(formAddr != null ? formAddr : "");
        entity.setOcrConfidenceAddress(Integer.valueOf(dto.getOcrConfidenceAddress()));
        entity.setSemanticSimilarityAddress(Integer.valueOf(dto.getSemanticSimilarityAddress()));
        entity.setAddressScore(Integer.valueOf(dto.getAddressScore()));
        return entity;
    }
}

