/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.api.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Optional;

public class JsonResponseMapper {
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).registerModule((Module)new JavaTimeModule());

    public static <T> Optional<T> parseJson(String json, Class<T> clazz) {
        try {
            return Optional.ofNullable(mapper.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public static <T> T parseJsonOrThrow(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Error parsing JSON a " + clazz.getSimpleName() + ": " + e.getOriginalMessage(), e);
        }
    }
}

